package com.unionyy.mobile.vivo.api

import android.content.Context

/**
 * vivo二期
 */
interface YY2VVUserPrivilegeAction {
    /**
     * 查询用户信息
     * data:
     * "vivoOpenid":12345677
     */
    fun queryUserInfo(
        context: Context,
        args: Map<String, String>,
        privilegeCallback: IUserPrivilegeCallback?
    )

    /**
     * 用户进场请求
     * data:
     *
         "sid": 123,  //频道号
        "cid": 123,  //子频道号
        "vivoOpenid":12345677  //进场用户id
     */
    fun requestUserPrivilege(
        context: Context,
        args: Map<String, String>,
        privilegeCallback: IUserPrivilegeCallback?
    )

    /**
     * 发送弹幕
     * data
     *
         "sid": 123,  //频道号
        "cid": 123,  //子频道号
        "vivoOpenid":12345677,  //发言用户
        "canColorfulNickName": true, //是否可以红色昵称
        "level": 51,// 用户等级
        "nickName": "vivo-用户",//用户昵称
        "color":0xfffffff, //弹幕颜色
        "message":"哈哈哈哈" //弹幕内容
     */
    fun sendBarrageReq(
        context: Context,
        args: Map<String, String>,
        privilegeCallback: IUserPrivilegeCallback?
    )
}

interface IUserPrivilegeCallback {
    fun onSuccess(data: String?) //成功
    fun onFail(error: String?)  //失败
}