package com.unionyy.mobile.vivo.api

import android.content.Context

/**
 * Created by 张宇 on 2019-11-12.
 * E-mail: zhangyu4@yy.com
 * YY: 909017428
 *
 * 向vivo申请动态权限
 */
interface YY2VVPermissionAction {

    /**
     * 申请权限
     *
     * @param permissions 以下权限一个或多个
     * - Manifest.permission.READ_PHONE_STATE
     * - Manifest.permission.WRITE_EXTERNAL_STORAGE
     * - Manifest.permission.READ_EXTERNAL_STORAGE
     * - Manifest.permission.INTERNET
     * - Manifest.permission.CAMERA
     *
     * @param onPass 申请权限成功
     * @param onFail 权限被拒绝
     */
    fun checkPermission(
        context: Context,
        permissions: List<String>,
        onPass: () -> Unit = {},
        onFail: () -> Unit = {}
    )
}