package com.unionyy.mobile.vivo.api

import android.app.Activity
import android.content.Context


/**
 * YY调用Vivo充值相关接口
 * queryBalance:查询余额
 * recharge:拉起充值页面
 */
interface YY2VVPayAction {
    fun queryBalance(
        context: Context,
        openId: String?,
        accessToken: String?,
        callback: QueryBalanceCallback
    ) //通过QueryBalanceCallback返回余额

    fun recharge(activity: Activity, callback: RechargeResultCallback) //通过RechargeResultCallback返回成功或者充值失败状态码.
}

interface QueryBalanceCallback {
    fun getBalanceSucc(balance: String) //余额
    fun getBalanceFailed()  //获取失败
}

interface RechargeResultCallback {
    fun onResult(isSucc: Boolean, errCode: Int)  //支付成功或者失败,成功code为0，取消为-1，其他为失败码
}