package com.unionyy.mobile.vivo.api

import android.app.Activity
import android.content.Context

/**
 * YY调用vivo修改用户信息引导相关接口
 *
 * Created by liyang on 2019-11-14
 * email: liyang4@yy.com
 */
interface YY2VVModifyInfoGuide {

    /**
     * 请求是否应该显示引导
     */
    fun queryShouldShowGuide(context: Context, callback: QueryShouldShowCallback)

    /**
     * 显示修改信息弹窗
     *
     * @param fromType 1:点击提示; 2:点击发言
     */
    fun showModifyInfoDialog(activity: Activity, callback: ModifyInfoCallback, fromType: Int)
}

interface QueryShouldShowCallback {

    companion object {
        const val MODIFIED_NOTHING = 0
        const val ONLY_MODIFIED_NICKNAME = 1
        const val ONLY_MODIFIED_PORTRAIT = 2
        const val MODIFIED_ALL = 3
    }

    /**
     * 返回查询结果
     *
     * @param result 0：昵称、头像均未修改，1：仅昵称未修改，2：仅头像未修改，3：昵称头像均已修改
     */
    fun onQueryResult(result: Int)
}

interface ModifyInfoCallback {

    /**
     * 返回修改结果
     *
     * @param hasModified true：已修改，false：为修改
     */
    fun onModifyResult(hasModified: Boolean)
}