package com.unionyy.mobile.vivo.api

import android.content.Context
import com.yy.mobile.baseapi.YY2UnionLoginAction

/**
 * Created by 张宇 on 2019-08-29.
 * E-mail: zhangyu4@yy.com
 * YY: 909017428
 *
 * 由 YY 调用，VIVO 实现的接口
 */
interface YY2VVLoginAction : YY2UnionLoginAction {

    /**
     * 拉起VIVO的登陆弹窗
     */
    override fun showLoginDialog(context: Context)

    /**
     * 获取token，未登录返回空
     */
    fun getOpenAccessToken(context: Context, callback: OpenTokenCallback)

    /**
     * Vivo账号是否已经登录
     */
    fun isVivoLogin(): Boolean

    /**
     * 获取校验登录信息的加密串
     */
    fun requestEncryptSequence(
        context: Context,
        openId: String?,
        accessToken: String?,
        callback: EncryptCallback
    )

    /**
     * 用vivo账号(openAccessToken)登录YY后，YY提供uid和ticket，用于绑定YY账号和vivo账号
     * 可选，可以空实现。
     */
    fun bindAfterLogin(uid: Long, ticket: String) {}
}

interface OpenTokenCallback {

    fun onResult(openAccessToken: String?)

    fun onFail(e: Exception)
}

interface EncryptCallback {

    fun onResult(encryptSequence: String)

    fun onFail(e: Exception)
}