package com.unionyy.mobile.vivo.api

import android.content.Context
import com.yy.mobile.baseapi.Union2YYChannelAction
import com.yy.mobile.baseapi.Union2YYChannelIntent

/**
 * Create by guananjie on 2019/8/27
 * E-mail: guananjie@yy.com
 * YY: 909042007
 */
interface VV2YYChannelAction: Union2YYChannelIntent, Union2YYChannelAction {

    /**
     * 进入频道
     * @param sid 一级频道号
     * @param ssid 二级频道号
     */
    override fun instance(sid: Long, ssid: Long): Union2YYChannelIntent.ChannelIntentBuilder

    /**
     * 首页进入直播间，设置频道列表
     */
    override fun setChannelList(channelList: String?)

    /**
     * 是否在直播间
     */
    override fun isInChannel(): Boolean

    /**
     * 获取直播间的上下文，
     * 需要 [isInChannel] 为true
     */
    override fun getChannelActivity(): Context?

    /**
     * 退直播间
     */
    override fun leaveChannel()
}