package com.unionyy.mobile.vivo.api

import com.yy.mobile.baseapi.AuthCallback
import com.yy.mobile.baseapi.Union2YYAuthAction

/**
 * Created by 张宇 on 2019-08-29.
 * E-mail: zhangyu4@yy.com
 * YY: 909017428
 *
 * 由 VIVO 调用， YY 实现的接口。
 */
interface VV2YYAuthAction : Union2YYAuthAction {

    /**
     * vivo账号绑定YY账号登陆。用户已经登陆vivo账号时调用。
     *
     * @param accessToken vivo授权凭证
     * @param callback 登陆结果回调
     */
    fun bindLogin(accessToken: String, callback: AuthCallback)

    /**
     * 登出当前 YY账号
     */
    override fun logout()

    /**
     * 是否登录着 YY账号
     */
    override fun isYYLogined(): Boolean

    /**
     * 如果 [isYYLogined] 为true时，可以获得 YY账号的 uid。否则为null
     */
    override fun getCurrentYYId(): Long?
}