package com.unionyy.mobile.vivo.api

import android.app.Activity
import android.content.Context

/**
 * 主播排行榜
 */
interface YY2VVAnchorRankAction {

    /**
     * 查询主播榜单信息
     * args： "sid","cid", "anchorUid"
     */
    fun queryAnchorRankInfo(
        context: Context,
        args: Map<String, String>,
        anchorRankCallback: IAnchorRankCallback?
    )

    /**
     * 展示主播排行榜单
     * args： "rankType","sid","cid", "anchorUid"
     */
    fun showAnchorRankDialog(
        activity: Activity,
        args: Map<String, String>,
        anchorRankCallback: IAnchorRankCallback?
    )
}

interface IAnchorRankCallback {
    fun onSuccess(data: String?) //成功
    fun onFail(error: String?)  //失败
}