/*
 * Decompiled with CFR 0.152.
 */
package com.yymobile.core.live.cache;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.util.Log;
import android.widget.ImageView;
import com.bumptech.glide.Glide;
import com.bumptech.glide.request.BaseRequestOptions;
import com.bumptech.glide.request.RequestListener;
import com.bumptech.glide.request.RequestOptions;
import com.bumptech.glide.request.target.SimpleTarget;
import com.bumptech.glide.request.target.Target;
import com.yy.mobile.util.log.MLog;
import com.yymobile.core.live.cache.HPCacheHelper;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\rJ>\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\r2\u000e\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u000f2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00100\u0012H\u0007J\u001e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u0014J\b\u0010\u0015\u001a\u00020\bH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/yymobile/core/live/cache/HpImageLoader;", "", "()V", "TAG", "", "markData", "", "loadImage", "", "view", "Landroid/widget/ImageView;", "url", "options", "Lcom/bumptech/glide/request/RequestOptions;", "listener", "Lcom/bumptech/glide/request/RequestListener;", "Landroid/graphics/Bitmap;", "target", "Lcom/bumptech/glide/request/target/SimpleTarget;", "placeHolder", "", "mark", "sdkwrapper_release"})
public final class HpImageLoader {
    private static boolean markData;
    private static final String TAG = "HpImageLoader";
    public static final HpImageLoader INSTANCE;

    public final void loadImage(@NotNull ImageView view, @NotNull String url, @NotNull RequestOptions options) {
        Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        Intrinsics.checkParameterIsNotNull((Object)options, (String)"options");
        Context context = view.getContext();
        String convertUrl = url;
        Bitmap bitMapCache = HPCacheHelper.INSTANCE.getSimpleCache(convertUrl);
        boolean valid = false;
        if (bitMapCache != null && !bitMapCache.isRecycled()) {
            options.placeholder((Drawable)new BitmapDrawable(bitMapCache));
            valid = true;
        }
        Log.d((String)TAG, (String)("cache_null:" + (bitMapCache == null) + " valid:" + valid + ' ' + convertUrl));
        Glide.with((Context)context).load(convertUrl).apply((BaseRequestOptions)options).into(view);
        this.mark();
    }

    public final void loadImage(@NotNull ImageView view, @NotNull String url, int placeHolder) {
        Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        BaseRequestOptions baseRequestOptions = new RequestOptions().placeholder(placeHolder);
        Intrinsics.checkExpressionValueIsNotNull((Object)baseRequestOptions, (String)"RequestOptions().placeholder(placeHolder)");
        this.loadImage(view, url, (RequestOptions)baseRequestOptions);
    }

    @SuppressLint(value={"CheckResult"})
    public final void loadImage(@NotNull ImageView view, @NotNull String url, @NotNull RequestOptions options, @Nullable RequestListener<Bitmap> listener, @NotNull SimpleTarget<Bitmap> target) {
        Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        Intrinsics.checkParameterIsNotNull((Object)options, (String)"options");
        Intrinsics.checkParameterIsNotNull(target, (String)"target");
        Context context = view.getContext();
        String convertUrl = url;
        Bitmap bitMapCache = HPCacheHelper.INSTANCE.getSimpleCache(convertUrl);
        boolean valid = false;
        if (bitMapCache != null && !bitMapCache.isRecycled()) {
            options.placeholder((Drawable)new BitmapDrawable(bitMapCache));
            valid = true;
        }
        if (StringsKt.contains$default((CharSequence)convertUrl, (CharSequence)".gif", (boolean)false, (int)2, null)) {
            MLog.error((Object)TAG, (String)"load gif as bitmap?", (Object[])new Object[0]);
        }
        Log.d((String)TAG, (String)("cache_null:" + (bitMapCache == null) + " valid:" + valid + ' ' + convertUrl));
        Glide.with((Context)context).asBitmap().load(convertUrl).apply((BaseRequestOptions)options).listener(listener).into((Target)target);
        this.mark();
    }

    private final void mark() {
        if (!markData) {
            markData = true;
        }
    }

    private HpImageLoader() {
    }

    static {
        HpImageLoader hpImageLoader;
        INSTANCE = hpImageLoader = new HpImageLoader();
    }
}

