/*
 * Decompiled with CFR 0.152.
 */
package com.yymobile.core.live.cache;

import android.content.Context;
import android.graphics.Bitmap;
import android.os.Build;
import android.text.TextUtils;
import android.util.Log;
import com.bumptech.glide.Glide;
import com.bumptech.glide.Registry;
import com.bumptech.glide.load.Encoder;
import com.bumptech.glide.load.Key;
import com.bumptech.glide.load.Options;
import com.bumptech.glide.load.engine.bitmap_recycle.ArrayPool;
import com.bumptech.glide.load.engine.cache.DiskCache;
import com.bumptech.glide.load.model.GlideUrl;
import com.bumptech.glide.load.model.Headers;
import com.bumptech.glide.load.model.LazyHeaders;
import com.bumptech.glide.load.model.StreamEncoder;
import com.bumptech.glide.load.resource.bitmap.BitmapResource;
import com.bumptech.glide.load.resource.bitmap.ByteBufferBitmapDecoder;
import com.bumptech.glide.provider.ResourceDecoderRegistry;
import com.bumptech.glide.signature.EmptySignature;
import com.bumptech.glide.util.ByteBufferUtil;
import com.bumptech.glide.util.ContentLengthInputStream;
import com.bumptech.glide.util.LogTime;
import com.bumptech.glide.util.Preconditions;
import com.yy.mobile.config.BasicConfig;
import com.yy.mobile.http.BaseHttpClient;
import com.yy.mobile.imageloader.glide.DataCacheKey;
import com.yy.mobile.util.log.MLog;
import com.yymobile.core.live.cache.DataCacheWriter;
import com.yymobile.core.live.cache.HPCacheHelper;
import com.yymobile.core.live.cache.IHPPreCache;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import kotlin.text.StringsKt;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u009a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\u001e\u001a\u0012\u0012\u0004\u0012\u00020\u00040\u001fj\b\u0012\u0004\u0012\u00020\u0004` 2\f\u0010!\u001a\b\u0012\u0002\b\u0003\u0018\u00010\"H\u0002J\u0018\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u00042\u0006\u0010&\u001a\u00020'H\u0002J\u0010\u0010(\u001a\u00020$2\u0006\u0010%\u001a\u00020\u0004H\u0002J\u001b\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00060*2\u0006\u0010%\u001a\u00020\u0004H\u0002\u00a2\u0006\u0002\u0010+J\u0010\u0010,\u001a\u00020\u00062\u0006\u0010-\u001a\u00020\u0006H\u0002J\u001c\u0010.\u001a\u0004\u0018\u00010/2\b\u00100\u001a\u0004\u0018\u00010/2\u0006\u00101\u001a\u00020\u0004H\u0002J\u0010\u00102\u001a\u0004\u0018\u00010\u00122\u0006\u00103\u001a\u00020\u0004J\u001c\u00104\u001a\u00020$2\b\u00105\u001a\u0004\u0018\u0001062\b\u00107\u001a\u0004\u0018\u000108H\u0016J\u001c\u00109\u001a\u00020$2\b\u00105\u001a\u0004\u0018\u0001062\b\u0010:\u001a\u0004\u0018\u00010;H\u0016J\u0006\u0010<\u001a\u00020$R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0007\u001a\u00020\b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\t\u0010\nR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000RN\u0010\u000f\u001aB\u0012\f\u0012\n \u0011*\u0004\u0018\u00010\u00040\u0004\u0012\f\u0012\n \u0011*\u0004\u0018\u00010\u00120\u0012 \u0011* \u0012\f\u0012\n \u0011*\u0004\u0018\u00010\u00040\u0004\u0012\f\u0012\n \u0011*\u0004\u0018\u00010\u00120\u0012\u0018\u00010\u00130\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0014\u001a\n \u0011*\u0004\u0018\u00010\u00150\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001c\u001a\n \u0011*\u0004\u0018\u00010\u001d0\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006="}, d2={"Lcom/yymobile/core/live/cache/HPCacheHelper;", "Lokhttp3/Callback;", "()V", "TAG", "", "THRESHOLD", "", "arrayPool", "Lcom/bumptech/glide/load/engine/bitmap_recycle/ArrayPool;", "getArrayPool", "()Lcom/bumptech/glide/load/engine/bitmap_recycle/ArrayPool;", "arrayPool$delegate", "Lkotlin/Lazy;", "atomBoolean", "Ljava/util/concurrent/atomic/AtomicBoolean;", "bitmapMap", "", "kotlin.jvm.PlatformType", "Landroid/graphics/Bitmap;", "", "client", "Lokhttp3/OkHttpClient;", "decoder", "Lcom/bumptech/glide/load/resource/bitmap/ByteBufferBitmapDecoder;", "diskCache", "Lcom/bumptech/glide/load/engine/cache/DiskCache;", "enableFunctions", "", "pattern", "Ljava/util/regex/Pattern;", "collectUrls", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "list", "", "extractBitmapFromFile", "", "url", "file", "Ljava/io/File;", "fetchData", "getDimensionFromUrl", "", "(Ljava/lang/String;)[Ljava/lang/Integer;", "getMaxCntByType", "type", "getObject", "", "o", "fieldName", "getSimpleCache", "key", "onFailure", "call", "Lokhttp3/Call;", "e", "Ljava/io/IOException;", "onResponse", "response", "Lokhttp3/Response;", "prepareGlideObjects", "sdkwrapper_release"})
public final class HPCacheHelper
implements Callback {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    private static final Pattern pattern;
    private static final Map<String, Bitmap> bitmapMap;
    private static final String TAG = "HPCacheHelper";
    private static final int THRESHOLD = 8;
    private static final OkHttpClient client;
    private static DiskCache diskCache;
    private static ByteBufferBitmapDecoder decoder;
    private static final Lazy arrayPool$delegate;
    private static final AtomicBoolean atomBoolean;
    private static boolean enableFunctions;
    public static final HPCacheHelper INSTANCE;

    static {
        HPCacheHelper hPCacheHelper;
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(HPCacheHelper.class), "arrayPool", "getArrayPool()Lcom/bumptech/glide/load/engine/bitmap_recycle/ArrayPool;"))};
        INSTANCE = hPCacheHelper = new HPCacheHelper();
        pattern = Pattern.compile("(/w/[0-9]{0,4}/h/[0-9]{0,4})");
        bitmapMap = Collections.synchronizedMap(new LinkedHashMap());
        client = BaseHttpClient.getOkHttpClient();
        arrayPool$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)arrayPool.2.INSTANCE);
        atomBoolean = new AtomicBoolean(false);
        enableFunctions = true;
    }

    private final ArrayPool getArrayPool() {
        Lazy lazy = arrayPool$delegate;
        HPCacheHelper hPCacheHelper = this;
        KProperty kProperty = $$delegatedProperties[0];
        boolean bl = false;
        return (ArrayPool)lazy.getValue();
    }

    public final void prepareGlideObjects() {
        if (!enableFunctions) {
            return;
        }
        long t = LogTime.getLogTime();
        BasicConfig basicConfig = BasicConfig.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)basicConfig, (String)"BasicConfig.getInstance()");
        Glide glide = Glide.get((Context)basicConfig.getAppContext());
        Intrinsics.checkExpressionValueIsNotNull((Object)glide, (String)"Glide.get(BasicConfig.getInstance().appContext)");
        Glide glide2 = glide;
        if (diskCache == null) {
            Method method;
            Object engine = this.getObject(glide2, "engine");
            Object object = this.getObject(engine, "diskCacheProvider");
            if (object == null) {
                Intrinsics.throwNpe();
            }
            Object diskCacheProvider = object;
            Method method2 = method = diskCacheProvider.getClass().getDeclaredMethod("getDiskCache", new Class[0]);
            Intrinsics.checkExpressionValueIsNotNull((Object)method2, (String)"method");
            method2.setAccessible(true);
            Object object2 = method.invoke(diskCacheProvider, new Object[0]);
            if (object2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.bumptech.glide.load.engine.cache.DiskCache");
            }
            diskCache = (DiskCache)object2;
        }
        if (decoder == null) {
            Registry registry = glide2.getRegistry();
            Intrinsics.checkExpressionValueIsNotNull((Object)registry, (String)"glide.registry");
            Registry registry2 = registry;
            Object object = this.getObject(registry2, "decoderRegistry");
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.bumptech.glide.provider.ResourceDecoderRegistry");
            }
            ResourceDecoderRegistry decoderRegistry = (ResourceDecoderRegistry)object;
            Object object3 = this.getObject(decoderRegistry, "decoders");
            if (object3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.HashMap<*, *> /* = java.util.HashMap<*, *> */");
            }
            HashMap map = (HashMap)object3;
            Map map2 = map;
            String string2 = "Bitmap";
            boolean bl = false;
            Object v = map2.get(string2);
            if (v == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.List<*>");
            }
            List list = (List)v;
            Object o = list.get(0);
            Object object4 = this.getObject(o, "decoder");
            if (object4 == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.bumptech.glide.load.resource.bitmap.ByteBufferBitmapDecoder");
            }
            decoder = (ByteBufferBitmapDecoder)object4;
        }
        MLog.debug((Object)TAG, (String)("prepareGlideObjects:" + LogTime.getElapsedMillis((long)t)), (Object[])new Object[0]);
        try {
            t = LogTime.getLogTime();
            GlideUrl url = new GlideUrl("http://emyfs.bs2cdn.yy.com/fake_pic.jpg");
            DataCacheKey dataCacheKey = new DataCacheKey((Key)url, (Key)EmptySignature.obtain());
            DiskCache diskCache = HPCacheHelper.diskCache;
            if (diskCache != null) {
                diskCache.get((Key)dataCacheKey);
            }
            MLog.debug((Object)TAG, (String)("_load_fake_pic:" + LogTime.getElapsedMillis((long)t)), (Object[])new Object[0]);
        }
        catch (Throwable e) {
            Log.d((String)TAG, (String)("cold load :" + e));
        }
    }

    @Nullable
    public final Bitmap getSimpleCache(@NotNull String key) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        if (!enableFunctions) {
            return null;
        }
        return bitmapMap.remove(key);
    }

    private final int getMaxCntByType(int type2) {
        int n;
        switch (type2) {
            case 1006: {
                n = 1;
                break;
            }
            case 1001: {
                n = 1;
                break;
            }
            case 1118: {
                n = 3;
                break;
            }
            case 1005: {
                n = 2;
                break;
            }
            case 2023: {
                n = 2;
                break;
            }
            case 2010: {
                n = 3;
                break;
            }
            default: {
                n = 1;
            }
        }
        return n;
    }

    private final void fetchData(String url) {
        Headers builder;
        Request.Builder requestBuilder = new Request.Builder().url(url);
        Headers headers = builder = LazyHeaders.DEFAULT;
        Intrinsics.checkExpressionValueIsNotNull((Object)headers, (String)"builder");
        Map map = headers.getHeaders();
        Intrinsics.checkExpressionValueIsNotNull((Object)map, (String)"builder.headers");
        Map map2 = map;
        boolean bl = false;
        Iterator iterator = map2.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry;
            Map.Entry entry2 = entry = iterator.next();
            boolean bl2 = false;
            String key = (String)entry2.getKey();
            entry2 = entry;
            bl2 = false;
            String value = (String)entry2.getValue();
            requestBuilder.addHeader(key, value);
        }
        Request request = requestBuilder.build();
        client.newCall(request).enqueue((Callback)this);
    }

    private final void extractBitmapFromFile(String url, File file) {
        try {
            BitmapResource result;
            Integer[] dimen = this.getDimensionFromUrl(url);
            ByteBufferBitmapDecoder byteBufferBitmapDecoder = decoder;
            BitmapResource bitmapResource = result = (BitmapResource)(byteBufferBitmapDecoder != null ? byteBufferBitmapDecoder.decode(ByteBufferUtil.fromFile((File)file), dimen[0].intValue(), dimen[1].intValue(), new Options()) : null);
            if (bitmapResource == null) {
                Intrinsics.throwNpe();
            }
            bitmapResource.initialize();
            Map<String, Bitmap> map = bitmapMap;
            Intrinsics.checkExpressionValueIsNotNull(map, (String)"bitmapMap");
            map.put(url, result.get());
            if (Build.VERSION.SDK_INT >= 19) {
                StringBuilder stringBuilder = new StringBuilder().append("allocationByteCount:");
                Bitmap bitmap = bitmapMap.get(url);
                if (bitmap == null) {
                    Intrinsics.throwNpe();
                }
                Log.d((String)TAG, (String)stringBuilder.append((double)bitmap.getAllocationByteCount() / 1024.0).toString());
            }
        }
        catch (Throwable e) {
            Log.e((String)TAG, (String)("init result failed:" + e));
        }
    }

    private final Integer[] getDimensionFromUrl(String url) {
        int[] array = CollectionsKt.toIntArray((Collection)CollectionsKt.listOf((Object[])new Integer[]{100, 100}));
        Matcher matcher = pattern.matcher(url);
        if (matcher.find()) {
            List ret;
            String string2 = matcher.group(1);
            List list = string2 != null && (string2 = StringsKt.replace$default((String)string2, (String)"/w/", (String)"", (boolean)false, (int)4, null)) != null && (string2 = StringsKt.replace$default((String)string2, (String)"/h/", (String)"-", (boolean)false, (int)4, null)) != null ? StringsKt.split$default((CharSequence)string2, (String[])new String[]{"-"}, (boolean)false, (int)0, (int)6, null) : (ret = null);
            if (ret != null && ret.size() == 2) {
                int n;
                int[] nArray;
                int n2;
                String string3 = (String)ret.get(0);
                boolean bl = false;
                String string4 = string3;
                if (string4 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
                }
                String w = ((Object)StringsKt.trim((CharSequence)string4)).toString();
                if (TextUtils.isDigitsOnly((CharSequence)w)) {
                    string3 = w;
                    n2 = 0;
                    nArray = array;
                    bl = false;
                    nArray[n2] = n = Integer.parseInt(string3);
                }
                String string5 = (String)ret.get(1);
                boolean bl2 = false;
                String string6 = string5;
                if (string6 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
                }
                String h = ((Object)StringsKt.trim((CharSequence)string6)).toString();
                if (TextUtils.isDigitsOnly((CharSequence)h)) {
                    string5 = h;
                    n2 = 1;
                    nArray = array;
                    bl2 = false;
                    nArray[n2] = n = Integer.parseInt(string5);
                }
            }
        }
        return ArraysKt.toTypedArray((int[])array);
    }

    public void onFailure(@Nullable Call call, @Nullable IOException e) {
        MLog.debug((Object)TAG, (String)"OkHttp failed to obtain result", (Object[])new Object[]{e});
    }

    public void onResponse(@Nullable Call call, @Nullable Response response) {
        ResponseBody responseBody;
        long t = LogTime.getLogTime();
        Response response2 = response;
        Object object = responseBody = response2 != null ? response2.body() : null;
        if (response != null && response.isSuccessful() && responseBody != null) {
            File file;
            Call call2 = call;
            GlideUrl uri = new GlideUrl(String.valueOf(call2 != null && (call2 = call2.request()) != null ? call2.url() : null));
            long contentLength = ((ResponseBody)Preconditions.checkNotNull((Object)responseBody)).contentLength();
            InputStream inputStream = ContentLengthInputStream.obtain((InputStream)responseBody.byteStream(), (long)contentLength);
            Intrinsics.checkExpressionValueIsNotNull((Object)inputStream, (String)"ContentLengthInputStream\u2026eStream(), contentLength)");
            InputStream stream = inputStream;
            StreamEncoder encoder = new StreamEncoder(this.getArrayPool());
            DataCacheWriter<InputStream> writer = new DataCacheWriter<InputStream>((Encoder)encoder, stream, new Options());
            DataCacheKey originalKey = new DataCacheKey((Key)uri, (Key)EmptySignature.obtain());
            DiskCache diskCache = HPCacheHelper.diskCache;
            if (diskCache != null) {
                diskCache.put((Key)originalKey, (DiskCache.Writer)writer);
            }
            DiskCache diskCache2 = HPCacheHelper.diskCache;
            File file2 = file = diskCache2 != null ? diskCache2.get((Key)uri) : null;
            if (file != null) {
                String string2 = uri.toStringUrl();
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"uri.toStringUrl()");
                this.extractBitmapFromFile(string2, file);
                MLog.debug((Object)TAG, (String)("download new image good, " + (bitmapMap.get(uri.toStringUrl()) == null) + ' ' + (String.valueOf(LogTime.getElapsedMillis((long)t)) + ",url:" + uri)), (Object[])new Object[0]);
            } else {
                MLog.debug((Object)TAG, (String)("download new image failed," + (String.valueOf(LogTime.getElapsedMillis((long)t)) + ",err xxxxxx:" + uri)), (Object[])new Object[0]);
            }
        } else {
            MLog.debug((Object)TAG, (String)"OkHttp failed to obtain result", (Object[])new Object[0]);
        }
    }

    private final ArrayList<String> collectUrls(List<?> list) {
        if (list == null) {
            return new ArrayList<String>();
        }
        ArrayList<String> urlList = new ArrayList<String>();
        for (Object o : list) {
            if (o instanceof IHPPreCache) {
                urlList.addAll((Collection<String>)((IHPPreCache)o).getUrls());
                continue;
            }
            if (!(o instanceof List)) continue;
            urlList.addAll((Collection<String>)this.collectUrls((List)o));
        }
        return urlList;
    }

    private final Object getObject(Object o, String fieldName) {
        try {
            Field field;
            Class<?> clazz = o;
            Field field2 = field = clazz != null && (clazz = clazz.getClass()) != null ? clazz.getDeclaredField(fieldName) : null;
            if (field2 != null) {
                field2.setAccessible(true);
            }
            Field field3 = field;
            return field3 != null ? field3.get(o) : null;
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return null;
    }

    private HPCacheHelper() {
    }
}

