/*
 * Decompiled with CFR 0.152.
 */
package com.yymobile.core;

import android.os.Looper;
import android.util.Log;
import com.yy.android.sniper.api.darts.DartsApi;
import com.yy.mobile.config.BasicConfig;
import com.yy.mobile.util.log.MLog;

public class CoreFactory {
    private static final String TAG = "CoreFactory";
    private static final boolean DEBUG = BasicConfig.getInstance().isDebuggable();

    public static <T> T getCore(Class<T> cls) {
        if (cls == null) {
            return null;
        }
        long t = 0L;
        if (DEBUG) {
            t = System.currentTimeMillis();
        }
        Object core = DartsApi.getDartsNullable(cls);
        if (DEBUG) {
            long del = System.currentTimeMillis() - t;
            if (t != 0L && del > 15L && Thread.currentThread() == Looper.getMainLooper().getThread()) {
                Log.e((String)TAG, (String)("clz init<> in main thread cost much time? " + cls + ":" + del + "ms"));
            }
        }
        if (core == null) {
            MLog.info((Object)"CoreFactory[getCore]", (String)("getCore from old method --> core = " + cls), (Object[])new Object[0]);
        }
        return (T)core;
    }
}

