/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.util.diff;

import com.yy.mobile.util.diff.Triple;
import com.yy.mobile.util.diff.Tuple;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public final class Differences {
    public static <T> Triple<List<T>, List<T>, List<T>> eval(List<T> lhs, List<T> rhs) {
        if (lhs == null) {
            lhs = new ArrayList<T>();
        }
        if (rhs == null) {
            rhs = new ArrayList<T>();
        }
        ArrayList<T> same = new ArrayList<T>();
        ArrayList<T> diffLHS = new ArrayList<T>();
        ArrayList<T> diffRHS = new ArrayList<T>();
        for (T l : lhs) {
            if (rhs.contains(l)) {
                same.add(l);
                continue;
            }
            diffLHS.add(l);
        }
        for (T r : rhs) {
            if (same.contains(r)) continue;
            diffRHS.add(r);
        }
        return new Triple<List<T>, List<T>, List<T>>(diffLHS, same, diffRHS);
    }

    public static <T> Triple<Set<T>, Set<T>, Set<T>> eval(Set<T> lhs, Set<T> rhs, DiffOption diffOption) {
        if (lhs == null) {
            lhs = new HashSet<T>();
        }
        if (rhs == null) {
            rhs = new HashSet<T>();
        }
        HashSet<T> same = new HashSet<T>();
        HashSet<T> diffLHS = new HashSet<T>();
        HashSet<T> diffRHS = new HashSet<T>();
        for (T l : lhs) {
            if (Differences.contains(rhs, l, diffOption)) {
                same.add(l);
                continue;
            }
            diffLHS.add(l);
        }
        for (T r : rhs) {
            if (Differences.contains(same, r, diffOption)) continue;
            diffRHS.add(r);
        }
        return new Triple<Set<T>, Set<T>, Set<T>>(diffLHS, same, diffRHS);
    }

    public static <T> Tuple<Set<T>, Set<T>> updateCheck(Set<T> lhs, Set<T> rhs, DiffOption diffOption) {
        HashSet<T> from = new HashSet<T>();
        HashSet<T> to = new HashSet<T>();
        if (lhs == null) {
            lhs = new HashSet<T>();
        }
        if (rhs == null) {
            rhs = new HashSet<T>();
        }
        for (T r : rhs) {
            T l = Differences.didAccept(lhs, r, diffOption);
            if (l == null) continue;
            from.add(l);
            to.add(r);
        }
        return new Tuple<Set<T>, Set<T>>(from, to);
    }

    private static <T> T didAccept(Set<T> sets, T obj, DiffOption option) {
        for (T s : sets) {
            if (!s.equals(obj) || !option.accept(s, obj)) continue;
            return s;
        }
        return null;
    }

    private static <T> boolean contains(Set<T> sets, T obj, DiffOption option) {
        for (T s : sets) {
            if (!option.accept(s, obj)) continue;
            return true;
        }
        return false;
    }

    public static interface DiffOption<T> {
        public boolean accept(T var1, T var2);
    }
}

