/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.widget;

import android.content.Context;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.yy.mobile.sdkwrapper.R;

public class StatusLayout
extends RelativeLayout {
    private TextView mLoadingMore;
    private View mLoadingContainer;
    private View mProgress;

    public StatusLayout(Context context) {
        super(context);
    }

    public StatusLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public StatusLayout(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        this.addLoadingFooter();
        this.addStatus();
    }

    private void addLoadingFooter() {
        View status = LayoutInflater.from((Context)this.getContext()).inflate(R.layout.layout_loading_more, null);
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-1, -2);
        params.addRule(12);
        status.setVisibility(8);
        this.addView(status, this.getChildCount(), (ViewGroup.LayoutParams)params);
        this.mLoadingMore = (TextView)this.findViewById(R.id.loading_text);
        this.mLoadingContainer = this.findViewById(R.id.loading_more);
        this.mProgress = this.findViewById(R.id.loading_progress);
    }

    private void addStatus() {
        View status = LayoutInflater.from((Context)this.getContext()).inflate(R.layout.layout_status_container, null);
        this.addView(status, this.getChildCount(), (ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(-1, -1));
    }

    public void showErrorPage(int tips, View.OnClickListener listener) {
        if (this.mLoadingMore == null) {
            return;
        }
        if (tips <= 0) {
            tips = R.string.click_or_pull_refresh;
        }
        String text = this.getContext().getString(tips);
        this.mLoadingMore.setText((CharSequence)text);
        this.mLoadingContainer.setOnClickListener(listener);
        this.mProgress.setVisibility(8);
        this.mLoadingContainer.setVisibility(0);
    }

    public void showLoadMore() {
        if (this.mLoadingMore != null) {
            this.mLoadingMore.setText((CharSequence)this.getContext().getString(R.string.loading));
        }
        if (this.mProgress != null) {
            this.mProgress.setVisibility(0);
        }
        if (this.mLoadingContainer != null) {
            this.mLoadingContainer.setOnClickListener(null);
            this.mLoadingContainer.setVisibility(0);
        }
    }

    public void hideLoadMore() {
        this.mLoadingContainer.setVisibility(8);
    }
}

