/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.common;

import android.annotation.TargetApi;
import android.content.Context;
import android.os.Build;
import android.os.Bundle;
import android.view.InflateException;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import com.yy.mobile.sdkwrapper.R;
import com.yy.mobile.ui.common.AbsStatusFragment;
import com.yy.mobile.util.NetworkUtils;
import com.yy.mobile.util.log.MLog;

public class ReloadFragment
extends AbsStatusFragment {
    private static final String TAG = "ReloadFragment";
    private static final String TIP_PARAM = "TIP_PARAM";
    private static final String DRAWABLE_PARAM = "DRAWABLE_PARAM";
    private int mTip;
    private int mDrawable;
    private View.OnClickListener mSelfListener = new View.OnClickListener(){

        public void onClick(View v) {
            if (!ReloadFragment.this.checkActivityValid()) {
                return;
            }
            if (!NetworkUtils.isNetworkStrictlyAvailable((Context)ReloadFragment.this.getActivity())) {
                ReloadFragment.this.checkNetToast();
                return;
            }
            if (ReloadFragment.this.mLoadListener != null) {
                ReloadFragment.this.mLoadListener.onClick(v);
            }
        }
    };

    public static ReloadFragment newInstance() {
        return new ReloadFragment();
    }

    public static ReloadFragment newInstance(int drawable2, int tips) {
        Bundle bundle = new Bundle();
        bundle.putInt(TIP_PARAM, tips);
        bundle.putInt(DRAWABLE_PARAM, drawable2);
        ReloadFragment fragment = new ReloadFragment();
        fragment.setArguments(bundle);
        return fragment;
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View view = null;
        try {
            view = LayoutInflater.from((Context)this.getActivity()).inflate(R.layout.fragment_reload, container, false);
        }
        catch (InflateException e) {
            MLog.error((Object)TAG, (String)"onCreateView", (Throwable)e, (Object[])new Object[0]);
            return view;
        }
        catch (OutOfMemoryError e) {
            MLog.error((Object)TAG, (String)"onCreateView", (Throwable)e, (Object[])new Object[0]);
            return view;
        }
        catch (Exception e) {
            MLog.error((Object)TAG, (String)"onCreateView", (Throwable)e, (Object[])new Object[0]);
            return view;
        }
        if (savedInstanceState != null) {
            this.mTip = savedInstanceState.getInt(TIP_PARAM, R.string.click_screen_reload);
            this.mDrawable = savedInstanceState.getInt(DRAWABLE_PARAM, R.drawable.icon_error);
        } else {
            Bundle bundle = this.getArguments();
            if (bundle != null) {
                this.mTip = bundle.getInt(TIP_PARAM, R.string.click_screen_reload);
                this.mDrawable = bundle.getInt(DRAWABLE_PARAM, R.drawable.icon_error);
            } else {
                this.mTip = R.string.click_screen_reload;
                this.mDrawable = R.drawable.icon_error;
            }
        }
        if (this.mTip <= 0) {
            this.mTip = R.string.click_screen_reload;
        }
        if (this.mDrawable <= 0) {
            this.mDrawable = R.drawable.icon_error;
        }
        ImageView imageView = (ImageView)view.findViewById(R.id.reload_icon);
        imageView.setImageResource(this.mDrawable);
        TextView textView = (TextView)view.findViewById(R.id.error_text);
        textView.setText((CharSequence)this.getString(this.mTip));
        view.setOnClickListener(this.mSelfListener);
        return view;
    }

    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putInt(TIP_PARAM, this.mTip);
        outState.putInt(DRAWABLE_PARAM, this.mDrawable);
    }

    @TargetApi(value=17)
    protected boolean checkActivityValid() {
        if (this.getActivity() == null) {
            MLog.warn((Object)TAG, (String)("Fragment " + this + " not attached to Activity"), (Object[])new Object[0]);
            return false;
        }
        if (this.getActivity().isFinishing()) {
            MLog.warn((Object)TAG, (String)"activity is finishing", (Object[])new Object[0]);
            return false;
        }
        if (Build.VERSION.SDK_INT >= 17 && this.getActivity().isDestroyed()) {
            MLog.warn((Object)TAG, (String)"activity is isDestroyed", (Object[])new Object[0]);
            return false;
        }
        return true;
    }
}

