/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.common;

import android.content.Context;
import android.content.res.Resources;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import com.yy.mobile.sdkwrapper.R;
import com.yy.mobile.ui.common.AbsStatusFragment;
import com.yy.mobile.util.log.MLog;

public class LoadingFragment
extends AbsStatusFragment {
    private static final String TIP_PARAM = "TIP_PARAM";
    private static final String DRAWABLE_PARAM = "DRAWABLE_PARAM";
    private static final String BACKGROUND_COLOR_PARAM = "BACKGROUND_COLOR_PARAM";
    private static final String TAG = "LoadingFragment";
    private int mTip;
    private int mDrawable;
    private int mBackgroundColor;

    public static LoadingFragment newInstance() {
        return new LoadingFragment();
    }

    public static LoadingFragment newInstance(int drawable2, int tips) {
        Bundle bundle = new Bundle();
        bundle.putInt(TIP_PARAM, tips);
        bundle.putInt(DRAWABLE_PARAM, drawable2);
        LoadingFragment fragment = new LoadingFragment();
        fragment.setArguments(bundle);
        return fragment;
    }

    public static LoadingFragment newInstance(int drawable2, int tips, int backgroundColor) {
        Bundle bundle = new Bundle();
        bundle.putInt(TIP_PARAM, tips);
        bundle.putInt(DRAWABLE_PARAM, drawable2);
        bundle.putInt(BACKGROUND_COLOR_PARAM, backgroundColor);
        LoadingFragment fragment = new LoadingFragment();
        fragment.setArguments(bundle);
        return fragment;
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View view = LayoutInflater.from((Context)this.getActivity()).inflate(R.layout.mn_fragment_loading, container, false);
        if (savedInstanceState != null) {
            this.mTip = savedInstanceState.getInt(TIP_PARAM, R.string.loading);
            this.mDrawable = savedInstanceState.getInt(DRAWABLE_PARAM, R.drawable.loading_img);
            this.mBackgroundColor = savedInstanceState.getInt(BACKGROUND_COLOR_PARAM, this.getResources().getColor(R.color.common_color_2));
        } else {
            Bundle bundle = this.getArguments();
            if (bundle != null) {
                this.mTip = bundle.getInt(TIP_PARAM, R.string.loading);
                this.mDrawable = bundle.getInt(DRAWABLE_PARAM, R.drawable.loading_img);
                this.mBackgroundColor = bundle.getInt(BACKGROUND_COLOR_PARAM, this.getResources().getColor(R.color.common_color_2));
            } else {
                this.mTip = R.string.loading;
            }
        }
        if (this.mTip > 0) {
            TextView textView = (TextView)view.findViewById(R.id.loading_text);
            try {
                textView.setText((CharSequence)this.getString(this.mTip));
            }
            catch (Resources.NotFoundException nfe) {
                MLog.error((Object)TAG, (Throwable)nfe);
            }
            textView.setVisibility(0);
        }
        if (this.mDrawable > 0) {
            ImageView imageView = (ImageView)view.findViewById(R.id.loadingIv);
            try {
                imageView.setImageResource(this.mDrawable);
            }
            catch (Resources.NotFoundException nfe) {
                MLog.error((Object)TAG, (Throwable)nfe);
            }
            imageView.setVisibility(0);
        }
        if (this.mBackgroundColor > 0) {
            try {
                view.setBackgroundColor(this.mBackgroundColor);
            }
            catch (Resources.NotFoundException nfe) {
                MLog.error((Object)TAG, (Throwable)nfe);
            }
        }
        return view;
    }

    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putInt(TIP_PARAM, this.mTip);
        outState.putInt(DRAWABLE_PARAM, this.mDrawable);
        outState.putInt(BACKGROUND_COLOR_PARAM, this.mBackgroundColor);
    }
}

