/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.sdkwrapper.yylive.media.ui;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.SurfaceView;
import android.view.View;
import com.yy.mobile.sdkwrapper.R;
import com.yy.mobile.sdkwrapper.yylive.media.IYYVideoViewExt;
import com.yy.mobile.sdkwrapper.yylive.media.YYVideoStreamInfo;
import com.yy.mobile.sdkwrapper.yylive.media.ui.YMultiVideoViewParamsWrapper;
import com.yy.mobile.sdkwrapper.yylive.media.ui.YVideoViewLayoutWrapper;
import com.yy.mobile.sdkwrapper.yylive.utils.ConstantsWrapper;
import com.yy.mobile.util.FP;
import com.yy.videoplayer.videoview.VideoPosition;
import com.yymobile.core.media.IYYVideoView;
import java.util.HashMap;
import java.util.Map;

public class YYVideoView
extends YVideoViewLayoutWrapper
implements IYYVideoViewExt {
    private int idx = 0;
    private IYYVideoView.VideoState videoState = IYYVideoView.VideoState.Video_NULL;
    private YYVideoStreamInfo stream;
    private ConstantsWrapper.ScaleMode scaleMode;
    private int maxPreviewStreamSize = 1;
    private Map<YYVideoStreamInfo, Integer> streamAndIndexs = new HashMap<YYVideoStreamInfo, Integer>();
    private boolean isMultipleVideoView;
    private VideoPosition[] videoPositions;

    public VideoPosition[] getVideoPositions() {
        return this.videoPositions;
    }

    public YYVideoView(Context context) {
        super(context);
    }

    public YYVideoView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public YYVideoView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.style_videoview, defStyle, 0);
        this.idx = a.getInt(R.styleable.style_videoview_idxAttr, 0);
        a.recycle();
    }

    @Override
    public IYYVideoView.VideoState getVideoState() {
        return this.videoState;
    }

    @Override
    public void setVideoState(IYYVideoView.VideoState videoState) {
        this.videoState = videoState;
    }

    @Override
    public YYVideoStreamInfo getStream() {
        return this.stream;
    }

    @Override
    public void setStream(YYVideoStreamInfo stream) {
        this.stream = stream;
    }

    @Override
    public void setVideoScaleMode(ConstantsWrapper.ScaleMode scaleMode) {
        this.scaleMode = scaleMode;
    }

    @Override
    public ConstantsWrapper.ScaleMode getVideoScaleMode() {
        return this.scaleMode;
    }

    public void removeAllViews() {
        super.removeAllViews();
    }

    public boolean containView(SurfaceView ySpVideoView) {
        for (int i = 0; i < super.getChildCount(); ++i) {
            View view = super.getChildAt(i);
            if (!view.equals(ySpVideoView)) continue;
            return true;
        }
        return false;
    }

    public int getIdx() {
        return this.idx;
    }

    public void setIdx(int idx) {
        this.idx = idx;
    }

    public int getMaxPreviewStreamSize() {
        return this.maxPreviewStreamSize;
    }

    public void setMaxPreviewStreamSize(int maxPreviewStreamSize) {
        this.maxPreviewStreamSize = maxPreviewStreamSize;
    }

    public void linkToStreamEtx(YYVideoStreamInfo stream, int videoIndex) {
        if (stream != null && videoIndex >= 0) {
            this.linkToStreamExt(stream.getUserGroupId(), stream.getStreamId(), videoIndex);
            if (!this.streamAndIndexs.containsKey(stream)) {
                this.streamAndIndexs.put(stream, videoIndex);
            }
            this.isMultipleVideoView = true;
        }
    }

    @Override
    public void enterMultiVideoViewMode(YMultiVideoViewParamsWrapper multiVideoViewParams) {
        super.enterMultiVideoViewMode(multiVideoViewParams);
        if (multiVideoViewParams != null) {
            this.videoPositions = multiVideoViewParams.mDrawPosition;
        }
        this.isMultipleVideoView = true;
    }

    @Override
    public void leaveMultiVideoViewMode() {
        super.leaveMultiVideoViewMode();
        this.isMultipleVideoView = false;
    }

    public void unLinkFromStreamExt(YYVideoStreamInfo stream, int videoIndex) {
        if (stream != null && videoIndex >= 0) {
            this.unLinkFromStreamExt(stream.getUserGroupId(), stream.getStreamId(), videoIndex);
            if (this.streamAndIndexs.containsKey(stream)) {
                this.streamAndIndexs.remove(stream);
            }
        }
    }

    public boolean canLinkedStream() {
        return this.maxPreviewStreamSize > 0 && (FP.empty(this.streamAndIndexs) || this.streamAndIndexs.size() <= this.maxPreviewStreamSize);
    }

    public boolean isMultipleVideoView() {
        return this.isMultipleVideoView;
    }

    public Map<YYVideoStreamInfo, Integer> getStreamAndIndexs() {
        return this.streamAndIndexs;
    }
}

