/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.sdkwrapper.yylive.media;

import com.medialib.video.MediaVideoMsg;
import java.util.HashMap;
import java.util.Map;

public class YYVideoStreamInfo {
    public int appId;
    public long channelId;
    public int streamFlag = 0;
    public int micPos = -1;
    public int publisherClientType = 5;
    public int width = 0;
    public int height = 0;
    public int bitRate = 0;
    public int frameRate = 0;
    public int encodeType = 0;
    public int autoSubscribe = 0;
    public int isConneectorLive = 0;
    public int isTransChannelLianMai = 0;
    public int isVrStream = 0;
    public int isDualCamera = 0;
    public int multipleStreamFlag = 0;
    public Integer liveLevel;
    public Integer originalScreen;
    public Integer verticalStyle;
    public Integer horizontalStyle;
    public long streamToUid;
    public long userGroupId = 0L;
    public long streamId = 0L;
    public int publishId = 0;
    public int state = 0;
    public Map<Byte, Integer> metaDatas = new HashMap<Byte, Integer>();
    public static final int ARRIVE = 1;
    public static final int START = 2;
    public static final int STOP = 3;

    public YYVideoStreamInfo(MediaVideoMsg.VideoStreamInfo info) {
        if (info != null) {
            this.userGroupId = info.userGroupId;
            this.appId = (int)info.userGroupId;
            this.channelId = info.userGroupId >>> 32;
            this.streamId = info.streamId;
            this.streamToUid = this.streamId >>> 32;
            this.publishId = info.publishId;
            this.state = info.state;
            this.metaDatas = info.metaDatas;
            this.parseMetaData(this.metaDatas);
        }
    }

    private void parseMetaData(Map<Byte, Integer> metaDatas) {
        if (metaDatas != null && metaDatas.size() > 0) {
            if (metaDatas.containsKey((short)MediaVideoMsg.VideoMetaDataKey.MST_PUBLISHER_MC_POS)) {
                this.micPos = metaDatas.get((short)MediaVideoMsg.VideoMetaDataKey.MST_PUBLISHER_MC_POS);
            }
            if (metaDatas.containsKey((short)MediaVideoMsg.VideoMetaDataKey.MST_VIDEO_STREAM_FLAG)) {
                this.streamFlag = metaDatas.get((short)MediaVideoMsg.VideoMetaDataKey.MST_VIDEO_STREAM_FLAG);
            }
            if (metaDatas.containsKey((short)MediaVideoMsg.VideoMetaDataKey.MST_VIDEO_CLIENNT_TYPE)) {
                this.publisherClientType = metaDatas.get((short)MediaVideoMsg.VideoMetaDataKey.MST_VIDEO_CLIENNT_TYPE);
            }
            if (metaDatas.containsKey((short)MediaVideoMsg.VideoMetaDataKey.MST_VIDEO_RESOLUTION)) {
                int resolution = metaDatas.get((short)MediaVideoMsg.VideoMetaDataKey.MST_VIDEO_RESOLUTION);
                this.width = resolution >>> 16;
                this.height = resolution & 0xFFFF;
            }
            this.bitRate = metaDatas.get((short)MediaVideoMsg.VideoMetaDataKey.MST_VIDEO_BIT_RATE);
            this.frameRate = metaDatas.get((short)MediaVideoMsg.VideoMetaDataKey.MST_VIDEO_FRAME_RATE);
            this.encodeType = metaDatas.get((short)MediaVideoMsg.VideoMetaDataKey.MST_VIDEO_ENCODE_TYPE);
            this.autoSubscribe = metaDatas.get((short)MediaVideoMsg.VideoMetaDataKey.MST_VIDEO_AUTO_SUBSCRIBE);
            this.liveLevel = metaDatas.get((short)80);
            this.originalScreen = metaDatas.get((short)102);
            this.verticalStyle = metaDatas.get((short)103);
            this.horizontalStyle = metaDatas.get((short)104);
            if (metaDatas.containsKey((short)82)) {
                this.isConneectorLive = metaDatas.get((short)82);
            }
            this.isTransChannelLianMai = metaDatas.containsKey((short)83) ? metaDatas.get((short)83) : 0;
            if (metaDatas.containsKey((short)MediaVideoMsg.VideoMetaDataKey.MST_PUBLISHER_RESERVE_META6)) {
                this.isVrStream = metaDatas.get((short)MediaVideoMsg.VideoMetaDataKey.MST_PUBLISHER_RESERVE_META6);
            }
            this.isDualCamera = metaDatas.containsKey((short)92) ? metaDatas.get((short)92) : 0;
            this.multipleStreamFlag = metaDatas.containsKey((short)89) ? metaDatas.get((short)89) : 0;
            if (this.multipleStreamFlag == 0 && metaDatas.containsKey((short)91)) {
                this.multipleStreamFlag = metaDatas.get((short)91);
            }
        }
    }

    public void updateMetaData(Map<Byte, Integer> updateMetaDatas) {
        this.metaDatas.putAll(updateMetaDatas);
        this.parseMetaData(this.metaDatas);
    }

    public void updateStreamInfo(YYVideoStreamInfo info) {
        this.state = info.getState();
    }

    public String toString() {
        return "YYVideoStreamInfo{state=" + this.state + ", appId=" + this.appId + ", channelId=" + this.channelId + ", userGroupId=" + this.userGroupId + ", micPos=" + this.micPos + ", streamId=" + this.streamId + ", streamToUid=" + this.streamToUid + ", publishId=" + this.publishId + ", streamFlag=" + this.streamFlag + ", publisherClientType=" + this.publisherClientType + ", width=" + this.width + ", height=" + this.height + ", bitRate=" + this.bitRate + ", frameRate=" + this.frameRate + ", encodeType=" + this.encodeType + ", autoSubscribe=" + this.autoSubscribe + ", liveLevel=" + this.liveLevel + ", originalScreen=" + this.originalScreen + ", verticalStyle=" + this.verticalStyle + ", horizontalStyle=" + this.horizontalStyle + ", isConneectorLive=" + this.isConneectorLive + ", isTransChannelLianMai=" + this.isTransChannelLianMai + ", isDualCamera=" + this.isDualCamera + ", isVrStream=" + this.isVrStream + ", multipleStreamFlag=" + this.multipleStreamFlag + ", metaDatas=" + this.metaDatas + '}';
    }

    public int getBitRate() {
        return this.bitRate;
    }

    public long getStreamId() {
        return this.streamId;
    }

    public long getStreamToUid() {
        return this.streamToUid;
    }

    public long getUserGroupId() {
        return this.userGroupId;
    }

    public int getVideoWidth() {
        return this.width;
    }

    public int getVideoHeight() {
        return this.height;
    }

    public int getState() {
        return this.state;
    }

    public Integer getOriginalScreen() {
        return this.originalScreen;
    }

    public Integer getVerticalStyle() {
        return this.verticalStyle;
    }

    public Integer getHorizontalStyle() {
        return this.horizontalStyle;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getFrameRate() {
        return this.frameRate;
    }

    public int getEncodeType() {
        return this.encodeType;
    }

    public int getAutoSubscribe() {
        return this.autoSubscribe;
    }

    public Integer getLiveLevel() {
        return this.liveLevel;
    }

    public int getPublisherClientType() {
        return this.publisherClientType;
    }

    public int getStreamFlag() {
        return this.streamFlag;
    }

    public int getIsConneectorLive() {
        return this.isConneectorLive;
    }

    public int getIsTranChannelLianMai() {
        return this.isTransChannelLianMai;
    }

    public int getVrStream() {
        return this.isVrStream;
    }

    public int getMultipleStreamFlag() {
        return this.multipleStreamFlag;
    }

    public int getMicPos() {
        return this.micPos;
    }

    public long getChannelId() {
        return this.channelId;
    }

    public int getAppId() {
        return this.appId;
    }
}

