/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.sdkwrapper.yylive.media;

import android.os.Handler;
import android.text.TextUtils;
import com.duowan.mobile.media.SpeechMsgPlayer;
import com.duowan.mobile.media.SpeechMsgRecorder;
import com.google.gson.Gson;
import com.medialib.video.IChannelSessionCallback;
import com.medialib.video.IVideoLiveCallback;
import com.yy.IMediaVideo;
import com.yy.IMediaVideoSDK;
import com.yy.mobile.sdkwrapper.flowmanagement.api.audio.AudioManager;
import com.yy.mobile.sdkwrapper.yylive.media.IRecordLocalFileListenerWrapper;
import com.yy.mobile.sdkwrapper.yylive.media.MediaInvokeWrapper;
import com.yy.mobile.sdkwrapper.yylive.media.MediaVideoHandler;
import com.yy.mobile.sdkwrapper.yylive.media.MediaVideoProtocol;
import com.yy.mobile.sdkwrapper.yylive.media.SoundEffectModel;
import com.yy.mobile.sdkwrapper.yylive.media.ui.IVideoLivecallbackWrapper;
import com.yy.mobile.sdkwrapper.yylive.media.ui.VideoLiveCallbackImpl;
import com.yy.mobile.util.log.MLog;
import com.yy.videoplayer.render.VideoRenderNotify;
import com.yy.videoplayer.render.YYRenderFrameBuffer;
import com.yy.videoplayer.render.YYSoftDecRender;
import com.yymobile.core.media.yyproto.FileRecorder;
import java.util.ArrayList;
import java.util.Map;

enum MediaVideoProcessor implements MediaVideoProtocol
{
    INSTANCE;

    private static final String TAG = "MediaVideoProcessor";
    private Gson mGson = new Gson();
    private int[] mEqGains = new int[11];
    private int[] mReverbExGains = new int[9];
    private int[] mCompressorGains = new int[6];
    private IRecordLocalFileListenerWrapper mListenerWrapper;
    private IVideoLiveCallback mVideoLiveCallback;

    private IMediaVideo getMedia() {
        return IMediaVideoSDK.instance().getMedia();
    }

    @Override
    public void setServiceType(int serviceType) {
        this.getMedia().setServiceType(serviceType);
    }

    @Override
    public int getTickCount() {
        return this.getMedia().getTickCount();
    }

    @Override
    public int getActuallyBitrate() {
        return this.getMedia().getActuallyBitrate();
    }

    @Override
    public int getActuallyFps() {
        return this.getMedia().getActuallyFps();
    }

    @Override
    public int setBitRate(int bitRateInKbps) {
        return this.getMedia().setBitRate(bitRateInKbps);
    }

    @Override
    public boolean setVirtualSpeakerVolume(int volume) {
        return this.getMedia().SetVirtualSpeakerVolume(volume);
    }

    @Override
    public boolean setVirtualMicVolume(int volume) {
        return this.getMedia().SetVirtualMicVolume(volume);
    }

    @Override
    public boolean setLoudspeakerStatus(boolean enable) {
        return this.getMedia().setLoudspeakerStatus(enable);
    }

    @Override
    public boolean getLoudspeakerStatus() {
        return this.getMedia().getLoudspeakerStatus();
    }

    @Override
    public void setFlvParam(int appId2, long uid, int publishId, int flvId, String url, int codeRate, int proxyType) {
        this.getMedia().setFlvParam(appId2, uid, publishId, flvId, url, codeRate, proxyType);
    }

    @Override
    public void join(long sid, long subSid) {
        this.getMedia().join(sid, subSid);
    }

    @Override
    public void joinMedia() {
        this.getMedia().joinMedia();
    }

    @Override
    public void leave() {
        this.getMedia().leave();
    }

    @Override
    public void switchVoice(boolean enable) {
        MLog.info((Object)TAG, (String)("switchVoice:" + enable), (Object[])new Object[0]);
        if (enable) {
            AudioManager.getInstance().openAudio();
        } else {
            AudioManager.getInstance().closeAudio();
        }
    }

    @Override
    public void diagnoseAudio(int nDiagnose) {
        this.getMedia().diagnoseAudio(nDiagnose);
    }

    @Override
    public void onAppBackground(boolean toBackground) {
        this.getMedia().onAppBackground(toBackground);
    }

    @Override
    public void notifyRtmpStream(int appId2, boolean bStart, Map<String, String> cdn) {
        this.getMedia().notifyRtmpStream(appId2, bStart, cdn);
    }

    @Override
    public void setAudioMode(boolean isModeNormal) {
        this.getMedia().setAudioMode(isModeNormal);
    }

    @Override
    public void startAudioPreview() {
        this.getMedia().StartAudioPreview();
    }

    @Override
    public void stopAudioPreview() {
        this.getMedia().StopAudioPreview();
    }

    @Override
    public void startRecordSpeechMsg(String fileName, final FileRecorder.SpeechMsgRecorderNotify cb) {
        this.getMedia().startRecordSpeechMsg(fileName, new SpeechMsgRecorder.SpeechMsgRecorderNotify(){

            public void OnAudioVolumeVisual(int recordTime, int volume) {
                if (cb != null) {
                    cb.onAudioVolumeVisual(recordTime, volume);
                }
            }

            public void OnAudioRecordError() {
                if (cb != null) {
                    cb.onAudioRecordError();
                }
            }

            public void OnStopRecordData(int recordTime, int maxDuration) {
                if (cb != null) {
                    cb.onStopRecordData(recordTime, maxDuration);
                }
            }

            public void OnReachMaxDuration(int recordTime, int maxDuration) {
                if (cb != null) {
                    cb.onReachMaxDuration(recordTime, maxDuration);
                }
            }
        });
    }

    @Override
    public void stopRecordSpeechMsg() {
        this.getMedia().stopRecordSpeechMsg();
    }

    @Override
    public void setRecordSpeechMsgParameter(int maxTime, int codecType) {
        this.getMedia().setRecordSpeechMsgParameter(maxTime, codecType);
    }

    @Override
    public long getRecordedFileTime(String fileName) {
        return this.getMedia().getRecordedFileTime(fileName);
    }

    @Override
    public void startPlaySpeechMsg(String fileName, final FileRecorder.SpeechMsgPlayerNotify cb) {
        this.getMedia().startPlaySpeechMsg(fileName, new SpeechMsgPlayer.SpeechMsgPlayerNotify(){

            public void OnAudioPlayStatus(int nowPlayTime, int filePlayTime, int volume) {
                if (cb != null) {
                    cb.onAudioPlayStatus(nowPlayTime, filePlayTime, volume);
                }
            }

            public void OnAudioPlayError() {
                if (cb != null) {
                    cb.onAudioPlayError();
                }
            }

            public void OnStopPlayData(int nowPlayTime, int filePlayTime) {
                if (cb != null) {
                    cb.onStopPlayData(nowPlayTime, filePlayTime);
                }
            }

            public void OnReachMaxPlayTime(int nowPlayTime, int filePlayTime) {
                if (cb != null) {
                    cb.onReachMaxPlayTime(nowPlayTime, filePlayTime);
                }
            }
        });
    }

    @Override
    public void stopPlaySpeechMsg() {
        this.getMedia().stopPlaySpeechMsg();
    }

    @Override
    public void pushEncodedAudioData(byte[] data, int iDataLen, int iRawCodecId, int timeStamp) {
        this.getMedia().pushEncodedAudioData(data, iDataLen, iRawCodecId, timeStamp);
    }

    @Override
    public void pushPcmAudioData(byte[] data, int pathNum, int timeStamp, int denoiseEnable) {
        this.getMedia().pushPcmAudioData(data, pathNum, timeStamp, denoiseEnable);
    }

    @Override
    public void pushOuterAudioData(byte[] data, int mixType, int sampleRate, int channel) {
        this.getMedia().PushOuterAudioData(data, mixType, sampleRate, channel);
    }

    @Override
    public void setReverbExParameter(float roomSize, float preDelay, float reverberance, float hfDamping, float toneLow, float toneHigh, float wetGain, float dryGain, float stereoWidth) {
        this.getMedia().setReverbExParameter(roomSize, preDelay, reverberance, hfDamping, toneLow, toneHigh, wetGain, dryGain, stereoWidth);
    }

    @Override
    public void setReverbParameter(float roomsize, float revtime, float damping, float inputbandwidth, float drylevel, float earlylevel, float taillevel) {
        this.getMedia().setReverbParameter(roomsize, revtime, damping, inputbandwidth, drylevel, earlylevel, taillevel);
    }

    @Override
    public void enableReverb(boolean enable) {
        this.getMedia().EnableReverbEx(enable);
    }

    @Override
    public void enableVoiceChanger(boolean enable) {
        this.getMedia().EnableVoiceChanger(enable);
    }

    @Override
    public void setVoiceChangeSemitone(int val) {
        this.getMedia().SetVoiceChangeSemitone(val);
    }

    @Override
    public void setReverbMode(int mode) {
        this.getMedia().SetReverbMode(mode);
    }

    @Override
    public void setVeoMode(int mode) {
        this.getMedia().SetVeoMode(mode);
    }

    @Override
    public void setBeatTrackDelay(int val) {
        this.getMedia().SetBeatTrackDelay(val);
    }

    @Override
    public void enableBeatTrackCallBack(boolean enable) {
        this.getMedia().EnableBeatTrackCallBack(enable);
    }

    @Override
    public void enableReverbEx(boolean enable) {
        this.getMedia().EnableReverbEx(enable);
    }

    @Override
    public void enableVoiceChangerEx(boolean enable) {
        this.getMedia().EnableVoiceChangerEx(enable);
    }

    @Override
    public void setVoiceChangeSemitoneEx(int val) {
        this.getMedia().SetVoiceChangeSemitoneEx(val);
    }

    @Override
    public void setReverbExMode(int mode) {
        this.getMedia().SetReverbExMode(mode);
    }

    @Override
    public void enableRenderVolumeDisplay(boolean enable) {
        AudioManager.getInstance().enableRenderVolumeDisplay(enable);
    }

    @Override
    public void setConfigs(int appId2, Map<Integer, Integer> configs) {
        this.getMedia().setConfigs(appId2, configs);
    }

    @Override
    public int getConfig(int configKey) {
        return this.getMedia().getConfig(configKey);
    }

    @Override
    public int getRunningData(int configKey) {
        return this.getMedia().getRunningData(configKey);
    }

    @Override
    public void updateEncoderInfo(int appId2, int bitRate, int frameRate, int width, int height) {
        this.getMedia().updateEncoderInfo(appId2, bitRate, frameRate, width, height);
    }

    @Override
    public void setPublishRtmpParam(Boolean openRtmp, String destUrl, String playPath) {
        this.getMedia().setPublishRtmpParam(openRtmp, destUrl, playPath);
    }

    @Override
    public void joinLocalMedia(int appId2) {
        this.getMedia().joinLocalMedia(appId2);
    }

    @Override
    public void leaveLocalMedia(int appId2) {
        this.getMedia().leaveLocalMedia(appId2);
    }

    @Override
    public void setRtmpPublishExtraParam(int appId2, Map<String, String> param) {
        this.getMedia().setRtmpPublishExtraParam(appId2, param);
    }

    @Override
    public int getPublishInitialBitRate(int definitionLevel, int maxBitRate) {
        return this.getMedia().getPublishInitialBitRate(definitionLevel, maxBitRate);
    }

    @Override
    public void sidForward(int appId2, long sid, long subSid, int lineid, boolean start, long modelType) {
        this.getMedia().sidForward(appId2, sid, subSid, lineid, start, modelType);
    }

    @Override
    public void sidForward(int appId2, long sid, long subSid, int lineid, boolean start) {
        this.getMedia().sidForward(appId2, sid, subSid, lineid, start);
    }

    @Override
    public void invokeRtmpServer(boolean bStart, boolean bMultiClient, Map<String, String> extraParam) {
        this.getMedia().invokeRtmpServer(bStart, bMultiClient, extraParam);
    }

    @Override
    public void operateRtmpClient(long streamId, int operation, Map<String, String> extraParam) {
        this.getMedia().operateRtmpClient(streamId, operation, extraParam);
    }

    @Override
    public void setMixStreamConfig(int width, int height, int bitrate, int fps, Map<Long, MediaInvokeWrapper.VideoLayoutWrapper> streamLayout) {
        this.getMedia().setMixStreamConfig(width, height, bitrate, fps, MediaInvokeWrapper.convertVideoLayout(streamLayout));
    }

    @Override
    public void addMsgHandler(MediaVideoHandler msgHandler) {
        this.getMedia().addMsgHandler((Handler)msgHandler.getHandler());
    }

    @Override
    public void removeMsgHandler(MediaVideoHandler msgHandler) {
        this.getMedia().removeMsgHandler((Handler)msgHandler.getHandler());
    }

    @Override
    public void onNetworkStateChange(int netState) {
        this.getMedia().onNetworkStateChange(netState);
    }

    @Override
    public void addRenderFrameBuffer(YYRenderFrameBuffer buf) {
        this.getMedia().addRenderFrameBuffer((YYSoftDecRender)buf);
    }

    @Override
    public void removeRenderFrameBuffer(YYRenderFrameBuffer buf) {
        this.getMedia().removeRenderFrameBuffer((YYSoftDecRender)buf);
    }

    @Override
    public void notifyPlayStatus(long groupId, long streamId, int status) {
        this.getMedia().notifyPlayStatus(groupId, streamId, status);
    }

    @Override
    public void notifyEncodeSlow(float realFps) {
        this.getMedia().notifyEncodeSlow(realFps);
    }

    @Override
    public void notifyHardwareCodecConfigured(boolean h264DecodeOn, boolean h264EncodeOn, boolean h265DecodeOn, boolean h265EncodeOn) {
        this.getMedia().notifyHardwareCodecConfigured(h264DecodeOn, h264EncodeOn, h265DecodeOn, h265EncodeOn);
    }

    @Override
    public void onViewPlayEventNotify(long userGroupId, long streamId, int eventType, long happenTime) {
        this.getMedia().onViewPlayEventNotify(userGroupId, streamId, eventType, happenTime);
    }

    @Override
    public void onVideoRenderNotify(ArrayList<VideoRenderNotify> notifys) {
        this.getMedia().onVideoRenderNotify(notifys);
    }

    @Override
    public void onFirstFrameRenderNotify(long userGroupId, long streamId, long currentSystemMilliSecond, long firstFrameToRenderInMilliSec, int eatenFrames) {
        this.getMedia().onFirstFrameRenderNotify(userGroupId, streamId, currentSystemMilliSecond, firstFrameToRenderInMilliSec, eatenFrames);
    }

    @Override
    public void onCoefficientOfVariationOfRenderInterval(long userGroupId, long streamId, long intervalMilliTs, double coef) {
        this.getMedia().onCoefficientOfVariationOfRenderInterval(userGroupId, streamId, intervalMilliTs, coef);
    }

    @Override
    public void setChannelSessionCallback(IChannelSessionCallback channelSessionCallback) {
        this.getMedia().setChannelSessionCallback(channelSessionCallback);
    }

    @Override
    public void setVideoLiveCallback(IVideoLivecallbackWrapper videoLiveCallback) {
        if (videoLiveCallback != null) {
            if (this.mVideoLiveCallback == null) {
                this.mVideoLiveCallback = new VideoLiveCallbackImpl(videoLiveCallback);
            }
        } else {
            this.mVideoLiveCallback = null;
        }
        this.getMedia().setVideoLiveCallback(this.mVideoLiveCallback);
    }

    @Override
    public void updateByAppGround(boolean isBackground) {
        this.getMedia().updateByAppGround(isBackground);
    }

    @Override
    public void joinMedia(long sid, long subSid) {
        MLog.info((Object)TAG, (String)"join media only", (Object[])new Object[0]);
        this.getMedia().join(sid, subSid);
    }

    @Override
    public void releaseTransMedia(MediaVideoHandler handler) {
        if (handler != null) {
            this.getMedia().removeMsgHandler((Handler)handler.getHandler());
        }
        this.getMedia().leave();
        this.getMedia().deInit();
    }

    @Override
    public void enableDenoise(boolean enable) {
        this.getMedia().EnableDenoise(enable);
    }

    @Override
    public boolean isDenoiseEnabled() {
        return this.getMedia().IsDenoiseEnabled();
    }

    @Override
    public void enableEqualizer(boolean isEnable) {
        this.getMedia().EnableEqualizer(isEnable);
    }

    @Override
    public void enableCompressor(boolean isEnable) {
        this.getMedia().EnableCompressor(isEnable);
    }

    @Override
    public void setEqGains(int[] gains) {
        MLog.info((Object)TAG, (String)"#setEqGains params.length = %d", (Object[])new Object[]{gains.length});
        this.getMedia().SetEqGains(gains);
    }

    @Override
    public void setCompressorParam(int[] params) {
        MLog.info((Object)TAG, (String)"#setCompressorParam params.length = %d", (Object[])new Object[]{params.length});
        if (params.length >= 6) {
            int threshold = params[0];
            int makeupGain = params[1];
            int ratio = params[2];
            int knee = params[3];
            int releaseTime = params[4];
            int attackTime = params[5];
            this.getMedia().SetCompressorParam(threshold, makeupGain, ratio, knee, releaseTime, attackTime);
        }
    }

    @Override
    public void setReverbExParameter(int[] params) {
        MLog.info((Object)TAG, (String)"#setReverbExParameter params.length = %d", (Object[])new Object[]{params.length});
        if (params.length >= 9) {
            float roomSize = params[0];
            float preDelay = params[1];
            float reverberance = params[2];
            float hfDamping = params[3];
            float toneLow = params[4];
            float toneHigh = params[5];
            float wetGain = params[6];
            float dryGain = params[7];
            float stereoWidth = params[8];
            this.getMedia().setReverbExParameter(roomSize, preDelay, reverberance, hfDamping, toneLow, toneHigh, wetGain, dryGain, stereoWidth);
        }
    }

    @Override
    public void setSoundEffectParam(String param) {
        MLog.info((Object)TAG, (String)"#setSoundEffectParam param = %s", (Object[])new Object[]{param});
        if (this.mGson == null || TextUtils.isEmpty((CharSequence)param)) {
            return;
        }
        SoundEffectModel model = (SoundEffectModel)this.mGson.fromJson(param, SoundEffectModel.class);
        if (model != null) {
            int mEqGainsSize = model.mEqGains.size();
            if (mEqGainsSize > 11) {
                mEqGainsSize = 11;
            }
            for (int i = 0; i < mEqGainsSize; ++i) {
                this.mEqGains[i] = model.mEqGains.get(i);
            }
            int mReverbExGainsSize = model.mReverbExGains.size();
            if (mReverbExGainsSize > 9) {
                mReverbExGainsSize = 9;
            }
            for (int i = 0; i < mReverbExGainsSize; ++i) {
                this.mReverbExGains[i] = model.mReverbExGains.get(i);
            }
            int mmCompressorGainsSize = model.mCompressorGains.size();
            if (mmCompressorGainsSize > 6) {
                mmCompressorGainsSize = 6;
            }
            for (int i = 0; i < mmCompressorGainsSize; ++i) {
                this.mCompressorGains[i] = model.mCompressorGains.get(i);
            }
            this.enableEqualizer(model.mEnableEqualizer);
            this.enableReverb(model.mEnableReverbEx);
            this.enableCompressor(model.mEnableCompressor);
            if (model.mEnableEqualizer) {
                this.setEqGains(this.mEqGains);
            }
            if (model.mEnableReverbEx) {
                this.setReverbExParameter(this.mReverbExGains);
            }
            if (model.mEnableCompressor) {
                this.setCompressorParam(this.mCompressorGains);
            }
        }
    }

    @Override
    public void vodMuteLiveAudio(boolean mute) {
        this.getMedia().vodMuteLiveAudio(mute);
    }
}

