/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.sdkwrapper.yylive.media;

import android.os.Looper;
import android.os.Message;
import android.support.annotation.NonNull;
import com.medialib.video.MediaEvent;
import com.medialib.video.MediaVideoMsg;
import com.yy.mobile.RxBus;
import com.yy.mobile.YYHandler;
import com.yy.mobile.sdkwrapper.yylive.media.YYVideoStreamInfo;
import com.yy.mobile.sdkwrapper.yylive.media.event.AnchorBroadcastDataEventArgs;
import com.yy.mobile.sdkwrapper.yylive.media.event.AudienceStreamConfigInfoEventArgs;
import com.yy.mobile.sdkwrapper.yylive.media.event.AudioCaptureErrorEventArgs;
import com.yy.mobile.sdkwrapper.yylive.media.event.AudioCaptureVolumeEventArgs;
import com.yy.mobile.sdkwrapper.yylive.media.event.AudioRenderVolumeInfoEventArgs;
import com.yy.mobile.sdkwrapper.yylive.media.event.AudioSpeakerInfoEventArgs;
import com.yy.mobile.sdkwrapper.yylive.media.event.AudioVolumeInfoEventArgs;
import com.yy.mobile.sdkwrapper.yylive.media.event.ChannelAudioStateInfoEventArgs;
import com.yy.mobile.sdkwrapper.yylive.media.event.DynamicBitRateInfoEventArgs;
import com.yy.mobile.sdkwrapper.yylive.media.event.FpsInfoEventArgs;
import com.yy.mobile.sdkwrapper.yylive.media.event.LowDelayEncodeModeInfoEventArgs;
import com.yy.mobile.sdkwrapper.yylive.media.event.MediaLinkInfoEventArgs;
import com.yy.mobile.sdkwrapper.yylive.media.event.MediaSdkReadyInfoEventArgs;
import com.yy.mobile.sdkwrapper.yylive.media.event.MicStateInfoEventArgs;
import com.yy.mobile.sdkwrapper.yylive.media.event.NoVideoInfoEventArgs;
import com.yy.mobile.sdkwrapper.yylive.media.event.NotifyForwardStatusInfoEventArgs;
import com.yy.mobile.sdkwrapper.yylive.media.event.OnHardwareDecodeErrorInfoArgs;
import com.yy.mobile.sdkwrapper.yylive.media.event.PlayAudioStateInfoEventArgs;
import com.yy.mobile.sdkwrapper.yylive.media.event.PublisherPtsAdjustValEventArgs;
import com.yy.mobile.sdkwrapper.yylive.media.event.RequestIFrameInfoEventArgs;
import com.yy.mobile.sdkwrapper.yylive.media.event.RtmpClientStatusInfoEventArgs;
import com.yy.mobile.sdkwrapper.yylive.media.event.RtmpMetaDataInfoEventArgs;
import com.yy.mobile.sdkwrapper.yylive.media.event.RtmpPublishStatusInfoEventArgs;
import com.yy.mobile.sdkwrapper.yylive.media.event.RtmpServerStatusInfoEventArgs;
import com.yy.mobile.sdkwrapper.yylive.media.event.VideoBroadcastGroupInfoEventArgs;
import com.yy.mobile.sdkwrapper.yylive.media.event.VideoCodeRateChangeEventArgs;
import com.yy.mobile.sdkwrapper.yylive.media.event.VideoCodeRateInfoEventArgs;
import com.yy.mobile.sdkwrapper.yylive.media.event.VideoEncodedFrameInfoEventArgs;
import com.yy.mobile.sdkwrapper.yylive.media.event.VideoLinkInfoEventArgs;
import com.yy.mobile.sdkwrapper.yylive.media.event.VideoMetaDataInfoEventArgs;
import com.yy.mobile.sdkwrapper.yylive.media.event.VideoPlayDelayInfoEventArgs;
import com.yy.mobile.sdkwrapper.yylive.media.event.VideoPublishStatusEventArgs;
import com.yy.mobile.sdkwrapper.yylive.media.event.VideoPublisherStatInfoEventArgs;
import com.yy.mobile.sdkwrapper.yylive.media.event.VideoPulisherLossNotifyInfoEventArgs;
import com.yy.mobile.sdkwrapper.yylive.media.event.VideoUplinkLossRateInfoEventArgs;
import com.yy.mobile.sdkwrapper.yylive.media.event.VideoliveBroadcastInfoEventArgs;
import com.yy.mobile.util.log.MLog;
import java.util.HashMap;
import java.util.Map;

@Deprecated
public class MediaVideoHandlerImpl
extends YYHandler {
    private static final String TAG = "ImHandler";
    private final RxBus mBus;
    private long mLastUid = 0L;
    private long mLastTime = 0L;
    private static final long TIME_INTERVAL = 500L;

    public MediaVideoHandlerImpl(@NonNull Looper looper, @NonNull RxBus rxBus) {
        super(looper);
        this.mBus = rxBus;
    }

    public void handleMessage(Message msg) {
        switch (msg.what) {
            case 108: {
                MediaVideoMsg.FpsInfo fpsInfo = (MediaVideoMsg.FpsInfo)msg.obj;
                if (fpsInfo == null) break;
                this.mBus.post((Object)new FpsInfoEventArgs(fpsInfo.streamId, fpsInfo.bitRate, fpsInfo.frameRate));
                break;
            }
            case 102: {
                MediaVideoMsg.VideoStreamInfo streamInfo = (MediaVideoMsg.VideoStreamInfo)msg.obj;
                if (streamInfo == null) break;
                MLog.info((Object)TAG, (String)("onVideoStreamInfoNotify: state" + streamInfo.state), (Object[])new Object[0]);
                this.mBus.post((Object)new YYVideoStreamInfo(streamInfo));
                break;
            }
            case 105: {
                MediaVideoMsg.VideoliveBroadcastInfo broadcastInfo = (MediaVideoMsg.VideoliveBroadcastInfo)msg.obj;
                if (broadcastInfo == null) break;
                this.mBus.post((Object)new VideoliveBroadcastInfoEventArgs(broadcastInfo.appid, broadcastInfo.subsid, broadcastInfo.hasVideo));
                break;
            }
            case 204: {
                MediaVideoMsg.AudioVolumeInfo audioVolumeInfo = (MediaVideoMsg.AudioVolumeInfo)msg.obj;
                if (audioVolumeInfo == null) break;
                this.mBus.post((Object)new AudioVolumeInfoEventArgs(audioVolumeInfo.uid, audioVolumeInfo.volume));
                break;
            }
            case 203: {
                MediaVideoMsg.MicStateInfo micStateInfo = (MediaVideoMsg.MicStateInfo)msg.obj;
                if (micStateInfo == null) break;
                this.mBus.post((Object)new MicStateInfoEventArgs(micStateInfo.state));
                break;
            }
            case 202: {
                MediaVideoMsg.AudioSpeakerInfo speakerInfo = (MediaVideoMsg.AudioSpeakerInfo)msg.obj;
                if (speakerInfo == null) break;
                this.mBus.post((Object)new AudioSpeakerInfoEventArgs(speakerInfo.uid, speakerInfo.state));
                break;
            }
            case 222: {
                MediaVideoMsg.AudioRenderVolumeInfo audioRenderVolumeInfo = (MediaVideoMsg.AudioRenderVolumeInfo)msg.obj;
                if (audioRenderVolumeInfo == null) break;
                long currentTime = System.currentTimeMillis();
                if (this.mLastUid == audioRenderVolumeInfo.uid && currentTime - this.mLastTime < 500L) {
                    MLog.debug((Object)TAG, (String)"callTime frequently, quit", (Object[])new Object[0]);
                    return;
                }
                MLog.debug((Object)TAG, (String)"onAudioRenderVolume uid = %d", (Object[])new Object[]{audioRenderVolumeInfo.uid});
                this.mLastUid = audioRenderVolumeInfo.uid;
                this.mLastTime = currentTime;
                this.mBus.post((Object)new AudioRenderVolumeInfoEventArgs(audioRenderVolumeInfo.uid, audioRenderVolumeInfo.volume));
                break;
            }
            case 101: {
                MediaVideoMsg.VideoLinkInfo videoLinkInfo = (MediaVideoMsg.VideoLinkInfo)msg.obj;
                if (videoLinkInfo == null) break;
                this.mBus.post((Object)new VideoLinkInfoEventArgs(videoLinkInfo.appId, videoLinkInfo.state, videoLinkInfo.ip, videoLinkInfo.port, videoLinkInfo.channelId));
                break;
            }
            case 201: {
                MediaVideoMsg.MediaLinkInfo mediaLinkInfo = (MediaVideoMsg.MediaLinkInfo)msg.obj;
                if (mediaLinkInfo == null) break;
                this.mBus.post((Object)new MediaLinkInfoEventArgs(mediaLinkInfo.state, mediaLinkInfo.ip, mediaLinkInfo.port));
                break;
            }
            case 205: {
                MediaVideoMsg.ChannelAudioStateInfo channelAudioStateInfo = (MediaVideoMsg.ChannelAudioStateInfo)msg.obj;
                if (channelAudioStateInfo == null) break;
                this.mBus.post((Object)new ChannelAudioStateInfoEventArgs(channelAudioStateInfo.sid, channelAudioStateInfo.subSid, channelAudioStateInfo.state));
                break;
            }
            case 206: {
                MediaVideoMsg.PlayAudioStateInfo playAudioStateInfo = (MediaVideoMsg.PlayAudioStateInfo)msg.obj;
                if (!MLog.isLogLevelAboveVerbose()) {
                    MLog.verbose((Object)TAG, (String)("onPlayAudioStateNotify playAudioStateInfo = " + playAudioStateInfo), (Object[])new Object[0]);
                }
                this.mBus.post((Object)new PlayAudioStateInfoEventArgs());
                break;
            }
            case 106: {
                MediaVideoMsg.VideoCodeRateInfo videoCodeRateInfo = (MediaVideoMsg.VideoCodeRateInfo)msg.obj;
                this.mBus.post((Object)new VideoCodeRateInfoEventArgs(videoCodeRateInfo.appid, videoCodeRateInfo.codeRateList));
                break;
            }
            case 107: {
                MediaVideoMsg.VideoCodeRateChange videoCodeRateChange = (MediaVideoMsg.VideoCodeRateChange)msg.obj;
                this.mBus.post((Object)new VideoCodeRateChangeEventArgs(videoCodeRateChange.appid, videoCodeRateChange.codeRate, videoCodeRateChange.result));
                break;
            }
            case 110: {
                MediaVideoMsg.DecodeSlowInfo decodeSlowInfo = (MediaVideoMsg.DecodeSlowInfo)msg.obj;
                if (decodeSlowInfo == null || decodeSlowInfo.frameRate <= decodeSlowInfo.decodeRate) break;
                MLog.info((Object)TAG, (String)("onDecodeSlowNotify streamId:" + decodeSlowInfo.streamId + ", bitRate:" + decodeSlowInfo.bitRate + ", frameRate:" + decodeSlowInfo.frameRate + ", decodeRate:" + decodeSlowInfo.decodeRate + ", width:" + decodeSlowInfo.width + ", height:" + decodeSlowInfo.height), (Object[])new Object[0]);
                break;
            }
            case 115: {
                MediaVideoMsg.AnchorBroadcastData anchorBroadcastData = (MediaVideoMsg.AnchorBroadcastData)msg.obj;
                if (anchorBroadcastData == null) break;
                this.mBus.post((Object)new AnchorBroadcastDataEventArgs(anchorBroadcastData.uid, anchorBroadcastData.userGroupId, anchorBroadcastData.streamId, anchorBroadcastData.intDatas, anchorBroadcastData.strDatas));
                break;
            }
            case 208: {
                MediaVideoMsg.AudioCaptureErrorInfo evt = (MediaVideoMsg.AudioCaptureErrorInfo)msg.obj;
                if (!MLog.isLogLevelAboveVerbose()) {
                    MLog.verbose((Object)TAG, (String)("onAudioCaptureErrorNotify AudioCaptureErrorInfo = " + evt), (Object[])new Object[0]);
                }
                this.mBus.post((Object)new AudioCaptureErrorEventArgs(evt.uid, evt.errorType));
                break;
            }
            case 212: {
                MediaVideoMsg.AudioCaptureVolumeInfo audioCaptureVolume = (MediaVideoMsg.AudioCaptureVolumeInfo)msg.obj;
                this.mBus.post((Object)new AudioCaptureVolumeEventArgs(audioCaptureVolume.volume));
                break;
            }
            case 114: {
                MediaVideoMsg.VideoUplinkLossRateInfo videoUplinkLossRateInfo = (MediaVideoMsg.VideoUplinkLossRateInfo)msg.obj;
                if (videoUplinkLossRateInfo == null) break;
                this.mBus.post((Object)new VideoUplinkLossRateInfoEventArgs(videoUplinkLossRateInfo.lossRate, videoUplinkLossRateInfo.rtt));
                break;
            }
            case 301: {
                MediaVideoMsg.MediaSdkReadyInfo mediaSdkReadyInfo = (MediaVideoMsg.MediaSdkReadyInfo)msg.obj;
                if (mediaSdkReadyInfo == null) break;
                this.mBus.post((Object)new MediaSdkReadyInfoEventArgs(mediaSdkReadyInfo.sid, mediaSdkReadyInfo.subSid, mediaSdkReadyInfo.state));
                break;
            }
            case 113: {
                MediaVideoMsg.VideoPublishStatus videoPublishStatus = (MediaVideoMsg.VideoPublishStatus)msg.obj;
                if (videoPublishStatus == null) break;
                this.mBus.post((Object)new VideoPublishStatusEventArgs(videoPublishStatus.status));
                break;
            }
            case 119: {
                MediaVideoMsg.EncodeSlowInfo encodeSlowInfo = (MediaVideoMsg.EncodeSlowInfo)msg.obj;
                if (encodeSlowInfo == null) break;
                MLog.info((Object)TAG, (String)("onEncodeSlowNotify encodeRate:" + encodeSlowInfo.encodeRate), (Object[])new Object[0]);
                break;
            }
            case 122: {
                MediaVideoMsg.DynamicBitRateInfo dynamicBitRateInfo = (MediaVideoMsg.DynamicBitRateInfo)msg.obj;
                this.mBus.post((Object)new DynamicBitRateInfoEventArgs(dynamicBitRateInfo.appid, dynamicBitRateInfo.uid, dynamicBitRateInfo.bitrate));
                break;
            }
            case 124: {
                MediaVideoMsg.VideoPublisherStatInfo videoPublisherStatInfo = (MediaVideoMsg.VideoPublisherStatInfo)msg.obj;
                if (videoPublisherStatInfo == null) break;
                HashMap<Long, Map<Integer, Integer>> streamMap = new HashMap<Long, Map<Integer, Integer>>();
                for (Map.Entry entry : videoPublisherStatInfo.streamMap.entrySet()) {
                    streamMap.put((Long)entry.getKey(), ((MediaVideoMsg.StreamStatInfo)entry.getValue()).dataMap);
                }
                this.mBus.post((Object)new VideoPublisherStatInfoEventArgs(videoPublisherStatInfo.uid, videoPublisherStatInfo.statMap, streamMap));
                break;
            }
            case 129: {
                MediaVideoMsg.VideoMetaDataInfo videoMetaDataInfo = (MediaVideoMsg.VideoMetaDataInfo)msg.obj;
                this.mBus.post((Object)new VideoMetaDataInfoEventArgs(videoMetaDataInfo.publishId, videoMetaDataInfo.streamId, videoMetaDataInfo.userGroupId, videoMetaDataInfo.metaDatas));
                break;
            }
            case 127: {
                MediaVideoMsg.VideoBroadcastGroupInfo groupInfo = (MediaVideoMsg.VideoBroadcastGroupInfo)msg.obj;
                this.mBus.post((Object)new VideoBroadcastGroupInfoEventArgs(groupInfo.appId, groupInfo.isNewBroadCastGroup));
                break;
            }
            case 128: {
                MediaVideoMsg.AudienceStreamConfigInfo audienceStreamConfigInfo = (MediaVideoMsg.AudienceStreamConfigInfo)msg.obj;
                this.mBus.post((Object)new AudienceStreamConfigInfoEventArgs(audienceStreamConfigInfo.streamKeyToConfig));
                break;
            }
            case 109: {
                MediaVideoMsg.NoVideoInfo noVideoInfo = (MediaVideoMsg.NoVideoInfo)msg.obj;
                if (noVideoInfo == null) break;
                this.mBus.post((Object)new NoVideoInfoEventArgs(noVideoInfo.streamId, noVideoInfo.reason));
                break;
            }
            case 131: {
                MediaVideoMsg.VideoPulisherLossNotifyInfo lossNotifyInfo = (MediaVideoMsg.VideoPulisherLossNotifyInfo)msg.obj;
                if (lossNotifyInfo == null || lossNotifyInfo.statMap == null) break;
                MLog.info((Object)TAG, (String)("onVideoPublisherLossNotifyInfo uid:" + lossNotifyInfo.uid + ", statMap:" + lossNotifyInfo.statMap), (Object[])new Object[0]);
                Integer isLoss = (Integer)lossNotifyInfo.statMap.get(MediaVideoMsg.PublisherLossNotifyKey.LNK_PUBLISHER_LOSS_NOTIFY);
                if (isLoss == null || isLoss != 1) break;
                this.mBus.post((Object)new VideoPulisherLossNotifyInfoEventArgs(lossNotifyInfo.uid, true));
                break;
            }
            case 132: {
                MLog.info((Object)TAG, (String)"onRequestIFrameInfo", (Object[])new Object[0]);
                this.mBus.post((Object)new RequestIFrameInfoEventArgs());
                break;
            }
            case 133: {
                MediaVideoMsg.LowDelayEncodeModeInfo lowDelayEncodeModeInfo = (MediaVideoMsg.LowDelayEncodeModeInfo)msg.obj;
                if (lowDelayEncodeModeInfo == null) break;
                this.mBus.post((Object)new LowDelayEncodeModeInfoEventArgs(lowDelayEncodeModeInfo.lowDelayMode != 0));
                break;
            }
            case 116: {
                MediaVideoMsg.FlvHttpStatusInfo flvHttpStatusInfo = (MediaVideoMsg.FlvHttpStatusInfo)msg.obj;
                if (flvHttpStatusInfo == null) break;
                MLog.info((Object)TAG, (String)("onFlvHttpStatusNotify uid:" + flvHttpStatusInfo.uid + ", flvId:" + flvHttpStatusInfo.flvId + ", publishId:" + flvHttpStatusInfo.publishId + ", status:" + flvHttpStatusInfo.status), (Object[])new Object[0]);
                break;
            }
            case 303: {
                MediaVideoMsg.RtmpPublishStatusInfo rtmpPublishStatusInfo = (MediaVideoMsg.RtmpPublishStatusInfo)msg.obj;
                if (rtmpPublishStatusInfo == null) break;
                MLog.info((Object)TAG, (String)("onRtmpPublishStatusInfo appId:" + rtmpPublishStatusInfo.appId + ", status:" + rtmpPublishStatusInfo.status), (Object[])new Object[0]);
                this.mBus.post((Object)new RtmpPublishStatusInfoEventArgs(rtmpPublishStatusInfo.appId, rtmpPublishStatusInfo.status));
                break;
            }
            case 304: {
                MediaVideoMsg.NotifyForwardStatusInfo notifyForwardStatusInfo = (MediaVideoMsg.NotifyForwardStatusInfo)msg.obj;
                MLog.info((Object)TAG, (String)("onNotifyForwardStatusInfo appId:" + notifyForwardStatusInfo.appId + ", status:" + notifyForwardStatusInfo.status), (Object[])new Object[0]);
                if (notifyForwardStatusInfo == null) break;
                this.mBus.post((Object)new NotifyForwardStatusInfoEventArgs(notifyForwardStatusInfo.appId, notifyForwardStatusInfo.status, notifyForwardStatusInfo.subSid, notifyForwardStatusInfo.publishId));
                break;
            }
            case 307: {
                MediaVideoMsg.RtmpClientStatusInfo rtmpClientStatusInfo = (MediaVideoMsg.RtmpClientStatusInfo)msg.obj;
                if (rtmpClientStatusInfo == null) break;
                this.mBus.post((Object)new RtmpClientStatusInfoEventArgs(rtmpClientStatusInfo.streamId, rtmpClientStatusInfo.status, rtmpClientStatusInfo.extraInfo));
                break;
            }
            case 308: {
                MediaVideoMsg.RtmpMetaDataInfo rtmpMetaDataInfo = (MediaVideoMsg.RtmpMetaDataInfo)msg.obj;
                if (rtmpMetaDataInfo == null) break;
                this.mBus.post((Object)new RtmpMetaDataInfoEventArgs(rtmpMetaDataInfo.streamId, rtmpMetaDataInfo.metaData));
                break;
            }
            case 309: {
                MediaVideoMsg.VideoEncodedFrameInfo encodedFrame = (MediaVideoMsg.VideoEncodedFrameInfo)msg.obj;
                if (encodedFrame == null) break;
                this.mBus.post((Object)this.convertVideoEncodedFrameInfoEventArgs(encodedFrame));
                break;
            }
            case 306: {
                MediaVideoMsg.RtmpServerStatusInfo serverStatusInfo = (MediaVideoMsg.RtmpServerStatusInfo)msg.obj;
                if (serverStatusInfo == null) break;
                this.mBus.post((Object)new RtmpServerStatusInfoEventArgs(serverStatusInfo.port, serverStatusInfo.status));
                break;
            }
            case 134: {
                MediaVideoMsg.VideoPlayDelayInfo videoDelayInfo = (MediaVideoMsg.VideoPlayDelayInfo)msg.obj;
                if (videoDelayInfo == null) break;
                this.mBus.post((Object)new VideoPlayDelayInfoEventArgs(videoDelayInfo.streamId, videoDelayInfo.playDelay));
                break;
            }
            case 137: {
                MediaVideoMsg.PublisherPtsAdjustVal ptsAdjustVal = (MediaVideoMsg.PublisherPtsAdjustVal)msg.obj;
                if (ptsAdjustVal == null) break;
                this.mBus.post((Object)new PublisherPtsAdjustValEventArgs(ptsAdjustVal.adjustVal));
                break;
            }
            case 138: {
                MediaVideoMsg.HardwareDecodeErrorInfo hdErrorInfo = (MediaVideoMsg.HardwareDecodeErrorInfo)msg.obj;
                if (hdErrorInfo == null) break;
                this.mBus.post((Object)new OnHardwareDecodeErrorInfoArgs(hdErrorInfo.errorType));
                break;
            }
            case 135: {
                MLog.info((Object)TAG, (String)"onUninstallSDK come", (Object[])new Object[0]);
                MediaVideoMsg.UninstallSDK uninstallSDK = (MediaVideoMsg.UninstallSDK)msg.obj;
                if (uninstallSDK == null) break;
                break;
            }
        }
    }

    private VideoEncodedFrameInfoEventArgs convertVideoEncodedFrameInfoEventArgs(MediaVideoMsg.VideoEncodedFrameInfo encodedFrame) {
        MediaEvent.VideoEncodedFrame encode = encodedFrame.frame;
        return new VideoEncodedFrameInfoEventArgs(encode.m_codeId, encode.m_frameType, encode.m_source, encode.m_frameId, encode.m_recvStamp, encode.m_pushDecodeStamp, encode.m_width, encode.m_heigth, encode.m_dts, encode.m_pts, encode.m_streamId, encode.m_spspps, encode.m_video);
    }
}

