/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.sdkwrapper.yylive;

import android.os.HandlerThread;
import android.support.annotation.NonNull;
import android.util.SparseArray;
import com.yy.mobile.RxBus;
import com.yy.mobile.YYHandler;
import com.yy.mobile.YYHandlerMgr;
import com.yy.mobile.sdkwrapper.BasicYYHandlerMgr;
import com.yy.mobile.sdkwrapper.yylive.LiveHandler;
import com.yy.mobile.sdkwrapper.yylive.LiveProtocol;
import com.yy.mobile.util.DESUtils;
import com.yy.mobile.util.FP;
import com.yy.mobile.util.log.MLog;
import com.yy.mobile.util.pref.CommonPref;
import com.yymobile.core.basechannel.SvcTextChat;
import com.yyproto.base.ISessWatcher;
import com.yyproto.base.IWatcher;
import com.yyproto.base.ProtoReq;
import com.yyproto.outlet.IProtoMgr;
import com.yyproto.outlet.ISession;
import com.yyproto.outlet.SessRequest;
import com.yyproto.outlet.SvcRequest;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;

enum ProtocolProcessor implements LiveProtocol
{
    INSTANCE;

    private static final String TAG = "LiveProtocolProcessor";
    private final AtomicBoolean mInitialized = new AtomicBoolean(false);
    private HandlerThread mThread;
    private LiveHandler mHandler;

    @Override
    public void initialize() {
        if (!this.mInitialized.compareAndSet(false, true)) {
            return;
        }
        this.mThread = new HandlerThread(TAG);
        this.mThread.start();
        this.mHandler = new LiveHandler(this.mThread.getLooper());
    }

    @Override
    public void release() {
        YYHandlerMgr sdkHandlerManager = BasicYYHandlerMgr.getInstance().getSdkHandlerManager();
        sdkHandlerManager.remove((YYHandler)this.mHandler);
    }

    @Override
    public void initEventHandler(@NonNull RxBus bus) {
        if (this.mHandler == null) {
            this.initialize();
        }
        this.mHandler.addBus(bus);
        YYHandlerMgr sdkHandlerManager = BasicYYHandlerMgr.getInstance().getSdkHandlerManager();
        this.getSession().watch((ISessWatcher)sdkHandlerManager);
        IProtoMgr.instance().getReport().watch((IWatcher)sdkHandlerManager);
        sdkHandlerManager.remove((YYHandler)this.mHandler);
        if (this.mHandler != null) {
            sdkHandlerManager.add((YYHandler)this.mHandler);
        }
    }

    @Override
    public void reqBulletin(long topsid, long subsid) {
        SvcRequest.SvcBulletinServiceReq req = new SvcRequest.SvcBulletinServiceReq((long)((int)topsid), (long)((int)subsid));
        this.getSession().sendRequest((ProtoReq)req);
    }

    @Override
    public void subscribeService(int[] appId2, boolean isSubscribe) {
        if (isSubscribe) {
            SvcRequest.SvcSubscribeReq svcreq = new SvcRequest.SvcSubscribeReq(appId2);
            IProtoMgr.instance().getSvc().sendRequest((ProtoReq)svcreq);
        } else {
            SvcRequest.SvcCancelSubscribeReq svcreq = new SvcRequest.SvcCancelSubscribeReq(appId2);
            IProtoMgr.instance().getSvc().sendRequest((ProtoReq)svcreq);
        }
    }

    @Override
    public void join(long topsid, long subsid, SparseArray<byte[]> props) {
        this.getSession().join(topsid, subsid, props, "app_join".getBytes());
    }

    @Override
    public void join(long sid, long subSid, SparseArray<byte[]> props, int appJoinType, byte[] appctx) {
        this.getSession().join(sid, subSid, props, appJoinType, appctx);
    }

    @Override
    public void leave() {
        this.getSession().leave();
    }

    @Override
    public void changeSubChannel(long topSid, long subSid, String password) {
        SessRequest.SessChangeSubChanReq req = new SessRequest.SessChangeSubChanReq(topSid, subSid, password.getBytes());
        this.getSession().sendRequest((ProtoReq)req);
    }

    @Override
    public void saveChannelPassword(long topSid, long subSid, String password) {
        try {
            String key = "sub_pwd_" + topSid + "_" + subSid;
            if (CommonPref.instance().contain(key)) {
                CommonPref.instance().remove(key);
            }
        }
        catch (Exception e) {
            MLog.error((Object)TAG, (String)("saveChannelPassword error! topSid = " + topSid + ", subSid = " + subSid + ", error = " + e.toString()), (Object[])new Object[0]);
        }
    }

    @Override
    public String fetchChannelPassword(long topSid, long subSid) {
        String pwd = null;
        try {
            String key = "sub_pwd_" + topSid + "_" + subSid;
            String encryptPwd = null;
            if (CommonPref.instance().contain(key)) {
                encryptPwd = CommonPref.instance().getString(key);
                CommonPref.instance().remove(key);
            }
            if (encryptPwd != null) {
                pwd = DESUtils.decrypt((String)encryptPwd);
            }
        }
        catch (Exception e) {
            MLog.error((Object)TAG, (String)("getSavedChannelPassword error! topSid = " + topSid + ", subSid = " + subSid + ", error = " + e.toString()), (Object[])new Object[0]);
        }
        return pwd == null ? "" : pwd;
    }

    @Override
    public void requestSubChannelInfo(long topSid, long subSid) {
        SessRequest.SessGetSubChInfoReq req = new SessRequest.SessGetSubChInfoReq(topSid, new long[]{topSid, subSid}, true);
        this.getSession().sendRequest((ProtoReq)req);
    }

    @Override
    public void requestChannelInfo(long topSid) {
        SessRequest.SessGetChInfoReq req = new SessRequest.SessGetChInfoReq(topSid);
        this.getSession().sendRequest((ProtoReq)req);
    }

    @Override
    public void subscribeOnlineStatChangeEvent(long topSid, boolean subscribe) {
        SessRequest.SessSubBroadcastReq req = new SessRequest.SessSubBroadcastReq(topSid, subscribe, 3);
        this.getSession().sendRequest((ProtoReq)req);
    }

    @Override
    public void requestSubChannelUserStructByPos(long topSid, long subSid, int pos) {
        SessRequest.SessUinfoPageReq req = new SessRequest.SessUinfoPageReq(subSid, 0, pos);
        req.setSid(topSid);
        int result = this.getSession().sendRequest((ProtoReq)req);
        MLog.info((Object)TAG, (String)("requestChannelOnlineList result:" + result + ", subSid:" + subSid + ", num:" + pos), (Object[])new Object[0]);
    }

    @Override
    public void requestOnlineCount(long topSid) {
        SessRequest.SessOnlineReq req = new SessRequest.SessOnlineReq(topSid, topSid);
        this.getSession().sendRequest((ProtoReq)req);
    }

    @Override
    public void sendMessageWithExtendInfo(SvcTextChat textChat, String gender, String extendJasonString) {
        if (textChat != null) {
            SvcRequest.SvcTextChatReq textChatReq = new SvcRequest.SvcTextChatReq(textChat.mSvcType, textChat.msid, textChat.mSubSid, textChat.mOriginLen, textChat.mData);
            textChatReq.setExtInfo(6, "4092".getBytes());
            if (!FP.empty((CharSequence)extendJasonString)) {
                textChatReq.setExtInfo(8, extendJasonString.getBytes());
            }
            if (textChat.mNeedBindPhone != null && textChat.mNeedBindPhone.length > 0) {
                textChatReq.setExtProps(1, textChat.mNeedBindPhone);
            }
            if (textChat.mGender != null && textChat.mGender.length > 0) {
                textChatReq.setExtInfo(3, textChat.mGender);
            }
            textChatReq.setExtProps(4, textChat.mIsDefaultChat.getBytes());
            textChatReq.setExtProps(1, "0".getBytes());
            if (!FP.empty((CharSequence)gender)) {
                textChatReq.setExtInfo(3, gender.getBytes());
            }
            IProtoMgr.instance().getSvc().sendRequest((ProtoReq)textChatReq);
        } else {
            MLog.error((Object)TAG, (String)"sendMessage req is null", (Object[])new Object[0]);
        }
    }

    @Override
    public void sendMessage(SvcTextChat textChat, String gender) {
        this.sendMessageWithExtendInfo(textChat, gender, null);
    }

    @Override
    public void requestHistoryMsg(long topSid, long subSid) {
        SvcRequest.SvcHistoryTextChatReq reqHistory = new SvcRequest.SvcHistoryTextChatReq(topSid, subSid);
        IProtoMgr.instance().getSvc().sendRequest((ProtoReq)reqHistory);
    }

    @Override
    public void reqSubChannelAdminList(long topSid, long subSid) {
        ArrayList<Long> sublist = new ArrayList<Long>();
        sublist.add(subSid);
        SessRequest.SessPullSubChAdminReq req = new SessRequest.SessPullSubChAdminReq(topSid, sublist);
        MLog.info((Object)TAG, (String)("sessPullSubChAdminReq currentChannelInfo.topSid = " + topSid + " currentChannelInfo.subSid = " + subSid), (Object[])new Object[0]);
        this.getSession().sendRequest((ProtoReq)req);
    }

    @Override
    public void reqChannelAdminList(long sid) {
        SessRequest.SessPullAdminReq req = new SessRequest.SessPullAdminReq(sid);
        MLog.info((Object)TAG, (String)("sessPullSubChAdminReq currentChannelInfo.topSid = " + sid), (Object[])new Object[0]);
        this.getSession().sendRequest((ProtoReq)req);
    }

    @Override
    public void queryUserForbidden(long uid, long topSid, long subSid) {
        SessRequest.SessUserChatCtrlReq req = new SessRequest.SessUserChatCtrlReq(uid, topSid, subSid);
        this.getSession().sendRequest((ProtoReq)req);
    }

    @Override
    public void changeMicStatus(long topSid, boolean disable) {
        SessRequest.SessMicDisableReq req = new SessRequest.SessMicDisableReq(topSid, disable);
        req.setSid(topSid);
        this.getSession().sendRequest((ProtoReq)req);
    }

    @Override
    public void changeMicUser(long topSid, boolean addOrRemove) {
        if (!addOrRemove) {
            SessRequest.SessMicLeaveReq req = new SessRequest.SessMicLeaveReq();
            req.setSid(topSid);
            this.getSession().sendRequest((ProtoReq)req);
        } else {
            SessRequest.SessMicJoinReq req = new SessRequest.SessMicJoinReq();
            req.setSid(topSid);
            this.getSession().sendRequest((ProtoReq)req);
        }
    }

    @Override
    public void changeMicUserByAdmin(long uid, long topSid, boolean addOrRemove) {
        if (addOrRemove) {
            SessRequest.SessMicTuorenReq req = new SessRequest.SessMicTuorenReq(topSid, uid);
            this.getSession().sendRequest((ProtoReq)req);
        } else {
            SessRequest.SessMicKickOffReq req = new SessRequest.SessMicKickOffReq(topSid, uid);
            this.getSession().sendRequest((ProtoReq)req);
        }
    }

    @Override
    public void changeMicMute(long topSid, boolean isMute) {
        SessRequest.SessMicMuteReq req = new SessRequest.SessMicMuteReq(topSid, isMute);
        this.getSession().sendRequest((ProtoReq)req);
    }

    @Override
    public void processMicInvited(long uid, long topSid, boolean isAccept) {
        SessRequest.SessInviteChorusMicRes res = new SessRequest.SessInviteChorusMicRes();
        res.setSid(topSid);
        res.mic_first = uid;
        res.res = isAccept ? 1 : 0;
        this.getSession().sendRequest((ProtoReq)res);
    }

    @Override
    public void reqMicInvited(long inviteeUid, long invitedUid, long topSid, boolean isInvite) {
        SessRequest.SessInviteModChorusMic sessReq = new SessRequest.SessInviteModChorusMic(topSid);
        sessReq.bAdd = isInvite;
        sessReq.invitee = inviteeUid;
        sessReq.mic_first = invitedUid;
        this.getSession().sendRequest((ProtoReq)sessReq);
    }

    @Override
    public void reqPrivateChat(long toUid, long topSid, String text, String context) {
        MLog.info((Object)TAG, (String)("reqPrivateChat: toUid = " + toUid + ", topSid = " + topSid + ", text = " + text), (Object[])new Object[0]);
        SessRequest.SessOneChatReq sessOneChatReq = new SessRequest.SessOneChatReq(toUid, text);
        sessOneChatReq.setSid(topSid);
        sessOneChatReq.setCtx(context);
        this.getSession().sendRequest((ProtoReq)sessOneChatReq);
    }

    @Override
    public void queryUserStruct(long topSid, @NonNull long[] uids) {
        SessRequest.SessUinfoReq req = new SessRequest.SessUinfoReq();
        req.setSid(topSid);
        req.uids = uids;
        this.getSession().sendRequest((ProtoReq)req);
    }

    @Override
    public void forbitUser(long uid, long topSid, long subSid, boolean disable, byte[] reason) {
        SessRequest.SessDisableUserTextReq req = new SessRequest.SessDisableUserTextReq(topSid, subSid, disable, uid, reason);
        this.getSession().sendRequest((ProtoReq)req);
    }

    @Override
    public void reqKickOff(long sid, long subSid, long beRemovedUid, int secs, byte[] reason) {
        SessRequest.SessDirectKickOffReq req = new SessRequest.SessDirectKickOffReq(sid, subSid, beRemovedUid, secs, reason);
        this.getSession().sendRequest((ProtoReq)req);
    }

    @Override
    public void reqSubChannelForbiddenList(long topSid, long subSid) {
        SessRequest.SessGetSubChannelDisableInfo req = new SessRequest.SessGetSubChannelDisableInfo(topSid, subSid);
        this.getSession().sendRequest((ProtoReq)req);
    }

    @Override
    public void reqForbitText(long topSid, long subSid, int banType) {
        SessRequest.SessSubChannelTextCtrlReq req = new SessRequest.SessSubChannelTextCtrlReq(topSid, subSid, banType);
        this.getSession().sendRequest((ProtoReq)req);
    }

    @Override
    public void changeUserRole(long uid, long topSid, long subsid, int origRole, int targetRole) {
        if (targetRole == 200) {
            SessRequest.SessUpdateChMemeberPerm req = new SessRequest.SessUpdateChMemeberPerm(topSid, subsid, uid, origRole, targetRole, false);
            this.getSession().sendRequest((ProtoReq)req);
        } else {
            SessRequest.SessUpdateChMemeberPerm req = new SessRequest.SessUpdateChMemeberPerm(topSid, subsid, uid, origRole, targetRole, true);
            this.getSession().sendRequest((ProtoReq)req);
        }
    }

    @Override
    public void reqUserPermissions(long topSid, long uid) {
        SessRequest.SessGetUserPermReq req = new SessRequest.SessGetUserPermReq(topSid, uid);
        this.getSession().sendRequest((ProtoReq)req);
    }

    @Override
    public void requestAdd2ndQueueAndChorus(long topSid, long uid, int time) {
        SessRequest.SessAdd2ndQueueAndChorusReq req = new SessRequest.SessAdd2ndQueueAndChorusReq(topSid, uid, time);
        this.getSession().sendRequest((ProtoReq)req);
    }

    @Override
    public void addBus(@NonNull RxBus bus) {
        if (this.mHandler != null) {
            this.mHandler.addBus(bus);
        }
    }

    @Override
    public void removeBus(@NonNull RxBus bus) {
        if (this.mHandler != null) {
            this.mHandler.remove(bus);
        }
    }

    @Override
    public long getSid() {
        return this.getSession().getSid();
    }

    @Override
    public long getSubSid() {
        return this.getSession().getSubSid();
    }

    private ISession getSession() {
        return IProtoMgr.instance().getSess();
    }
}

