/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.sdkwrapper.yylive;

import android.os.HandlerThread;
import android.support.annotation.NonNull;
import com.yy.mobile.YYHandler;
import com.yy.mobile.YYHandlerMgr;
import com.yy.mobile.sdkwrapper.BasicYYHandlerMgr;
import com.yy.mobile.sdkwrapper.yylive.ImUserInfo;
import com.yy.mobile.sdkwrapper.yylive.LiveForOutsideHandler;
import com.yy.mobile.sdkwrapper.yylive.LiveForOutsideProtocol;
import com.yy.mobile.util.log.MLog;
import com.yymobile.core.channel.channelout.ChannelStatusId;
import com.yymobile.core.user.Gender;
import com.yyproto.base.ProtoReq;
import com.yyproto.outlet.IProtoMgr;
import com.yyproto.outlet.ISession;
import com.yyproto.outlet.LoginRequest;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicBoolean;

enum ProtocolForOutsideProcessor implements LiveForOutsideProtocol
{
    INSTANCE;

    private static final String TAG = "LiveForOutsideProtocolProcessor";
    private final AtomicBoolean mInitialized = new AtomicBoolean(false);
    private HandlerThread mThread;
    private LiveForOutsideHandler mHandler;
    private int requestreqGetIMUInfoReqSubSize = 50;

    @Override
    public void initialize() {
        if (!this.mInitialized.compareAndSet(false, true)) {
            return;
        }
        this.mThread = new HandlerThread(TAG);
        this.mThread.start();
        this.mHandler = new LiveForOutsideHandler(this.mThread.getLooper());
    }

    @Override
    public void release() {
        YYHandlerMgr sdkHandlerManager = BasicYYHandlerMgr.getInstance().getSdkHandlerManager();
        if (sdkHandlerManager != null) {
            sdkHandlerManager.remove((YYHandler)this.mHandler);
        }
    }

    @Override
    public void initEventHandler() {
        YYHandlerMgr sdkHandlerManager = BasicYYHandlerMgr.getInstance().getSdkHandlerManager();
        if (sdkHandlerManager != null && this.mHandler != null) {
            sdkHandlerManager.add((YYHandler)this.mHandler);
        }
    }

    @Override
    public void reqChannelInfoList(List<ChannelStatusId> idList) {
        LoginRequest.MultiChannelInfoReq sycReq = new LoginRequest.MultiChannelInfoReq();
        sycReq.mNeedAllProp = true;
        TreeMap<Long, LoginRequest.ChannSubIdSet> channelIdSet = new TreeMap<Long, LoginRequest.ChannSubIdSet>();
        for (int i = 0; i < idList.size(); ++i) {
            channelIdSet.put(idList.get(i).getTopSid(), new LoginRequest.ChannSubIdSet(new long[]{idList.get(i).getSubSid()}));
        }
        sycReq.mTopId2SubSids = channelIdSet;
        this.getSession().sendRequest((ProtoReq)sycReq);
    }

    @Override
    public void reqChannelListById(long uid) {
        LoginRequest.GetGuildInfoReq sycReq = new LoginRequest.GetGuildInfoReq(uid);
        this.getSession().sendRequest((ProtoReq)sycReq);
    }

    @Override
    public void reqMyChannelList() {
        LoginRequest.SyncMyListReq sycReq = new LoginRequest.SyncMyListReq();
        sycReq.cmd = (byte)4;
        this.getSession().sendRequest((ProtoReq)sycReq);
    }

    @Override
    public void requestCollectionChannelList() {
        LoginRequest.SyncMyListReq sycReq = new LoginRequest.SyncMyListReq();
        sycReq.cmd = 1;
        this.getSession().sendRequest((ProtoReq)sycReq);
    }

    @Override
    public void collectChannel(long topsid, boolean isFavor) {
        LoginRequest.ModSListReq req = new LoginRequest.ModSListReq(topsid, isFavor);
        this.getSession().sendRequest((ProtoReq)req);
    }

    @Override
    public void reqModifyImUser(@NonNull Map<Integer, byte[]> userInfo) {
        MLog.info((Object)TAG, (String)"reqModifyImUser userInfo Map<Integer, byte[]>: %s", (Object[])new Object[]{userInfo});
        LoginRequest.ModIMUInfoReq req = new LoginRequest.ModIMUInfoReq();
        for (Map.Entry<Integer, byte[]> info : userInfo.entrySet()) {
            if (info.getValue() == null) continue;
            req.setProps(info.getKey().intValue(), info.getValue());
            MLog.info((Object)TAG, (String)"reqModifyImUser userInfo Map<Integer, byte[]> key: %d, value: %s", (Object[])new Object[]{info.getKey(), new String(info.getValue())});
        }
        this.getSession().sendRequest((ProtoReq)req);
    }

    @Override
    public void reqModifyImUser(@NonNull ImUserInfo userInfo) {
        MLog.info((Object)TAG, (String)"reqModifyImUser userInfo: %s", (Object[])new Object[]{userInfo});
        LoginRequest.ModIMUInfoReq req = new LoginRequest.ModIMUInfoReq();
        if (userInfo.nickName != null) {
            req.setProps(2, userInfo.nickName.getBytes());
        }
        if (userInfo.signature != null) {
            req.setProps(54, userInfo.signature.getBytes());
        }
        if (userInfo.description != null) {
            req.setProps(56, userInfo.description.getBytes());
        }
        req.setProps(8, String.valueOf(userInfo.area).getBytes());
        req.setProps(3, String.valueOf(userInfo.birthday).getBytes());
        req.setProps(10, String.valueOf(userInfo.city).getBytes());
        if (userInfo.gender != null) {
            req.setProps(5, String.valueOf(this.getGender(userInfo)).getBytes());
        }
        req.setProps(9, String.valueOf(userInfo.province).getBytes());
        this.getSession().sendRequest((ProtoReq)req);
    }

    @Override
    public void queryImUser(String ctx, @NonNull List<Long> userId) {
        LoginRequest.GetIMUInfoReq req = new LoginRequest.GetIMUInfoReq();
        req.setCtx(ctx);
        req.mProps.add("id".getBytes());
        req.mProps.add("nick".getBytes());
        req.mProps.add("sex".getBytes());
        req.mProps.add("birthday".getBytes());
        req.mProps.add("area".getBytes());
        req.mProps.add("province".getBytes());
        req.mProps.add("city".getBytes());
        req.mProps.add("sign".getBytes());
        req.mProps.add("intro".getBytes());
        req.mProps.add("jifen".getBytes());
        req.mProps.add("yyno".getBytes());
        req.mProps.add("logo_index".getBytes());
        req.mProps.add("custom_logo".getBytes());
        req.mProps.add("hd_logo_100".getBytes());
        req.mProps.add("hd_logo_144".getBytes());
        req.mProps.add("hd_logo_640".getBytes());
        req.mProps.add("stage_name".getBytes());
        if (userId.size() > this.requestreqGetIMUInfoReqSubSize) {
            int count = userId.size() / this.requestreqGetIMUInfoReqSubSize;
            int indexOfSize = userId.size() % this.requestreqGetIMUInfoReqSubSize;
            count = indexOfSize == 0 ? count : count + 1;
            for (int i = 0; i < count; ++i) {
                int index = i * this.requestreqGetIMUInfoReqSubSize;
                long[] indexOfUidList = indexOfSize != 0 && i == count - 1 ? new long[indexOfSize] : new long[this.requestreqGetIMUInfoReqSubSize];
                for (int j = 0; j < this.requestreqGetIMUInfoReqSubSize && index < userId.size(); ++j) {
                    indexOfUidList[j] = userId.get(index++);
                }
                MLog.info((Object)TAG, (String)("reqGetIMUInfoReq indexOfUidList: " + indexOfUidList.length), (Object[])new Object[0]);
                req.mUids = indexOfUidList;
                this.getSession().sendRequest((ProtoReq)req);
            }
        } else {
            long[] mUids = new long[userId.size()];
            for (int i = 0; i < userId.size(); ++i) {
                long id2;
                mUids[i] = id2 = userId.get(i).longValue();
            }
            req.mUids = mUids;
            this.getSession().sendRequest((ProtoReq)req);
        }
    }

    private int getGender(ImUserInfo info) {
        if (info != null) {
            if (info.gender.equals((Object)Gender.Female)) {
                return 0;
            }
            if (info.gender.equals((Object)Gender.Male)) {
                return 1;
            }
            return 2;
        }
        return 2;
    }

    private ISession getSession() {
        return IProtoMgr.instance().getSess();
    }
}

