/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.sdkwrapper.yylive;

import android.os.Looper;
import android.support.annotation.NonNull;
import android.util.SparseArray;
import com.yy.mobile.RxBus;
import com.yy.mobile.YYHandler;
import com.yy.mobile.bizmodel.live.ImUserInfo;
import com.yy.mobile.bizmodel.live.QueryChannelStruct;
import com.yy.mobile.sdkwrapper.yylive.event.GetMobileUserInfoResEventArgs;
import com.yy.mobile.sdkwrapper.yylive.event.outside.CancelCollectionChannelEventArgs;
import com.yy.mobile.sdkwrapper.yylive.event.outside.CollectionChannelEventArgs;
import com.yy.mobile.sdkwrapper.yylive.event.outside.ModifyImUserResEventArgs;
import com.yy.mobile.sdkwrapper.yylive.event.outside.QueryChannelEventArgs;
import com.yy.mobile.sdkwrapper.yylive.event.outside.QueryChannelListEventArgs;
import com.yy.mobile.sdkwrapper.yylive.event.outside.QueryImUserEventArgs;
import com.yy.mobile.util.log.MLog;
import com.yymobile.core.profile.MyChannelInfo;
import com.yyproto.outlet.LoginEvent;
import com.yyproto.outlet.SvcEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;

public class LiveForOutsideHandler
extends YYHandler {
    private static final String TAG = "LiveForOutsideHandler";

    LiveForOutsideHandler(@NonNull Looper looper) {
        super(looper);
    }

    @YYHandler.MessageHandler(message=10017)
    public void onAddChannelSList(LoginEvent.ETAddSListRes et) {
        if (et == null) {
            MLog.info((Object)TAG, (String)"onAddChannelSList et=null", (Object[])new Object[0]);
            return;
        }
        MLog.info((Object)TAG, (String)("ETLOGIN_ADD_SLIST_RES sid=" + et.sid + " nick=" + new String(et.nick)), (Object[])new Object[0]);
        RxBus.getDefault().post((Object)new CollectionChannelEventArgs(et.sid, 0L));
    }

    @YYHandler.MessageHandler(message=10018)
    public void onRemoveChannelSList(LoginEvent.ETRemoveSListRes et) {
        if (et == null) {
            MLog.info((Object)TAG, (String)"onRemoveChannelSList et=null", (Object[])new Object[0]);
            return;
        }
        MLog.info((Object)TAG, (String)("ETLOGIN_REMOVE_SLIST_RES sid=" + et.sid), (Object[])new Object[0]);
        RxBus.getDefault().post((Object)new CancelCollectionChannelEventArgs(et.sid, 0L));
    }

    @YYHandler.MessageHandler(message=10022)
    public void onChannelInfoListById(LoginEvent.ETMultiReqChannelInfoRes et) {
        if (et == null) {
            MLog.info((Object)TAG, (String)"onChannelInfoListById et=null", (Object[])new Object[0]);
            return;
        }
        if (et.topSid2SubSidsProps == null) {
            MLog.info((Object)TAG, (String)"onChannelInfoListById topSid2SubSidsProps =null", (Object[])new Object[0]);
            return;
        }
        RxBus.getDefault().post((Object)new QueryChannelEventArgs(this.convertQueryChannel(et.topSid2SubSidsProps)));
    }

    @YYHandler.MessageHandler(message=10012)
    public void onChannelList(LoginEvent.ETListKeyVal et) {
        ArrayList<MyChannelInfo> infoList = new ArrayList<MyChannelInfo>();
        for (LoginEvent.ChListKeyVal info : et.chLists) {
            long sid = info.getSid();
            long asid = info.getAsid();
            String channelName = new String(info.getStrVal(100));
            String logo = new String(info.getStrVal(101));
            int roler = info.getIntVal(7);
            MyChannelInfo minfo = new MyChannelInfo();
            minfo.setChannelLogo(logo);
            minfo.setChannelName(channelName);
            minfo.setTopSid(sid);
            minfo.setTopAsid(asid);
            if (sid == asid) {
                minfo.setSubSid(sid);
            }
            minfo.setRole(roler);
            infoList.add(minfo);
        }
        RxBus.getDefault().post((Object)new QueryChannelListEventArgs(et.mType, et.mUid, infoList));
    }

    @YYHandler.MessageHandler(message=10016)
    public void onUInfoModRes(LoginEvent.ETUInfoModRes evt) {
        String limitEndTime = "";
        if (evt.limit_end_time != null) {
            limitEndTime = new String(evt.limit_end_time);
        }
        MLog.info((Object)TAG, (String)("onUInfoModRes resCode=" + evt.resCode + " limit_end_time=" + limitEndTime), (Object[])new Object[0]);
        RxBus.getDefault().post((Object)new ModifyImUserResEventArgs(evt.resCode, limitEndTime, (SparseArray<byte[]>)evt.props));
    }

    @YYHandler.MessageHandler(message=10015)
    public void onIMUInfo(LoginEvent.ETIMUInfoKeyVal evt) {
        RxBus.getDefault().post((Object)new QueryImUserEventArgs(evt.getCtx(), evt.resCode, this.convertQueryUsers(evt.uinfos)));
    }

    @YYHandler.MessageHandler(message=10)
    public void onGetMobileUserInfoRes(SvcEvent.ETSvcMobileUserInfoRes et) {
        MLog.info((Object)TAG, (String)"onGetMobileUserInfoRes...", (Object[])new Object[0]);
        if (et == null) {
            MLog.info((Object)TAG, (String)"onGetMobileUserInfoRes  et is null", (Object[])new Object[0]);
            return;
        }
        RxBus.getDefault().post((Object)new GetMobileUserInfoResEventArgs(et.mContext, et.mErrmsg, et.mErrcode, et.mMobiles));
    }

    private List<ImUserInfo> convertQueryUsers(LoginEvent.IMUInfo[] uinfos) {
        ArrayList<ImUserInfo> imUserInfos = new ArrayList<ImUserInfo>();
        if (uinfos != null) {
            for (LoginEvent.IMUInfo info : uinfos) {
                imUserInfos.add(new ImUserInfo(info.val));
            }
        }
        return imUserInfos;
    }

    private TreeMap<Long, QueryChannelStruct> convertQueryChannel(TreeMap<Long, LoginEvent.SubSidsProps> props) {
        TreeMap<Long, QueryChannelStruct> queryStruct = new TreeMap<Long, QueryChannelStruct>();
        if (props != null) {
            for (Long sid : props.keySet()) {
                LoginEvent.SubSidsProps prop = props.get(sid);
                queryStruct.put(sid, new QueryChannelStruct(prop.resCode, prop.subSid2props));
            }
        }
        return queryStruct;
    }
}

