/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.sdkwrapper.servicespi;

import android.os.HandlerThread;
import com.yy.mobile.YYHandler;
import com.yy.mobile.sdkwrapper.servicespi.ChannelId;
import com.yy.mobile.sdkwrapper.servicespi.OnDateReceiveListener;
import com.yy.mobile.sdkwrapper.servicespi.ServiceProtocol;
import com.yy.mobile.sdkwrapper.servicespi.SubscribeInfo;
import com.yy.mobile.sdkwrapper.yylive.sdkadapt.SdkAdapter;
import com.yy.mobile.util.log.MLog;
import com.yy.udbauth.AuthSDK;
import com.yy.udbauth.Global;
import com.yyproto.base.ProtoReq;
import com.yyproto.outlet.IProtoMgr;
import com.yyproto.outlet.ISvc;
import com.yyproto.outlet.SvcEvent;
import com.yyproto.outlet.SvcRequest;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;

enum ProtocolProcessor implements ServiceProtocol
{
    INSTANCE;

    private static final String TAG = "ServiceProtocolProcessor";
    private final AtomicBoolean mInitialized = new AtomicBoolean(false);
    private YYHandler handler;
    private final List<OnDateReceiveListener> mOnDateReceiveListeners = new CopyOnWriteArrayList<OnDateReceiveListener>();
    private HandlerThread mSvcHandlerThread = new HandlerThread("handlerSvcDataThread");
    private AtomicInteger mSvcState = new AtomicInteger(0);
    private String mSvcApIp;
    private List<ChannelId> mJoinedGroupChannelList = new ArrayList<ChannelId>();
    private List<SubscribeInfo> mSubscribeInfoList = new ArrayList<SubscribeInfo>();

    @Override
    public void initialize() {
        if (!this.mInitialized.compareAndSet(false, true)) {
            return;
        }
        this.mSvcHandlerThread.start();
        this.handler = new YYHandler(this.mSvcHandlerThread.getLooper()){
            int cachedApIp;
            {
                this.cachedApIp = -1;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @YYHandler.MessageHandler(message=1)
            public void onSvcData(SvcEvent.ETSvcData evt) {
                if (evt == null) {
                    MLog.error((Object)"YYServiceApiImpl", (String)"OnSvcData is null!", (Object[])new Object[0]);
                    return;
                }
                List list = ProtocolProcessor.this.mOnDateReceiveListeners;
                synchronized (list) {
                    for (OnDateReceiveListener listener : ProtocolProcessor.this.mOnDateReceiveListeners) {
                        listener.onDateReceive(evt.mSvcType, evt.mData);
                    }
                }
            }

            @YYHandler.MessageHandler(message=2)
            public void onSubscribeRes(SvcEvent.ETSvcSubscribeRes evt) {
                MLog.info((Object)ProtocolProcessor.TAG, (String)("SvcEvent.ETSvcSubscribeRes mSuccessTypes " + evt.mSuccessTypes + " mFailSvcTypes " + evt.mFailSvcTypes), (Object[])new Object[0]);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @YYHandler.MessageHandler(message=3)
            public void onChannelState(SvcEvent.ETSvcChannelState evt) {
                MLog.info((Object)ProtocolProcessor.TAG, (String)"onChannelState: %d -> %d", (Object[])new Object[]{ProtocolProcessor.this.mSvcState.get(), evt.state});
                ProtocolProcessor.this.mSvcState.set(evt.state);
                ProtocolProcessor.this.mSvcApIp = evt.getApIpString();
                List list = ProtocolProcessor.this.mOnDateReceiveListeners;
                synchronized (list) {
                    for (OnDateReceiveListener listener : ProtocolProcessor.this.mOnDateReceiveListeners) {
                        listener.onChannelState(evt.state);
                    }
                }
                if (evt.mApIp != this.cachedApIp) {
                    this.cachedApIp = evt.mApIp;
                    MLog.debug((Object)ProtocolProcessor.TAG, (String)"onChannelState ApIp change, ip=%s", (Object[])new Object[]{ProtocolProcessor.this.mSvcApIp});
                    list = ProtocolProcessor.this.mOnDateReceiveListeners;
                    synchronized (list) {
                        for (OnDateReceiveListener listener : ProtocolProcessor.this.mOnDateReceiveListeners) {
                            listener.onServiceApIp(ProtocolProcessor.this.mSvcApIp);
                        }
                    }
                }
            }
        };
    }

    @Override
    public void initEventHandler() {
        if (this.handler != null) {
            SdkAdapter.getSdkHandlerManager().add(this.handler);
        }
    }

    @Override
    public void release() {
        SdkAdapter.getSdkHandlerManager().remove(this.handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addOnDataReceiveListener(OnDateReceiveListener onDataReceiveListener) {
        List<OnDateReceiveListener> list = this.mOnDateReceiveListeners;
        synchronized (list) {
            if (!this.mOnDateReceiveListeners.contains(onDataReceiveListener)) {
                MLog.info((Object)TAG, (String)"addOnDataReceiveListener: %s", (Object[])new Object[]{onDataReceiveListener});
                this.mOnDateReceiveListeners.add(onDataReceiveListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeOnDataReceiveListener(OnDateReceiveListener onDateReceiveListener) {
        MLog.info((Object)TAG, (String)"removeOnDataReceiveListener: %s", (Object[])new Object[]{onDateReceiveListener});
        List<OnDateReceiveListener> list = this.mOnDateReceiveListeners;
        synchronized (list) {
            this.mOnDateReceiveListeners.remove(onDateReceiveListener);
        }
    }

    @Override
    public void joinGroup(long groupType, long groupId) {
        try {
            SvcRequest.UserGroupIdAndType userGroupIdAndType = new SvcRequest.UserGroupIdAndType();
            userGroupIdAndType.mGroupType = groupType;
            userGroupIdAndType.mGroupId = groupId;
            SvcRequest.UserGroupIdAndType[] userGroupIdAndTypes = new SvcRequest.UserGroupIdAndType[]{userGroupIdAndType};
            MLog.info((Object)TAG, (String)("setSvcJoinGroupReq userGroupIdAndTypes = " + userGroupIdAndTypes + "USER_GROUP_ID_AND_TYPE_DEFAULT_GROUP_ID = " + groupId), (Object[])new Object[0]);
            SvcRequest.SvcJoinGroupReq svcJoinGroupReq = new SvcRequest.SvcJoinGroupReq(userGroupIdAndTypes);
            this.getService().sendRequest((ProtoReq)svcJoinGroupReq);
        }
        catch (Throwable throwable) {
            MLog.error((Object)TAG, (String)"setSvcJoinGroupReq error", (Throwable)throwable, (Object[])new Object[0]);
        }
    }

    @Override
    public void joinGroupWithChannelId(long sid, long ssid) {
        MLog.info((Object)TAG, (String)("joinGroupWithChannelId ssid = " + ssid), (Object[])new Object[0]);
        try {
            SvcRequest.UserGroupIdAndType sidType = new SvcRequest.UserGroupIdAndType();
            sidType.mGroupType = 1L;
            sidType.mGroupId = sid;
            SvcRequest.UserGroupIdAndType ssidType = new SvcRequest.UserGroupIdAndType();
            ssidType.mGroupType = 2L;
            ssidType.mGroupId = ssid;
            SvcRequest.UserGroupIdAndType[] userGroupIdAndTypes = new SvcRequest.UserGroupIdAndType[]{sidType, ssidType};
            SvcRequest.SvcJoinGroupReq svcJoinGroupReq = new SvcRequest.SvcJoinGroupReq(userGroupIdAndTypes);
            this.getService().sendRequest((ProtoReq)svcJoinGroupReq);
            this.mJoinedGroupChannelList.add(new ChannelId(sid, ssid));
        }
        catch (Throwable throwable) {
            MLog.error((Object)TAG, (String)"setSvcJoinGroupReq error", (Throwable)throwable, (Object[])new Object[0]);
        }
    }

    @Override
    public void leaveGroupWithChannelId(long sid, long ssid) {
        MLog.info((Object)TAG, (String)("leaveGroupWithChannelId ssid = " + ssid), (Object[])new Object[0]);
        try {
            SvcRequest.UserGroupIdAndType sidType = new SvcRequest.UserGroupIdAndType();
            sidType.mGroupType = 1L;
            sidType.mGroupId = sid;
            SvcRequest.UserGroupIdAndType ssidType = new SvcRequest.UserGroupIdAndType();
            ssidType.mGroupType = 2L;
            ssidType.mGroupId = ssid;
            SvcRequest.UserGroupIdAndType[] userGroupIdAndTypes = new SvcRequest.UserGroupIdAndType[]{sidType, ssidType};
            SvcRequest.SvcLeaveGroupReq svcLeaveGroupReq = new SvcRequest.SvcLeaveGroupReq(userGroupIdAndTypes);
            this.getService().sendRequest((ProtoReq)svcLeaveGroupReq);
            this.mJoinedGroupChannelList.remove(new ChannelId(sid, ssid));
        }
        catch (Throwable throwable) {
            MLog.error((Object)TAG, (String)"setCancelSvcJoinGroupReq error", (Throwable)throwable, (Object[])new Object[0]);
        }
    }

    @Override
    public void leaveAllGroupBeforeJoinChannel() {
        MLog.info((Object)TAG, (String)"leaveAllGroupBeforeJoinChannel ", (Object[])new Object[0]);
        ArrayList<ChannelId> temp = new ArrayList<ChannelId>(this.mJoinedGroupChannelList);
        for (int i = 0; i < temp.size(); ++i) {
            this.leaveGroupWithChannelId(((ChannelId)temp.get((int)i)).sid, ((ChannelId)temp.get((int)i)).ssid);
        }
        ArrayList<SubscribeInfo> tempSubscribeInfo = new ArrayList<SubscribeInfo>(this.mSubscribeInfoList);
        for (int j = 0; j < tempSubscribeInfo.size(); ++j) {
            this.unSubscribeMultiChannelMessageInChannel(((SubscribeInfo)tempSubscribeInfo.get((int)j)).subscribeType, ((SubscribeInfo)tempSubscribeInfo.get((int)j)).ssidList);
        }
    }

    @Override
    public void subscribeMultiChannelMessage(int[] subscribeType, List<Long> ssid, boolean autoUnsubsribeJoinChannel) {
        if (ssid == null || ssid.isEmpty()) {
            return;
        }
        try {
            ArrayList<SvcRequest.UserGroupIdAndAppid> items = new ArrayList<SvcRequest.UserGroupIdAndAppid>();
            for (Long channelSsid : ssid) {
                SvcRequest.UserGroupIdAndAppid groupIdAndAppid = new SvcRequest.UserGroupIdAndAppid();
                groupIdAndAppid.mGroupType = 2L;
                groupIdAndAppid.mGroupId = channelSsid;
                groupIdAndAppid.mAppIds = subscribeType;
                items.add(groupIdAndAppid);
                MLog.info((Object)TAG, (String)("subscribeMultiChannelMessageInChannel ssid: " + channelSsid + " subscribeType: " + subscribeType), (Object[])new Object[0]);
            }
            this.mSubscribeInfoList.add(new SubscribeInfo(subscribeType, ssid));
            SvcRequest.SvcSubScribeGroupAndAppidReq subSvcReq = new SvcRequest.SvcSubScribeGroupAndAppidReq(items.toArray(new SvcRequest.UserGroupIdAndAppid[items.size()]));
            this.getService().sendRequest((ProtoReq)subSvcReq);
        }
        catch (Throwable throwable) {
            MLog.error((Object)TAG, (String)"subscribeMultiChannelMessageInChannel error", (Throwable)throwable, (Object[])new Object[0]);
        }
    }

    @Override
    public void unSubscribeMultiChannelMessageInChannel(int[] subscribeType, List<Long> ssid) {
        if (ssid == null || ssid.isEmpty()) {
            return;
        }
        try {
            ArrayList<SvcRequest.UserGroupIdAndAppid> items = new ArrayList<SvcRequest.UserGroupIdAndAppid>();
            for (Long channelSsid : ssid) {
                SvcRequest.UserGroupIdAndAppid groupIdAndAppid = new SvcRequest.UserGroupIdAndAppid();
                groupIdAndAppid.mGroupType = 2L;
                groupIdAndAppid.mGroupId = channelSsid;
                groupIdAndAppid.mAppIds = subscribeType;
                items.add(groupIdAndAppid);
                MLog.info((Object)TAG, (String)("unSubscribeMultiChannelMessageInChannel ssid: " + channelSsid + " subscribeType: " + subscribeType), (Object[])new Object[0]);
            }
            this.mSubscribeInfoList.remove(new SubscribeInfo(subscribeType, ssid));
            SvcRequest.SvcUnsubScribeGroupAndAppidReq subSvcReq = new SvcRequest.SvcUnsubScribeGroupAndAppidReq(items.toArray(new SvcRequest.UserGroupIdAndAppid[items.size()]));
            this.getService().sendRequest((ProtoReq)subSvcReq);
        }
        catch (Throwable throwable) {
            MLog.error((Object)TAG, (String)"unSubscribeMultiChannelMessageInChannel error", (Throwable)throwable, (Object[])new Object[0]);
        }
    }

    @Override
    public void leaveGroup(long groupType, long groupId) {
        try {
            SvcRequest.UserGroupIdAndType userGroupIdAndType = new SvcRequest.UserGroupIdAndType();
            userGroupIdAndType.mGroupType = groupType;
            userGroupIdAndType.mGroupId = groupId;
            SvcRequest.UserGroupIdAndType[] userGroupIdAndTypes = new SvcRequest.UserGroupIdAndType[]{userGroupIdAndType};
            MLog.info((Object)TAG, (String)("setCancelSvcJoinGroupReq userGroupIdAndTypes = " + userGroupIdAndTypes + "USER_GROUP_ID_AND_TYPE_DEFAULT_GROUP_ID = " + groupId), (Object[])new Object[0]);
            SvcRequest.SvcLeaveGroupReq svcLeaveGroupReq = new SvcRequest.SvcLeaveGroupReq(userGroupIdAndTypes);
            this.getService().sendRequest((ProtoReq)svcLeaveGroupReq);
        }
        catch (Throwable throwable) {
            MLog.error((Object)TAG, (String)"setCancelSvcJoinGroupReq error", (Throwable)throwable, (Object[])new Object[0]);
        }
    }

    @Override
    public void converPhoneNumToUid(String index, String[] mobiles) {
        SvcRequest.SvcGetMobileUserInfoReq req = new SvcRequest.SvcGetMobileUserInfoReq(index, Global.getAppId(), AuthSDK.getDeviceData(), AuthSDK.getOTP((String)Global.getAppId()), mobiles);
        this.getService().sendRequest((ProtoReq)req);
    }

    private ISvc getService() {
        return IProtoMgr.instance().getSvc();
    }

    @Override
    public HandlerThread getSvcHandlerThread() {
        return this.mSvcHandlerThread;
    }

    @Override
    public int getSvcState() {
        return this.mSvcState.get();
    }

    @Override
    @Nullable
    public String getSvcApIp() {
        return this.mSvcApIp;
    }
}

