/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.sdkwrapper.player.vod;

import android.content.Context;
import android.graphics.Bitmap;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.ViewGroup;
import com.medialib.video.MediaVideoMsg;
import com.yy.IMediaVideo;
import com.yy.IMediaVideoSDK;
import com.yy.mobile.YYHandler;
import com.yy.mobile.config.BasicConfig;
import com.yy.mobile.memoryrecycle.views.YYRelativeLayout;
import com.yy.mobile.sdkwrapper.R;
import com.yy.mobile.sdkwrapper.player.vod.IVideoPlayer;
import com.yy.mobile.sdkwrapper.player.vod.PlayerCallback;
import com.yy.mobile.sdkwrapper.player.vod.PlayerPlayInfo;
import com.yy.mobile.sdkwrapper.player.vod.ReplayUtil;
import com.yy.mobile.sdkwrapper.player.vod.constants.DecodeType;
import com.yy.mobile.sdkwrapper.player.vod.constants.State;
import com.yy.mobile.sdkwrapper.player.vod.constants.ViewType;
import com.yy.mobile.sdkwrapper.yylive.media.ui.YYVideoView;
import com.yy.mobile.sdkwrapper.yylive.utils.ConstantsWrapper;
import com.yy.mobile.util.FileUtil;
import com.yy.mobile.util.NetworkUtils;
import com.yy.mobile.util.log.MLog;
import com.yy.mobile.util.valid.BlankUtil;
import com.yy.videoplayer.videoview.YSpVideoView;
import java.util.HashMap;
import java.util.Map;

public class BaseSmallVideoPlayer
extends YYRelativeLayout
implements IVideoPlayer {
    private static final String TAG = "BaseSmallVideoPlayer";
    private int retryTime = 2;
    public YYVideoView mPlayer;
    private PlayerPlayInfo mPlayerPlayInfo;
    public int mRetryPlayTimes;
    private boolean mPlayStopped;
    private boolean mForceReplay;
    private PlayerCallback mPlayerCallback;
    protected IMediaVideo mIMediaVideo;
    private boolean mIsVideoReleased = true;
    private boolean mIsUserPause = false;
    @State
    public int mPlayStatus;
    private int totalTime;
    private int playedTime;
    private int cacheTime;
    long mUserGroupId;
    long mStreamId;
    private float videoRation;
    boolean isErrorEncountered;
    private ConstantsWrapper.ScaleMode mScaleMode;
    protected YYHandler mYYHandler = new YYHandler(Looper.getMainLooper()){

        public void handleMessage(Message msg) {
            block0 : switch (msg.what) {
                case 1006: {
                    MediaVideoMsg.VodVideoStreamInfo vodVideoStreamInfo = (MediaVideoMsg.VodVideoStreamInfo)msg.obj;
                    long userGroupId = vodVideoStreamInfo.groupId;
                    long streamId = vodVideoStreamInfo.streamId;
                    String vodVideoStreamInfoUrl = vodVideoStreamInfo.url;
                    int status = vodVideoStreamInfo.status;
                    MLog.info((Object)BaseSmallVideoPlayer.TAG, (String)("[vodVideoStreamInfo] vodVideoStreamInfoUrl=" + vodVideoStreamInfoUrl), (Object[])new Object[0]);
                    switch (status) {
                        case 3: {
                            MLog.info((Object)BaseSmallVideoPlayer.TAG, (String)"vodVideoStreamInfo, status = Arrive", (Object[])new Object[0]);
                            BaseSmallVideoPlayer.this.isErrorEncountered = false;
                            BaseSmallVideoPlayer.this.releaseStream();
                            if (BaseSmallVideoPlayer.this.mUserGroupId != userGroupId) {
                                BaseSmallVideoPlayer.this.mUserGroupId = userGroupId;
                            }
                            if (BaseSmallVideoPlayer.this.mStreamId != streamId) {
                                BaseSmallVideoPlayer.this.mStreamId = streamId;
                            }
                            if (BaseSmallVideoPlayer.this.mPlayerCallback == null) break;
                            BaseSmallVideoPlayer.this.mPlayerCallback.onVideoPlayStart();
                            break;
                        }
                        case 2: {
                            MLog.info((Object)BaseSmallVideoPlayer.TAG, (String)"vodVideoStreamInfo, status = Stop", (Object[])new Object[0]);
                            break;
                        }
                        case 1: {
                            MLog.info((Object)BaseSmallVideoPlayer.TAG, (String)"vodVideoStreamInfo, status = Start", (Object[])new Object[0]);
                            if (!BaseSmallVideoPlayer.this.isErrorEncountered || BaseSmallVideoPlayer.this.mPlayerPlayInfo == null || BaseSmallVideoPlayer.this.cachedSeekTime < 0L || BaseSmallVideoPlayer.this.mIMediaVideo == null) break;
                            BaseSmallVideoPlayer.this.mIMediaVideo.vodSeek(((BaseSmallVideoPlayer)BaseSmallVideoPlayer.this).mPlayerPlayInfo.mPlayUrl, BaseSmallVideoPlayer.this.cachedSeekTime);
                        }
                    }
                    break;
                }
                case 1000: {
                    int state;
                    MediaVideoMsg.VodStateChangeInfo vodStateChangeInfo = (MediaVideoMsg.VodStateChangeInfo)msg.obj;
                    MLog.info((Object)BaseSmallVideoPlayer.TAG, (String)"[vodStateChangeInfo] state:%d", (Object[])new Object[]{vodStateChangeInfo.state});
                    BaseSmallVideoPlayer.this.mPlayStatus = state = vodStateChangeInfo.state;
                    switch (state) {
                        case 0: {
                            break block0;
                        }
                        case 1: {
                            if (BaseSmallVideoPlayer.this.mPlayerCallback == null) break block0;
                            BaseSmallVideoPlayer.this.mPlayerCallback.onBuffering();
                            break block0;
                        }
                        case 2: {
                            if (BaseSmallVideoPlayer.this.mPlayer != null) {
                                YSpVideoView videoView = BaseSmallVideoPlayer.this.createViewByType();
                                MLog.info((Object)BaseSmallVideoPlayer.TAG, (String)("[PLAYER_PLAYING] videoView instance is " + videoView.getClass().getName()), (Object[])new Object[0]);
                                videoView.setScaleMode(ConstantsWrapper.convertScaleMode(BaseSmallVideoPlayer.this.mScaleMode));
                                if (BaseSmallVideoPlayer.this.mIMediaVideo != null) {
                                    BaseSmallVideoPlayer.this.mIMediaVideo.addSpVideoView(videoView);
                                }
                                BaseSmallVideoPlayer.this.mPlayer.linkToStream(BaseSmallVideoPlayer.this.mUserGroupId, BaseSmallVideoPlayer.this.mStreamId);
                            } else {
                                MLog.error((Object)BaseSmallVideoPlayer.TAG, (String)"unexcepted result", (Object[])new Object[0]);
                            }
                            if (BaseSmallVideoPlayer.this.mPlayerCallback == null) break block0;
                            BaseSmallVideoPlayer.this.mPlayerCallback.onVideoPlaying();
                            break block0;
                        }
                        case 3: {
                            BaseSmallVideoPlayer.this.releaseStream();
                            if (BaseSmallVideoPlayer.this.mPlayerCallback == null) break block0;
                            BaseSmallVideoPlayer.this.mPlayerCallback.onPlayEnd();
                            break block0;
                        }
                        case 4: {
                            if (BaseSmallVideoPlayer.this.mPlayerCallback == null) break block0;
                            BaseSmallVideoPlayer.this.mPlayerCallback.onVideoPlayPause();
                            break block0;
                        }
                        case 5: {
                            if (BaseSmallVideoPlayer.this.mPlayerCallback == null) break block0;
                            BaseSmallVideoPlayer.this.mPlayerCallback.onVideoPlayStop();
                            break block0;
                        }
                        case 6: {
                            BaseSmallVideoPlayer.this.isErrorEncountered = true;
                            break block0;
                        }
                    }
                    break;
                }
                case 1001: {
                    MediaVideoMsg.VodBufferingChangeInfo vodBufferingChangeInfo = (MediaVideoMsg.VodBufferingChangeInfo)msg.obj;
                    int percent = vodBufferingChangeInfo.percent;
                    MLog.debug((Object)BaseSmallVideoPlayer.TAG, (String)"[vodBufferingChangeInfo] percent:%d", (Object[])new Object[]{percent});
                    if (BaseSmallVideoPlayer.this.mPlayerCallback == null) break;
                    if (percent >= 0 && percent < 100) {
                        BaseSmallVideoPlayer.this.mPlayerCallback.onVideoLoadStart();
                        break;
                    }
                    BaseSmallVideoPlayer.this.mPlayerCallback.onVideoLoadFinished();
                    break;
                }
                case 1002: {
                    MediaVideoMsg.VodTotalTimeInfo vodTotalTimeInfo = (MediaVideoMsg.VodTotalTimeInfo)msg.obj;
                    BaseSmallVideoPlayer.this.totalTime = vodTotalTimeInfo.totalTime;
                    MLog.info((Object)BaseSmallVideoPlayer.TAG, (String)"[vodTotalTimeInfo] totalTime:%d", (Object[])new Object[]{BaseSmallVideoPlayer.this.totalTime});
                    if (BaseSmallVideoPlayer.this.mPlayerCallback == null) break;
                    BaseSmallVideoPlayer.this.mPlayerCallback.onTotalTime(BaseSmallVideoPlayer.this.totalTime);
                    break;
                }
                case 1003: {
                    MediaVideoMsg.VodPlayedTimeInfo vodPlayedTimeInfo = (MediaVideoMsg.VodPlayedTimeInfo)msg.obj;
                    BaseSmallVideoPlayer.this.playedTime = vodPlayedTimeInfo.playedTime;
                    MLog.debug((Object)BaseSmallVideoPlayer.TAG, (String)"[vodPlayedTimeInfo] playedTime:%d", (Object[])new Object[]{BaseSmallVideoPlayer.this.playedTime});
                    if (BaseSmallVideoPlayer.this.mPlayerCallback == null) break;
                    BaseSmallVideoPlayer.this.mPlayerCallback.onProgressUpdate(BaseSmallVideoPlayer.this.totalTime, BaseSmallVideoPlayer.this.playedTime);
                    break;
                }
                case 1004: {
                    MediaVideoMsg.VodCacheTimeInfo vodCacheTimeInfo = (MediaVideoMsg.VodCacheTimeInfo)msg.obj;
                    BaseSmallVideoPlayer.this.cacheTime = vodCacheTimeInfo.cacheTime;
                    MLog.debug((Object)BaseSmallVideoPlayer.TAG, (String)"[vodCacheTimeInfo] cacheTime:%d", (Object[])new Object[]{BaseSmallVideoPlayer.this.cacheTime});
                    if (BaseSmallVideoPlayer.this.mPlayerCallback == null) break;
                    BaseSmallVideoPlayer.this.mPlayerCallback.onCacheUpdate(BaseSmallVideoPlayer.this.cacheTime);
                    break;
                }
                case 1007: {
                    MediaVideoMsg.VodErrorInfo vodErrorInfo = (MediaVideoMsg.VodErrorInfo)msg.obj;
                    int errorCode = vodErrorInfo.errorCode;
                    int statusCode = vodErrorInfo.statusCode;
                    MLog.info((Object)BaseSmallVideoPlayer.TAG, (String)"[vodErrorInfo] errorCode:%d, statusCode=%d", (Object[])new Object[]{errorCode, statusCode});
                    BaseSmallVideoPlayer.this.handleOnError();
                    if (BaseSmallVideoPlayer.this.mPlayerCallback == null) break;
                    BaseSmallVideoPlayer.this.mPlayerCallback.onError(errorCode);
                    break;
                }
                case 1005: {
                    MediaVideoMsg.VodVideoSizeInfo vodVideoSizeInfo = (MediaVideoMsg.VodVideoSizeInfo)msg.obj;
                    float height = vodVideoSizeInfo.height;
                    float width = vodVideoSizeInfo.width;
                    BaseSmallVideoPlayer.this.videoRation = height / width;
                    MLog.info((Object)BaseSmallVideoPlayer.TAG, (String)"[vodVideoSizeInfo] height:%f, width=%f", (Object[])new Object[]{Float.valueOf(height), Float.valueOf(width)});
                    if (BaseSmallVideoPlayer.this.mPlayerCallback == null) break;
                    BaseSmallVideoPlayer.this.mPlayerCallback.onPlayVideoSize(width, height);
                    break;
                }
                case 138: {
                    MediaVideoMsg.HardwareDecodeErrorInfo hdErrorInfo = (MediaVideoMsg.HardwareDecodeErrorInfo)msg.obj;
                    MLog.info((Object)BaseSmallVideoPlayer.TAG, (String)("[onHardwareDecodeErrorInfo] errorType=" + hdErrorInfo.errorType), (Object[])new Object[0]);
                    if (BaseSmallVideoPlayer.this.getDecodeType() != 1) break;
                    BaseSmallVideoPlayer.this.setDecodeType(0);
                    MLog.info((Object)BaseSmallVideoPlayer.TAG, (String)"[onHardwareDecodeErrorInfo] switch DecodeType to SoftType", (Object[])new Object[0]);
                    long currentTime = BaseSmallVideoPlayer.this.getTime();
                    if (BaseSmallVideoPlayer.this.mIMediaVideo == null) break;
                    BaseSmallVideoPlayer.this.mIMediaVideo.vodSeek(((BaseSmallVideoPlayer)BaseSmallVideoPlayer.this).mPlayerPlayInfo.mPlayUrl, currentTime);
                    break;
                }
            }
        }
    };
    long cachedSeekTime = -1L;
    @ViewType
    private int mViewType = 0;
    @DecodeType
    private int mDecodeType = 1;

    public boolean isUserPause() {
        return this.mIsUserPause;
    }

    public BaseSmallVideoPlayer(Context context) {
        this(context, null);
    }

    public BaseSmallVideoPlayer(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public BaseSmallVideoPlayer(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.onCreate();
    }

    private void onCreate() {
        this.initView();
        this.initData();
        this.initListener();
    }

    private void initView() {
        this.setBackgroundColor(-16777216);
        LayoutInflater.from((Context)this.getContext()).inflate(R.layout.base_small_video_view, (ViewGroup)this);
        this.mPlayer = (YYVideoView)this.findViewById(R.id.yy_video_view);
        this.mPlayer.setKeepScreenOn(true);
        this.mScaleMode = ConstantsWrapper.ScaleMode.AspectFit;
        this.mPlayer.setScaleMode(this.mScaleMode);
    }

    protected void initData() {
        this.mIMediaVideo = IMediaVideoSDK.instance().getMedia();
        this.mPlayerPlayInfo = new PlayerPlayInfo();
        this.mIsVideoReleased = false;
        this.mIMediaVideo.addMsgHandler((Handler)this.mYYHandler);
        this.mIMediaVideo.vodMuteLiveAudio(true);
    }

    private void initListener() {
    }

    @Override
    public ConstantsWrapper.ScaleMode getScaleMode() {
        return this.mScaleMode;
    }

    @Override
    public void setScaleMode(ConstantsWrapper.ScaleMode scaleMode) {
        this.mScaleMode = scaleMode;
    }

    public int getRetryTime() {
        return this.retryTime;
    }

    public void setRetryTime(int retryTime) {
        this.retryTime = retryTime;
    }

    public long getTime() {
        return this.playedTime;
    }

    public void setPlayerCallback(PlayerCallback callback) {
        this.mPlayerCallback = callback;
    }

    @Override
    public IVideoPlayer play(String url) {
        this.mPlayerPlayInfo.mPlayUrl = url;
        this.playUrl(url);
        return this;
    }

    @Override
    public IVideoPlayer play(PlayerPlayInfo playInfo) {
        if (playInfo == null) {
            MLog.info((Object)TAG, (String)"playInfo == null", (Object[])new Object[0]);
            if (this.mPlayerCallback != null) {
                this.mPlayerCallback.onError(256);
            }
        } else {
            this.mPlayerPlayInfo.mResId = playInfo.mResId;
            this.mPlayerPlayInfo.mOwnerId = playInfo.mOwnerId;
            this.mPlayerPlayInfo.mPlayFrom = playInfo.mPlayFrom;
            this.mPlayerPlayInfo.mAlgorithmType = playInfo.mAlgorithmType;
            this.mPlayerPlayInfo.squareVideoViewType = playInfo.squareVideoViewType;
            this.innerPlay(playInfo);
            MLog.info((Object)TAG, (String)"play playInfo:%s mPlayerPlayInfo: %s", (Object[])new Object[]{playInfo, this.mPlayerPlayInfo});
        }
        return this;
    }

    protected void playUrl(String url) {
        this.setMediaConfig(361, this.getDecodeType());
        MLog.info((Object)TAG, (String)"[playUrl] url:%s,type:%d", (Object[])new Object[]{url, this.getDecodeType()});
        if (this.mIMediaVideo != null) {
            this.mIMediaVideo.vodPlay(url);
        }
    }

    protected void releaseStream() {
        if (this.mPlayer != null) {
            this.mPlayer.unLinkFromStream(this.mUserGroupId, this.mStreamId);
            if (this.mIMediaVideo != null) {
                this.mIMediaVideo.removeSpVideoView(this.mPlayer.getExistingView());
            }
            this.mPlayer.removeAllVideoViews();
        }
    }

    @Override
    public IVideoPlayer seekTo(long time) {
        if (this.isErrorEncountered) {
            this.restart();
            if (this.mIMediaVideo != null) {
                this.mIMediaVideo.vodSeek(this.mPlayerPlayInfo.mPlayUrl, time);
            }
            MLog.info((Object)TAG, (String)"[seekTo] isErrorEncountered", (Object[])new Object[0]);
            this.cachedSeekTime = time;
        } else {
            this.cachedSeekTime = -1L;
        }
        MLog.info((Object)TAG, (String)("[seekTo] time=" + time), (Object[])new Object[0]);
        if (this.mPlayerPlayInfo != null && time >= 0L && this.mIMediaVideo != null) {
            this.mIMediaVideo.vodSeek(this.mPlayerPlayInfo.mPlayUrl, time);
        }
        return this;
    }

    @Override
    public long getLength() {
        return this.totalTime;
    }

    @Override
    public long getCurrentPosition() {
        return this.playedTime;
    }

    protected void innerPlay(PlayerPlayInfo playInfo) {
        MLog.info((Object)TAG, (String)"innerPlay playInfo:%s", (Object[])new Object[]{playInfo});
        if (this.mIsVideoReleased) {
            MLog.error((Object)TAG, (String)"try to call innerPlay, but play is released", (Object[])new Object[0]);
            return;
        }
        if (BlankUtil.isBlank((Object)playInfo)) {
            return;
        }
        if (BlankUtil.isBlank((String)playInfo.mPlayUrl)) {
            return;
        }
        if (this.mPlayerPlayInfo.mPlayUrl == null) {
            MLog.info((Object)TAG, (String)"innerPlay first play", (Object[])new Object[0]);
            this.mPlayerPlayInfo.mPlayUrl = playInfo.mPlayUrl;
            this.playUrl(this.mPlayerPlayInfo.mPlayUrl);
            return;
        }
        if (this.mPlayerPlayInfo.mPlayUrl.equals(playInfo.mPlayUrl)) {
            MLog.info((Object)TAG, (String)"innerPlay play the same video mPlayStopped:%b, mForceReplay:%b", (Object[])new Object[]{this.mPlayStopped, this.mForceReplay});
            if (this.mPlayStopped) {
                this.playUrl(this.mPlayerPlayInfo.mPlayUrl);
            } else if (this.mForceReplay) {
                this.stopPlayer();
                this.playUrl(this.mPlayerPlayInfo.mPlayUrl);
            } else {
                this.playLocalVideo();
            }
        } else {
            MLog.info((Object)TAG, (String)"innerPlay stop current video and play new video", (Object[])new Object[0]);
            this.stopPlayer();
            this.mPlayerPlayInfo.mPlayUrl = playInfo.mPlayUrl;
            this.playUrl(this.mPlayerPlayInfo.mPlayUrl);
        }
        this.mForceReplay = false;
    }

    private void playLocalVideo() {
        String playUrl = this.mPlayerPlayInfo.mPlayUrl;
        if (FileUtil.isFileExist((String)playUrl) || playUrl != null && playUrl.startsWith("http")) {
            MLog.info((Object)TAG, (String)"playLocalVideo play time:%d", (Object[])new Object[]{this.playedTime});
            this.playUrl(playUrl);
        } else {
            MLog.info((Object)TAG, (String)"playLocalVideo file not exist", (Object[])new Object[0]);
            if (this.mPlayerCallback != null) {
                this.mPlayerCallback.onError(259);
            }
        }
    }

    @Override
    public IVideoPlayer resumePlayer() {
        MLog.info((Object)TAG, (String)"[resumePlayer]", (Object[])new Object[0]);
        if (this.isErrorEncountered) {
            this.seekTo(this.playedTime);
        }
        if (this.mPlayStatus != 2 && !this.mForceReplay && this.mPlayerPlayInfo != null && !TextUtils.isEmpty((CharSequence)this.mPlayerPlayInfo.mPlayUrl)) {
            MLog.info((Object)TAG, (String)"resumePlayer", (Object[])new Object[0]);
            if (this.mIMediaVideo != null) {
                this.mIMediaVideo.vodPause(this.mPlayerPlayInfo.mPlayUrl, false);
            }
        }
        return this;
    }

    @Override
    public IVideoPlayer pausePlayer() {
        MLog.info((Object)TAG, (String)"[pausePlayer]", (Object[])new Object[0]);
        if (this.mPlayStatus == 2 && this.mIMediaVideo != null) {
            this.mIMediaVideo.vodPause(this.mPlayerPlayInfo.mPlayUrl, true);
        }
        return this;
    }

    @Override
    public IVideoPlayer pausePlayer(boolean isUserPause) {
        this.mIsUserPause = isUserPause;
        return this.pausePlayer();
    }

    @Override
    public IVideoPlayer resumePlayer(boolean isUserPause) {
        this.mIsUserPause = isUserPause;
        return this.resumePlayer();
    }

    public IVideoPlayer resumeOrPause() {
        if (this.isPlaying()) {
            this.pausePlayer();
        } else {
            this.resumePlayer();
        }
        return this;
    }

    @Override
    public IVideoPlayer resumeOrPause(boolean isUserPause) {
        this.mIsUserPause = isUserPause;
        return this.resumeOrPause();
    }

    @Override
    public boolean isPlaying() {
        return !this.mIsVideoReleased && this.mPlayer != null && this.mPlayStatus == 2;
    }

    @Override
    public String getPlayingUrl() {
        return this.mPlayerPlayInfo.mPlayUrl;
    }

    @Override
    public IVideoPlayer restart() {
        this.releasePlayer();
        if (this.mIMediaVideo != null) {
            this.mIMediaVideo.addMsgHandler((Handler)this.mYYHandler);
            this.mIMediaVideo.vodMuteLiveAudio(true);
        }
        this.play(this.mPlayerPlayInfo);
        return this;
    }

    @Override
    public void releasePlayer() {
        MLog.info((Object)TAG, (String)"releasePlayer", (Object[])new Object[0]);
        if (!this.mIsVideoReleased) {
            this.releaseStream();
            if (this.mIMediaVideo != null) {
                this.mIMediaVideo.removeMsgHandler((Handler)this.mYYHandler);
                if (this.mPlayerPlayInfo != null) {
                    this.mIMediaVideo.vodStop(this.mPlayerPlayInfo.mPlayUrl);
                }
            }
            this.mPlayStopped = true;
            if (this.mIMediaVideo != null) {
                this.mIMediaVideo.vodMuteLiveAudio(false);
            }
            this.mIsVideoReleased = true;
            MLog.info((Object)TAG, (String)"[releasePlayer] stopPlayer", (Object[])new Object[0]);
        }
    }

    @Override
    public boolean isPlayerReady() {
        return this.mPlayStatus == 0;
    }

    @Override
    public boolean isPlayerBuffering() {
        return this.mPlayStatus == 1;
    }

    @Override
    public boolean isPlayerPlaying() {
        return this.mPlayStatus == 2;
    }

    @Override
    public boolean isPlayerEnded() {
        return this.mPlayStatus == 3;
    }

    @Override
    public boolean isPlayerPause() {
        return this.mPlayStatus == 4;
    }

    @Override
    public boolean isPlayerStoped() {
        return this.mPlayStatus == 5;
    }

    @Override
    public boolean isPlayerError() {
        return this.mPlayStatus == 6;
    }

    @Override
    public IVideoPlayer stopPlayer() {
        if (this.mIsVideoReleased) {
            MLog.error((Object)TAG, (String)"stopPlayer player is released", (Object[])new Object[0]);
            if (this.mPlayerCallback != null) {
                this.mPlayerCallback.onError(257);
            }
        } else {
            MLog.info((Object)TAG, (String)"stopPlayer", (Object[])new Object[0]);
            this.mPlayStopped = true;
            if (this.mPlayerPlayInfo != null && this.mIMediaVideo != null) {
                this.mIMediaVideo.vodStop(this.mPlayerPlayInfo.mPlayUrl);
            }
        }
        return this;
    }

    @Override
    public void onStop() {
        MLog.info((Object)TAG, (String)"onStop", (Object[])new Object[0]);
    }

    @Override
    public void onDestroy() {
        MLog.info((Object)TAG, (String)"onDestroy", (Object[])new Object[0]);
        this.releasePlayer();
    }

    private void handleOnError() {
        MLog.info((Object)TAG, (String)"handleOnError", (Object[])new Object[0]);
        if (BlankUtil.isBlank((String)this.mPlayerPlayInfo.mPlayUrl) && this.mPlayerCallback != null) {
            MLog.info((Object)TAG, (String)"handleOnError onError callback", (Object[])new Object[0]);
            this.mPlayerCallback.onError(258);
        }
        if (!BlankUtil.isBlank((String)this.mPlayerPlayInfo.mPlayUrl)) {
            this.retryPlay();
        }
    }

    private void retryPlay() {
        MLog.info((Object)TAG, (String)"retryPlay mRetryPlayTimes:%d", (Object[])new Object[]{this.mRetryPlayTimes});
        if (!NetworkUtils.isNetworkStrictlyAvailable((Context)this.getContext())) {
            MLog.info((Object)TAG, (String)"retryPlay isNetworkStrictlyAvailable false", (Object[])new Object[0]);
            this.mRetryPlayTimes = 0;
            return;
        }
        if (this.mRetryPlayTimes < this.getRetryTime()) {
            ++this.mRetryPlayTimes;
            this.innerPlay(this.mPlayerPlayInfo);
        } else {
            this.mRetryPlayTimes = 0;
        }
    }

    @Override
    public IVideoPlayer setPlayerViewType(@ViewType int type2) {
        this.mViewType = type2;
        return this;
    }

    @Override
    public int getPlayerViewType() {
        return this.mViewType;
    }

    private YSpVideoView createViewByType() {
        switch (this.getPlayerViewType()) {
            case 2: {
                return this.mPlayer.clearAndCreateNewViewPreferSurfaceView(this.getDecodeType());
            }
            case 1: {
                return this.mPlayer.clearAndCreateNewViewPreferTextureView(this.getDecodeType());
            }
        }
        return this.mPlayer.clearAndCreateView4Playback(this.getDecodeType());
    }

    private void setMediaConfig(int appId2, Map<Integer, Integer> configs) {
        if (BasicConfig.getInstance().isDebuggable()) {
            String text = "setMediaConfig : appId = " + appId2 + " config is :";
            for (Map.Entry<Integer, Integer> entry : configs.entrySet()) {
                text = text + "(" + entry.getKey() + ", " + entry.getValue() + "),";
            }
            MLog.info((Object)TAG, (String)text, (Object[])new Object[0]);
        }
        if (this.mIMediaVideo != null) {
            this.mIMediaVideo.setConfigs(appId2, configs);
        }
    }

    private void setMediaConfig(int configKey, int configVal) {
        MLog.info((Object)TAG, (String)("setMediaConfig " + configKey + ":" + configVal), (Object[])new Object[0]);
        HashMap<Integer, Integer> configs = new HashMap<Integer, Integer>();
        configs.put(configKey, configVal);
        this.setMediaConfig(0, configs);
    }

    @Override
    public void setDecodeType(@DecodeType int decodeType) {
        this.mDecodeType = decodeType;
    }

    @Override
    public int getDecodeType() {
        return this.mDecodeType;
    }

    @Override
    public void vodMuteLiveAudio(boolean vodMuteLiveAudio) {
        if (this.mIMediaVideo != null) {
            this.mIMediaVideo.vodMuteLiveAudio(vodMuteLiveAudio);
        }
    }

    @Override
    public boolean takeSnapshot(String savedFilePath) {
        Bitmap bitmap;
        if (this.mPlayer != null && (bitmap = this.mPlayer.getVideoScreenshot()) != null) {
            return ReplayUtil.saveBitmapToSdCard(bitmap, savedFilePath);
        }
        return false;
    }

    @Override
    public PlayerPlayInfo getPlayerPlayInfo() {
        return this.mPlayerPlayInfo;
    }
}

