/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.sdkwrapper.login;

import android.content.Context;
import android.os.HandlerThread;
import android.support.annotation.NonNull;
import com.yy.mobile.RxBus;
import com.yy.mobile.YYHandler;
import com.yy.mobile.YYHandlerMgr;
import com.yy.mobile.sdkwrapper.BasicYYHandlerMgr;
import com.yy.mobile.sdkwrapper.login.LoginHandler;
import com.yy.mobile.sdkwrapper.login.LoginProtocol;
import com.yy.mobile.util.StringUtils;
import com.yy.mobile.util.log.MLog;
import com.yy.mobile.yyprotocol.core.Uint32;
import com.yy.udbauth.AuthRequest;
import com.yy.udbauth.AuthSDK;
import com.yyproto.base.IWatcher;
import com.yyproto.base.ProtoReq;
import com.yyproto.db.DCHelper;
import com.yyproto.db.IDatabase;
import com.yyproto.db.IRow;
import com.yyproto.db.ITable;
import com.yyproto.db.ProtoTable;
import com.yyproto.outlet.ILogin;
import com.yyproto.outlet.IProtoMgr;
import com.yyproto.outlet.LoginRequest;
import com.yyproto.outlet.SvcRequest;
import java.util.concurrent.atomic.AtomicBoolean;

enum ProtocolProcessor implements LoginProtocol
{
    INSTANCE;

    private static final String TAG = "LoginProtocolProcessor";
    private final AtomicBoolean mInitialized = new AtomicBoolean(false);
    private ILogin sdkLogin;
    private HandlerThread mThread;
    private boolean isInit = false;
    public String currentReqSeq;
    public String loginReqSeq;
    public String checkAppReqSeq;
    private LoginHandler mHandler;

    @Override
    public void initialize(Context context, RxBus bus, String appId2, String appKey) {
        if (!this.mInitialized.compareAndSet(false, true)) {
            return;
        }
        this.mThread = new HandlerThread(TAG);
        this.mThread.start();
        this.isInit = AuthSDK.init((Context)context, (String)appId2, (String)appKey, (String)"0", (boolean)true, (String)"0");
        if (!this.isInit) {
            MLog.error((Object)TAG, (String)"AuthSDK init failed!", (Object[])new Object[0]);
        }
        this.sdkLogin = IProtoMgr.instance().getLogin();
        this.mHandler = new LoginHandler(this.mThread.getLooper(), bus);
    }

    @Override
    public void initEventHandler() {
        YYHandlerMgr sdkHandlerManager = BasicYYHandlerMgr.getInstance().getSdkHandlerManager();
        if (sdkHandlerManager != null) {
            if (this.sdkLogin == null) {
                this.sdkLogin = IProtoMgr.instance().getLogin();
            }
            this.sdkLogin.watch((IWatcher)sdkHandlerManager);
            IProtoMgr.instance().getReport().watch((IWatcher)sdkHandlerManager);
            if (this.mHandler != null) {
                sdkHandlerManager.add((YYHandler)this.mHandler);
            }
        }
    }

    @Override
    public void insertVerifyAppid(String id) {
        if (!this.isInit) {
            MLog.error((Object)TAG, (String)"insertVerifyAppid but AuthSDK not init!", (Object[])new Object[0]);
            return;
        }
        AuthSDK.insertVerifyAppid((String)id);
    }

    @Override
    public String getPasswdSha1(String password) {
        return new String(this.sdkLogin.getPasswdSha1(password));
    }

    @Override
    public long getAnoymousUid() {
        long uid = -1L;
        try {
            IRow row;
            ITable table;
            IDatabase db2 = DCHelper.openOrCreateDatabase((int)0);
            if (db2 != null && (table = db2.getTable(ProtoTable.TABLE_ID.E_TBL_LOGINUINFO.ordinal())) != null && (row = table.getRow(1)) != null) {
                Uint32 uint32 = new Uint32(row.getInt32(ProtoTable.LOGINUINFO.dwUid.ordinal()));
                uid = uint32.longValue();
            }
        }
        catch (Throwable throwable) {
            MLog.error((Object)TAG, (Throwable)throwable);
        }
        MLog.info((Object)TAG, (String)"getAnoymousUid uid=%d", (Object[])new Object[]{uid});
        return uid;
    }

    @Override
    public void appStatusChange(boolean foreground) {
        LoginRequest.AppStatusReq req = new LoginRequest.AppStatusReq(Boolean.valueOf(foreground));
        if (this.sdkLogin != null) {
            this.sdkLogin.sendRequest((ProtoReq)req);
        }
    }

    @Override
    public boolean verifySmsCode(String mobile, String smsCode) {
        this.currentReqSeq = AuthSDK.generateContext();
        AuthRequest.VerifySmsCodeReq auth = new AuthRequest.VerifySmsCodeReq(mobile, smsCode, this.currentReqSeq);
        return this.sendAuthRequest((AuthRequest.AuthBaseReq)auth) == 0;
    }

    @Override
    public boolean checkMobileRegister(String mobile) {
        this.currentReqSeq = AuthSDK.generateContext();
        AuthRequest.CheckRegisterReq auth = new AuthRequest.CheckRegisterReq(mobile, this.currentReqSeq);
        return this.sendAuthRequest((AuthRequest.AuthBaseReq)auth) == 0;
    }

    @Override
    public int getSmsDown(@NonNull String accountName) {
        this.currentReqSeq = AuthSDK.generateContext();
        AuthRequest.SendSmsReq auth = new AuthRequest.SendSmsReq(accountName, null, 0, null, this.currentReqSeq);
        return this.sendAuthRequest((AuthRequest.AuthBaseReq)auth);
    }

    @Override
    public int checkUpSms(String accountName, String encryptedPassword) {
        this.currentReqSeq = AuthSDK.generateContext();
        AuthRequest.CheckSmsUpReq auth = new AuthRequest.CheckSmsUpReq(accountName, encryptedPassword, this.currentReqSeq);
        auth.timeout = 5L;
        return this.sendAuthRequest((AuthRequest.AuthBaseReq)auth);
    }

    @Override
    public int getServerSendSmsDown(String mobile) {
        this.currentReqSeq = AuthSDK.generateContext();
        AuthRequest.SendSmsReq auth = new AuthRequest.SendSmsReq(mobile, 1, 0, null, this.currentReqSeq);
        return this.sendAuthRequest((AuthRequest.AuthBaseReq)auth);
    }

    @Override
    public int anonymousLogin() {
        LoginRequest.LoginCheckLoginStopped req = new LoginRequest.LoginCheckLoginStopped();
        return this.sdkLogin.sendRequest((ProtoReq)req);
    }

    @Override
    public int login(String accountName, String encryptedPassword, int strategyType, String strategyToken) {
        this.currentReqSeq = AuthSDK.generateContext();
        AuthRequest.LoginReq auth = new AuthRequest.LoginReq(accountName, encryptedPassword, strategyType, strategyToken, this.currentReqSeq);
        return this.sendAuthRequest((AuthRequest.AuthBaseReq)auth);
    }

    @Override
    public int loginByCredit(long userId) {
        this.currentReqSeq = AuthSDK.generateContext();
        AuthRequest.CreditLoginReq auth = new AuthRequest.CreditLoginReq(String.valueOf(userId), 0, null, this.currentReqSeq);
        return this.sendAuthRequest((AuthRequest.AuthBaseReq)auth);
    }

    @Override
    public int loginByThirdParty(String accountName, String thirdPartyToken, String source, String subSource, String appKey) {
        return this.loginByThirdParty(accountName, thirdPartyToken, source, subSource, appKey, null);
    }

    @Override
    public int loginByThirdParty(String accountName, String thirdPartyToken, String source, String subSource, String appKey, String oAuthType) {
        this.currentReqSeq = AuthSDK.generateContext();
        AuthRequest.ThirdPartyLoginReq auth = new AuthRequest.ThirdPartyLoginReq(source, subSource, "Oauth", thirdPartyToken, this.currentReqSeq);
        auth.partnerUid = accountName;
        auth.thirdAppkey = appKey;
        if (!StringUtils.isNullOrEmpty((String)oAuthType)) {
            auth.oauthType = oAuthType;
        }
        return this.sendAuthRequest((AuthRequest.AuthBaseReq)auth);
    }

    @Override
    public int loginByMobileAndSms(String mobile, String smsCode) {
        this.currentReqSeq = AuthSDK.generateContext();
        AuthRequest.SmsRegloginReq auth = new AuthRequest.SmsRegloginReq(mobile, smsCode, this.currentReqSeq);
        return this.sendAuthRequest((AuthRequest.AuthBaseReq)auth);
    }

    @Override
    public int registerAndLogin(String mobile, String smsCode, String password) {
        String encryptedPassword = AuthSDK.getPasswdSha1((String)password);
        this.currentReqSeq = AuthSDK.generateContext();
        AuthRequest.SmsRegloginReq auth = new AuthRequest.SmsRegloginReq(mobile, smsCode, encryptedPassword, this.currentReqSeq);
        return this.sendAuthRequest((AuthRequest.AuthBaseReq)auth);
    }

    @Override
    public int logout() {
        LoginRequest.LoginReqLogout req = new LoginRequest.LoginReqLogout();
        return this.sdkLogin.sendRequest((ProtoReq)req);
    }

    @Override
    public void authLogin(long userId, String mAppId, String mAppSign, String mAppDeviceId) {
        this.loginReqSeq = AuthSDK.generateContext();
        AuthRequest.OpenCreditLoginReq req = new AuthRequest.OpenCreditLoginReq(String.valueOf(userId), AuthSDK.getCredit((String)String.valueOf(userId)), 0, null, mAppId, mAppSign, mAppDeviceId, this.loginReqSeq);
        this.sendAuthRequest((AuthRequest.AuthBaseReq)req);
    }

    @Override
    public void getAuthorizingAppInfoFromNetwork(String uid, String mAppId, String mAppSign, String mAppDeviceId) {
        this.checkAppReqSeq = AuthSDK.generateContext();
        AuthRequest.OpenCheckAppReq req = new AuthRequest.OpenCheckAppReq(mAppId, mAppSign, mAppDeviceId, uid, this.checkAppReqSeq);
        this.sendAuthRequest((AuthRequest.AuthBaseReq)req);
    }

    @Override
    public String getToken(String appId2) {
        if (!this.isInit) {
            MLog.error((Object)TAG, (String)"getToken but AuthSDK not init!", (Object[])new Object[0]);
            return "";
        }
        return AuthSDK.getToken((String)appId2);
    }

    @Override
    public String getToken2(String appid, String productid) {
        if (!this.isInit) {
            MLog.error((Object)TAG, (String)"getToken2 but AuthSDK not init!", (Object[])new Object[0]);
            return "";
        }
        return AuthSDK.getToken2((String)appid, (String)productid);
    }

    @Override
    public String getWebToken() {
        if (!this.isInit) {
            MLog.error((Object)TAG, (String)"getWebToken but AuthSDK not init!", (Object[])new Object[0]);
            return "";
        }
        return AuthSDK.getWebToken();
    }

    @Override
    public String getOTP(String appId2) {
        if (!this.isInit) {
            MLog.error((Object)TAG, (String)"getOTP but AuthSDK not init!", (Object[])new Object[0]);
            return "";
        }
        return AuthSDK.getOTP((String)appId2);
    }

    @Override
    public String getDeviceData() {
        if (!this.isInit) {
            MLog.error((Object)TAG, (String)"getDeviceData but AuthSDK not init!", (Object[])new Object[0]);
            return "";
        }
        return AuthSDK.getDeviceData();
    }

    @Override
    public String getCredit(long uid) {
        if (!this.isInit) {
            MLog.error((Object)TAG, (String)"getDeviceData but AuthSDK not init!", (Object[])new Object[0]);
            return "";
        }
        return AuthSDK.getCredit((String)String.valueOf(uid));
    }

    @Override
    public void clearCredit(long uid) {
        if (!this.isInit) {
            MLog.error((Object)TAG, (String)"getDeviceData but AuthSDK not init!", (Object[])new Object[0]);
            return;
        }
        AuthSDK.clearCredit((String)String.valueOf(uid));
    }

    @Override
    public void transmitDataViaSignalTunel(String dstSrvName, int uri, byte[] payload) {
        LoginRequest.TransmitDataViaSignalTunel req = new LoginRequest.TransmitDataViaSignalTunel(dstSrvName, true, uri, payload);
        this.sdkLogin.sendRequest((ProtoReq)req);
    }

    @Override
    public int refreshPicCode(String accountName) {
        this.currentReqSeq = AuthSDK.generateContext();
        AuthRequest.RefreshPicReq auth = new AuthRequest.RefreshPicReq(accountName, this.currentReqSeq);
        return this.sendAuthRequest((AuthRequest.AuthBaseReq)auth);
    }

    @Override
    public int cancel() {
        AuthRequest.CancelReq cancelReq = new AuthRequest.CancelReq(this.currentReqSeq);
        return this.sendAuthRequest((AuthRequest.AuthBaseReq)cancelReq);
    }

    @Override
    public void sendSvcData(int appId2, byte[] data, long sid, long subSid) {
        SvcRequest.SvcDataReq svcDataReq = new SvcRequest.SvcDataReq(appId2, sid, subSid, data);
        IProtoMgr.instance().getSvc().sendRequest((ProtoReq)svcDataReq);
    }

    private int sendAuthRequest(AuthRequest.AuthBaseReq req) {
        LoginRequest.LoginWithAuthReq login = new LoginRequest.LoginWithAuthReq();
        login.mAuthData = req.marshall();
        return this.sdkLogin.sendRequest((ProtoReq)login);
    }

    @Override
    public String getCurrentReqSeq() {
        return this.currentReqSeq;
    }

    @Override
    public void applyTempChannel(String type2, String team) {
        MLog.info((Object)TAG, (String)("applyTempChannel : type=" + type2 + " ,team=" + team), (Object[])new Object[0]);
        LoginRequest.ApplyTempChannelReq req = new LoginRequest.ApplyTempChannelReq(type2, team);
        this.sdkLogin.sendRequest((ProtoReq)req);
    }

    @Override
    public void destroyTempChannel(long channelId) {
        MLog.info((Object)TAG, (String)("destroyTempChannel : channelId=" + channelId), (Object[])new Object[0]);
        LoginRequest.DestroyTempChannleReq req = new LoginRequest.DestroyTempChannleReq(channelId);
        this.sdkLogin.sendRequest((ProtoReq)req);
    }
}

