/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.sdkwrapper.login;

import android.os.Looper;
import android.support.annotation.NonNull;
import com.yy.mobile.RxBus;
import com.yy.mobile.YYHandler;
import com.yy.mobile.bizmodel.login.LoginResType;
import com.yy.mobile.bizmodel.login.LoginStateType;
import com.yy.mobile.sdkwrapper.login.event.AnonymousLoginEventArgs;
import com.yy.mobile.sdkwrapper.login.event.LoginApplyTempChannelEventArgs;
import com.yy.mobile.sdkwrapper.login.event.LoginDestroyTempChannelEventArgs;
import com.yy.mobile.sdkwrapper.login.event.LoginLinkConnectErrorEventArgs;
import com.yy.mobile.sdkwrapper.login.event.LoginResEventArgs;
import com.yy.mobile.sdkwrapper.login.event.LoginStateEventArgs;
import com.yy.mobile.sdkwrapper.login.event.SelfInfoEventArgs;
import com.yy.mobile.util.Base64Utils;
import com.yy.mobile.util.StringUtils;
import com.yy.mobile.util.log.MLog;
import com.yy.mobile.yyprotocol.core.Uint32;
import com.yy.udbauth.AuthEvent;
import com.yy.udbauth.AuthSDK;
import com.yyproto.base.ProtoEvent;
import com.yyproto.outlet.LoginEvent;

public class LoginHandler
extends YYHandler {
    private static final String TAG = "LoginHandler";
    private final RxBus mBus;

    LoginHandler(@NonNull Looper looper, @NonNull RxBus bus) {
        super(looper);
        this.mBus = bus;
    }

    @YYHandler.MessageHandler(message=110004)
    public void onAuthRes(LoginEvent.LoginResNGEvent res) {
        if (res.uSrvResCode == 200) {
            return;
        }
        if (res.uSrvResCode != 4) {
            LoginResType resType = LoginHandler.getLoginResType(res.uSrvResCode);
            LoginResEventArgs eventArgs = new LoginResEventArgs(resType, res.uSrvResCode);
            this.mBus.post((Object)eventArgs);
            return;
        }
        AuthEvent.AuthBaseEvent base = AuthSDK.toAuthEvent((byte[])res.strAuthData);
        MLog.info((Object)TAG, (String)("onAuthRes: LoginEvent.LoginResNGEvent.uSrvResCode=" + res.uSrvResCode), (Object[])new Object[0]);
        if (base instanceof AuthEvent.AnonymousEvent) {
            MLog.info((Object)TAG, (String)"AnonymousEvent", (Object[])new Object[0]);
            if (((AuthEvent.AnonymousEvent)base).uiAction == 0) {
                AnonymousLoginEventArgs eventArgs = new AnonymousLoginEventArgs(StringUtils.safeParseLong((String)((AuthEvent.AnonymousEvent)base).uid));
                this.mBus.post((Object)eventArgs);
            }
        }
    }

    @YYHandler.MessageHandler(message=30003)
    public void onStatus(int status) {
        LoginStateType state;
        MLog.info((Object)TAG, (String)"SDK Link Status Event:%s", (Object[])new Object[]{this.sdklinkstatustostring(status)});
        switch (status) {
            case 2: {
                state = LoginStateType.Connecting;
                break;
            }
            case 1: 
            case 4: {
                state = LoginStateType.Connecting;
                break;
            }
            case 0: 
            case 6: {
                state = LoginStateType.Disconnect;
                break;
            }
            case 3: 
            case 5: {
                return;
            }
            default: {
                return;
            }
        }
        this.mBus.post((Object)new LoginStateEventArgs(state));
    }

    @YYHandler.MessageHandler(message=10011)
    public void onMyInfo(LoginEvent.ETMyInfo et) {
        SelfInfoEventArgs eventArgs;
        MLog.info((Object)TAG, (String)"receive onMyInfo Event", (Object[])new Object[0]);
        if (et != null && et.uinfo != null) {
            Uint32 uint32 = new Uint32(et.uinfo.getIntVal(1));
            long uid = uint32.longValue();
            String nickName = new String(et.uinfo.getStrVal(100));
            String signature = new String(et.uinfo.getStrVal(101));
            String cookie = Base64Utils.encodeToString((byte[])et.uinfo.getStrVal(103), (int)2);
            String ticket = new String(et.uinfo.getStrVal(105));
            String ip = this.ipIntToIpStr(et.uinfo.getIntVal(6));
            String port = String.valueOf(et.uinfo.getIntVal(7));
            String passport = new String(et.uinfo.getStrVal(104));
            String password = new String(et.uinfo.getStrVal(108));
            eventArgs = new SelfInfoEventArgs(uid, nickName, signature, cookie, ticket, ip, port, passport, password);
        } else {
            eventArgs = new SelfInfoEventArgs();
        }
        this.mBus.post((Object)eventArgs);
    }

    @YYHandler.MessageHandler(message=10021)
    public void onLoginLinkConnectError(ProtoEvent event) {
        MLog.info((Object)TAG, (String)"onLoginLinkConnectError", (Object[])new Object[0]);
        this.mBus.post((Object)new LoginLinkConnectErrorEventArgs());
    }

    private String ipIntToIpStr(long ip) {
        return (ip & 0xFFL) + "." + (ip >> 8 & 0xFFL) + "." + (ip >> 16 & 0xFFL) + "." + (ip >> 24 & 0xFFL);
    }

    private String sdklinkstatustostring(int status) {
        String s;
        switch (status) {
            case 0: {
                s = "DISCONNECTED";
                break;
            }
            case 1: {
                s = "CONNECTING";
                break;
            }
            case 2: {
                s = "CONNECTED";
                break;
            }
            case 3: {
                s = "LOGIND";
                break;
            }
            case 4: {
                s = "RECONNECTING";
                break;
            }
            case 5: {
                s = "RELOGIND";
                break;
            }
            case 6: {
                s = "ERR";
                break;
            }
            default: {
                s = "UNKNOW";
            }
        }
        return s;
    }

    @YYHandler.MessageHandler(message=110017)
    public void onApplyTempChannelRes(LoginEvent.ETLoginApplyTempChannel et) {
        LoginApplyTempChannelEventArgs eventArgs;
        MLog.info((Object)TAG, (String)"receive onApplyTempChannelRes Event", (Object[])new Object[0]);
        if (et != null) {
            eventArgs = new LoginApplyTempChannelEventArgs(et.mGame, et.mChannelId, et.mRefreshInterval, et.mErrorCode, et.version);
            MLog.info((Object)TAG, (String)("onApplyTempChannelRes : eventArgs=" + eventArgs), (Object[])new Object[0]);
        } else {
            eventArgs = new LoginApplyTempChannelEventArgs();
            MLog.info((Object)TAG, (String)("onApplyTempChannelRes et == null, eventArgs=" + eventArgs), (Object[])new Object[0]);
        }
        this.mBus.post((Object)eventArgs);
    }

    @YYHandler.MessageHandler(message=110018)
    public void onDestroyTempChannelRes(LoginEvent.ETLoginDestroyTempChannel et) {
        LoginDestroyTempChannelEventArgs eventArgs;
        MLog.info((Object)TAG, (String)"receive ETLoginDestroyTempChannel Event", (Object[])new Object[0]);
        if (et != null) {
            eventArgs = new LoginDestroyTempChannelEventArgs(et.mErrorCode);
            MLog.info((Object)TAG, (String)("onDestroyTempChannelRes : eventArgs=" + eventArgs), (Object[])new Object[0]);
        } else {
            eventArgs = new LoginDestroyTempChannelEventArgs();
            MLog.info((Object)TAG, (String)("onDestroyTempChannelRes et == null, eventArgs=" + eventArgs), (Object[])new Object[0]);
        }
        this.mBus.post((Object)eventArgs);
    }

    private static LoginResType getLoginResType(int value) {
        LoginResType type2;
        switch (value) {
            case 0: {
                type2 = LoginResType.NetBroken;
                break;
            }
            case 1: {
                type2 = LoginResType.Apkickoff;
                break;
            }
            case 2: {
                type2 = LoginResType.Timeout;
                break;
            }
            case 4: {
                type2 = LoginResType.ResAuth;
                break;
            }
            case 200: {
                type2 = LoginResType.LoginSuccess;
                break;
            }
            default: {
                type2 = LoginResType.NetBroken;
            }
        }
        return type2;
    }
}

