/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.sdkwrapper.flowmanagement.internal.yylivekit;

import android.content.Context;
import com.unionyy.mobile.spdt.Spdt;
import com.yy.IMediaVideoSDK;
import com.yy.mobile.RxBus;
import com.yy.mobile.config.BasicConfig;
import com.yy.mobile.sdkwrapper.flowmanagement.api.YLKEngineAppIdsApi;
import com.yy.mobile.sdkwrapper.flowmanagement.internal.audience.AudienceManagerInternal;
import com.yy.mobile.sdkwrapper.flowmanagement.internal.audio.AudioManagerImpl;
import com.yy.mobile.sdkwrapper.yylive.media.event.UninstallSdkEventArgs;
import com.yy.mobile.uniondif.LiveKitAppidManager;
import com.yy.mobile.util.log.MLog;
import com.yy.yylivekit.YLKEngine;
import com.yy.yylivekit.YLKLive;

public class YYLiveKitInitializer {
    private static final String TAG = "YYLiveKitInitializer";

    public static void init(String libPath) {
        boolean initSuccess;
        Context context = BasicConfig.getInstance().getSPContextWrapper();
        int appId2 = LiveKitAppidManager.INSTANCE.getLiveKitAppid();
        int sceneId = LiveKitAppidManager.INSTANCE.getLiveKitSceneid();
        String bizName = LiveKitAppidManager.INSTANCE.getLiveKitBizname();
        String sdkLogDirPath = BasicConfig.getInstance().getSDKLogDirPath();
        int result = ((YLKEngineAppIdsApi)Spdt.of(YLKEngineAppIdsApi.class)).init(context, "yymobile", bizName, appId2, sceneId, libPath, sdkLogDirPath);
        boolean bl = initSuccess = result == 0;
        if (initSuccess) {
            MLog.info((Object)TAG, (String)"initYYLiveKit, appId: %d, bizName: %s, sceneId: %d, libPath:%s, logPath:%s", (Object[])new Object[]{appId2, bizName, sceneId, libPath, sdkLogDirPath});
        } else {
            MLog.error((Object)TAG, (String)"initYYLiveKit failed, appId: %d, bizName: %s, sceneId: %d", (Object[])new Object[]{appId2, bizName, sceneId});
        }
        YYLiveKitInitializer.initDeInitEventHandler();
        AudienceManagerInternal.getInstance().init();
    }

    private static void initDeInitEventHandler() {
        MLog.info((Object)TAG, (String)"initDeInitEventHandler() called", (Object[])new Object[0]);
        YLKEngine.setDeInitEventHandler((YLKEngine.DeInitEventHandler)new YLKEngine.DeInitEventHandler(){

            public void onDeInit() {
                MLog.info((Object)YYLiveKitInitializer.TAG, (String)"YLKEngine.DeInitEventHandler.onDeInit()", (Object[])new Object[0]);
                RxBus.getDefault().post((Object)new UninstallSdkEventArgs());
                YLKLive.instance().leave();
                YLKEngine.deInitMediaTrans();
            }
        });
    }

    public static void reInstallTransMediaSdk(long uid, long topSid, long subId) {
        MLog.info((Object)TAG, (String)("reInstallTransMediaSdk() called with: uid = [" + uid + "], topSid = [" + topSid + "], subId = [" + subId + "]"), (Object[])new Object[0]);
        YLKEngine.reInitMediaTrans();
        if (topSid != 0L && subId != 0L) {
            YLKLive.instance().join(uid, topSid, subId);
        }
        AudioManagerImpl.getInstance().onTransSdkReInstall();
    }

    public static void appBackgroundChange(boolean toBackground) {
        if (toBackground) {
            YLKEngine.enterBackground();
            IMediaVideoSDK.instance().getMedia().enableAudioFocus(true);
            MLog.info((Object)TAG, (String)"appBackgroundChange: toBackground, enableFocus = true", (Object[])new Object[0]);
        } else {
            YLKEngine.enterForeground();
            IMediaVideoSDK.instance().getMedia().enableAudioFocus(false);
            MLog.info((Object)TAG, (String)"appBackgroundChange: toBackground, enableFocus = false", (Object[])new Object[0]);
        }
    }
}

