/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.sdkwrapper.flowmanagement.internal.videolayout.videosize;

import com.yy.mobile.sdkwrapper.flowmanagement.api.audience.streamcompat.VideoStreamCompat;
import com.yy.mobile.sdkwrapper.flowmanagement.base.entity.VideoSizeInfo;
import com.yy.mobile.util.log.MLog;
import com.yy.yylivekit.model.LiveInfo;
import com.yyproto.utils.FP;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public class VideoSizeDataHolder {
    private static final String TAG = "VideoSizeDataHolder";
    private Map<Long, VideoSizeInfo> mUidSizeInfoMap = new LinkedHashMap<Long, VideoSizeInfo>();

    public void onDecodeSizeChange(LiveInfo liveInfo, VideoSizeInfo sizeInfo) {
        long uid;
        if (liveInfo.isMix) {
            this.clearStreamVideoSize();
            uid = VideoStreamCompat.getInstance().getFirstVideoStreamUid();
        } else {
            uid = liveInfo.uid;
        }
        this.updateMap(uid, sizeInfo);
    }

    public void onStreamArrive(long uid, VideoSizeInfo sizeInfo) {
        this.updateMap(uid, sizeInfo);
    }

    public void remove(long uid) {
        this.mUidSizeInfoMap.remove(uid);
        MLog.info((Object)TAG, (String)("after remove called with: uid = [" + uid + "], map: %s"), (Object[])new Object[]{this.mUidSizeInfoMap});
    }

    public Map<Long, VideoSizeInfo> getUidSizeInfoMap() {
        return this.mUidSizeInfoMap;
    }

    public void clear() {
        MLog.info((Object)TAG, (String)"clear called", (Object[])new Object[0]);
        this.mUidSizeInfoMap.clear();
    }

    private void updateMap(long uid, VideoSizeInfo sizeInfo) {
        MLog.info((Object)TAG, (String)("updateMap called with: uid = [" + uid + "], sizeInfo = [" + sizeInfo + "]"), (Object[])new Object[0]);
        this.mUidSizeInfoMap.put(uid, sizeInfo);
    }

    private void clearStreamVideoSize() {
        if (FP.empty(this.mUidSizeInfoMap)) {
            return;
        }
        MLog.info((Object)TAG, (String)"clearStreamVideoSize called, before map: %s", (Object[])new Object[]{this.mUidSizeInfoMap});
        Iterator<VideoSizeInfo> it = this.mUidSizeInfoMap.values().iterator();
        while (it.hasNext()) {
            VideoSizeInfo sizeInfo = it.next();
            if (sizeInfo.changeFrom != VideoSizeInfo.ChangeFrom.VIDEO_STREAM) continue;
            it.remove();
        }
        MLog.info((Object)TAG, (String)"clearStreamVideoSize called, after map: %s", (Object[])new Object[]{this.mUidSizeInfoMap});
    }

    public static VideoSizeDataHolder getInstance() {
        return Holder.INSTANCE;
    }

    private VideoSizeDataHolder() {
    }

    private static class Holder {
        private static final VideoSizeDataHolder INSTANCE = new VideoSizeDataHolder();

        private Holder() {
        }
    }
}

