/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.sdkwrapper.flowmanagement.internal.videolayout.videosize;

import com.medialib.video.MediaVideoMsg;
import com.yy.mobile.sdkwrapper.flowmanagement.api.audience.streamcompat.VideoStreamCompat;
import com.yy.mobile.sdkwrapper.flowmanagement.base.entity.VideoSizeInfo;
import com.yy.mobile.sdkwrapper.flowmanagement.base.videolayout.videosize.IAudienceVideoSizeChangeEventHandler;
import com.yy.mobile.sdkwrapper.flowmanagement.base.videolayout.videosize.VideoSizeChangeListener;
import com.yy.mobile.sdkwrapper.flowmanagement.event.audience.streamcompat.VideoStreamArriveCompatEvent;
import com.yy.mobile.sdkwrapper.flowmanagement.event.audience.streamcompat.VideoStreamStopCompatEvent;
import com.yy.mobile.sdkwrapper.flowmanagement.event.audience.videosize.VideoDecodeSizeChangeEvent;
import com.yy.mobile.sdkwrapper.flowmanagement.event.rxbus.FlowRxBus;
import com.yy.mobile.sdkwrapper.flowmanagement.internal.videolayout.videosize.VideoSizeDataHolder;
import com.yy.mobile.util.log.MLog;
import com.yy.yylivekit.ILivePlayer;
import com.yy.yylivekit.model.LiveInfo;
import java.util.ArrayList;
import java.util.List;

public class AudienceVideoSizeChangeEventHandlerImpl
implements IAudienceVideoSizeChangeEventHandler {
    private static final String TAG = "AudienceVideoSizeChangeEventHandlerImpl";
    private List<VideoSizeChangeListener> mListeners = new ArrayList<VideoSizeChangeListener>();
    private VideoSizeDataHolder mVideoSizeDataHolder = VideoSizeDataHolder.getInstance();

    @Override
    public void addListener(VideoSizeChangeListener listener) {
        MLog.info((Object)TAG, (String)("addListener called with: listener = [" + listener + "]"), (Object[])new Object[0]);
        this.mListeners.add(listener);
        for (VideoSizeInfo sizeInfo : this.mVideoSizeDataHolder.getUidSizeInfoMap().values()) {
            MLog.info((Object)TAG, (String)"notify video size change on addListener, listener: %s, sizeInfo\uff1a%s", (Object[])new Object[]{listener, sizeInfo});
            listener.onVideoSizeChanged(sizeInfo);
        }
    }

    @Override
    public void removeListener(VideoSizeChangeListener listener) {
        this.mListeners.remove(listener);
    }

    public void init() {
        MLog.info((Object)TAG, (String)"init called", (Object[])new Object[0]);
        this.mVideoSizeDataHolder.clear();
    }

    public void onVideoDecodeSizeChanged(ILivePlayer player, LiveInfo liveInfo, MediaVideoMsg.VideoSizeInfo info) {
        VideoSizeInfo videoSizeInfo = new VideoSizeInfo(liveInfo.uid, info.width, info.height, liveInfo.isMix, VideoSizeInfo.ChangeFrom.VIDEO_DECODE);
        videoSizeInfo.videoCount = VideoStreamCompat.getInstance().getVideoStreamListSize();
        videoSizeInfo.micNo = liveInfo.isMix ? -1 : liveInfo.micNo;
        MLog.info((Object)TAG, (String)"onVideoDecodeSizeChanged: %s", (Object[])new Object[]{videoSizeInfo});
        this.notifyVideoSizeChange(videoSizeInfo);
        this.mVideoSizeDataHolder.onDecodeSizeChange(liveInfo, videoSizeInfo);
    }

    private void notifyVideoSizeChange(VideoSizeInfo videoSizeInfo) {
        MLog.info((Object)TAG, (String)("notifyVideoSizeChange called with: videoSizeInfo = [" + videoSizeInfo + "]"), (Object[])new Object[0]);
        FlowRxBus.getInstance().post((Object)new VideoDecodeSizeChangeEvent(videoSizeInfo));
        for (VideoSizeChangeListener listener : this.mListeners) {
            listener.onVideoSizeChanged(videoSizeInfo);
        }
    }

    public void onVideoStreamArrive(VideoStreamArriveCompatEvent event) {
        MLog.info((Object)TAG, (String)("onVideoStreamArrive called with: event = [" + event + "]"), (Object[])new Object[0]);
        VideoSizeInfo videoSizeInfo = new VideoSizeInfo(event.getUid(), event.getVideoWidth(), event.getVideoHeight(), event.isMixture(), VideoSizeInfo.ChangeFrom.VIDEO_STREAM);
        videoSizeInfo.micNo = event.getMicNo();
        videoSizeInfo.videoCount = VideoStreamCompat.getInstance().getVideoStreamListSize();
        this.notifyVideoSizeChange(videoSizeInfo);
        this.mVideoSizeDataHolder.onStreamArrive(event.getUid(), videoSizeInfo);
    }

    public void onVideoStreamStop(VideoStreamStopCompatEvent event) {
        MLog.info((Object)TAG, (String)("onVideoStreamStop called with: event = [" + event + "]"), (Object[])new Object[0]);
        this.mVideoSizeDataHolder.remove(event.getUid());
    }

    public static AudienceVideoSizeChangeEventHandlerImpl getInstance() {
        return Holder.INSTANCE;
    }

    private AudienceVideoSizeChangeEventHandlerImpl() {
    }

    private static class Holder {
        private static final AudienceVideoSizeChangeEventHandlerImpl INSTANCE = new AudienceVideoSizeChangeEventHandlerImpl();

        private Holder() {
        }
    }
}

