/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.sdkwrapper.flowmanagement.internal.videoinfo;

import android.text.TextUtils;
import com.medialib.video.MediaVideoMsg;
import com.yy.mobile.sdkwrapper.flowmanagement.api.audience.playstatus.VideoPlayStatusEventHandler;
import com.yy.mobile.sdkwrapper.flowmanagement.base.audience.playstatus.VideoPlayStatus;
import com.yy.mobile.sdkwrapper.flowmanagement.base.audience.playstatus.VideoPlayStatusListener;
import com.yy.mobile.sdkwrapper.flowmanagement.base.entity.VideoDebugInfo;
import com.yy.mobile.sdkwrapper.flowmanagement.base.entity.VideoPlayInfo;
import com.yy.mobile.sdkwrapper.flowmanagement.base.videoinfo.IVideoDebugInfoManager;
import com.yy.mobile.sdkwrapper.flowmanagement.base.videoinfo.VideoDebugInfoListener;
import com.yy.mobile.sdkwrapper.flowmanagement.internal.audience.AudienceManagerInternal;
import com.yy.mobile.sdkwrapper.flowmanagement.internal.videoinfo.MultiVideoInfo;
import com.yy.mobile.sdkwrapper.yylive.media.MediaVideoMsgWrapper;
import com.yy.mobile.util.log.MLog;
import com.yy.yylivekit.ILivePlayer;
import com.yy.yylivekit.audience.Audience;
import com.yy.yylivekit.model.LiveInfo;
import com.yy.yylivekit.model.LiveKitMsg;
import com.yy.yylivekit.model.StreamInfo;
import com.yyproto.utils.FP;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class VideoDebugInfoManagerImpl
implements IVideoDebugInfoManager,
VideoPlayStatusListener {
    private static final String TAG = "VideoDebugInfoManagerImpl";
    private List<VideoDebugInfoListener> mListeners = new ArrayList<VideoDebugInfoListener>();
    private VideoDebugInfo mVideoDebugInfo = new VideoDebugInfo();
    private Map<LiveInfo, MultiVideoInfo> mMultiVideoInfoMap = new TreeMap<LiveInfo, MultiVideoInfo>(new Comparator<LiveInfo>(){

        @Override
        public int compare(LiveInfo o1, LiveInfo o2) {
            if (o1.getBuzInfo().seat == o2.getBuzInfo().seat) {
                return (int)(o1.uid - o2.uid);
            }
            return o1.getBuzInfo().seat - o2.getBuzInfo().seat;
        }
    });
    private boolean mHasGetCodeRateConfig = false;
    private Map<Long, VideoPlayStatus> mUidPlayStatusMap = new HashMap<Long, VideoPlayStatus>();

    public void reset() {
        MLog.info((Object)TAG, (String)"reset called", (Object[])new Object[0]);
        this.mVideoDebugInfo = new VideoDebugInfo();
        this.mMultiVideoInfoMap.clear();
        this.mUidPlayStatusMap.clear();
        this.notifyVideoDebugInfoChange();
        this.mHasGetCodeRateConfig = false;
    }

    @Override
    public void addVideoDebugInfoUpdateListener(VideoDebugInfoListener listener) {
        this.mListeners.add(listener);
    }

    @Override
    public void removeVideoDebugInfoUpdateListener(VideoDebugInfoListener listener) {
        this.mListeners.remove(listener);
    }

    public void onVideoPlaying(ILivePlayer player, LiveInfo liveInfo, StreamInfo streamInfo) {
        if (streamInfo.video == null) {
            return;
        }
        this.mVideoDebugInfo.encodeType = streamInfo.video.encode == 101 ? "H265" : "H264";
        this.mVideoDebugInfo.videoStreamList.add(streamInfo.video.streamName);
        this.notifyVideoDebugInfoChange();
    }

    public void onPlayStreamInfoChanged(LiveInfo liveInfo, StreamInfo streamInfo) {
        this.addMultiVideoInfo(liveInfo, streamInfo);
    }

    public void onVideoStop(ILivePlayer player, LiveInfo liveInfo, StreamInfo streamInfo) {
        this.removeMultiVideoInfo(liveInfo, streamInfo);
        if (streamInfo.video != null) {
            this.mVideoDebugInfo.videoStreamList.remove(streamInfo.video.streamName);
            this.notifyVideoDebugInfoChange();
        }
    }

    public void onVideoViewerStatNotify(ILivePlayer player, MediaVideoMsg.VideoViewerStatInfo statInfo) {
        StringBuilder encodeBitRate = new StringBuilder();
        StringBuilder decodeBitRate = new StringBuilder();
        StringBuilder decodeFrameRate = new StringBuilder();
        Set entries = statInfo.streamMap.entrySet();
        for (Map.Entry entry : entries) {
            MediaVideoMsg.StreamStatInfo streamStatInfo = (MediaVideoMsg.StreamStatInfo)entry.getValue();
            if (streamStatInfo == null) continue;
            encodeBitRate.append(streamStatInfo.dataMap.get(MediaVideoMsg.ViewerStreamKey.MST_RECV_BIT_RATE)).append(",");
            decodeBitRate.append(streamStatInfo.dataMap.get(MediaVideoMsg.ViewerStreamKey.MST_VIDEO_DECODE_BITRATE)).append(",");
            decodeFrameRate.append(streamStatInfo.dataMap.get(MediaVideoMsg.ViewerStreamKey.MST_VIDEO_DECODE_FRAMERATE)).append(",");
        }
        this.mVideoDebugInfo.rttInMs = statInfo.statMap.get(MediaVideoMsgWrapper.VideoViewerStatKeyWrapper.MST_VIEWER_LINK_RTT) + "";
        this.mVideoDebugInfo.encodeBitRate = encodeBitRate.toString();
        this.mVideoDebugInfo.decodeFrameRate = decodeFrameRate.toString();
        this.mVideoDebugInfo.decodeBitRate = decodeBitRate.toString();
        this.notifyVideoDebugInfoChange();
    }

    public void onVideoDecoderNotify(ILivePlayer player, LiveInfo liveInfo, MediaVideoMsg.VideoDecoderInfo info) {
        String typeStr;
        String codecStr;
        this.tryToUpdateCodeRateRange();
        switch (info.codecId) {
            case 2000: {
                codecStr = "H264";
                break;
            }
            case 2001: {
                codecStr = "NET_VIDEO_VP8";
                break;
            }
            case 2002: {
                codecStr = "H265";
                break;
            }
            default: {
                codecStr = "UNKNOWN_CODEC";
            }
        }
        switch (info.type) {
            case 0: {
                typeStr = "SOFT";
                break;
            }
            case 1: {
                typeStr = "HARD";
                break;
            }
            case 2: {
                typeStr = "HARD";
                break;
            }
            case 5: {
                typeStr = "SOFT";
                break;
            }
            case 6: {
                typeStr = "DT_REFACTOR_IOS_HARD_DECODER";
                break;
            }
            default: {
                typeStr = "UNKNOWN_DECODER";
            }
        }
        this.mVideoDebugInfo.decodeType = codecStr + " # " + typeStr;
        this.notifyVideoDebugInfoChange();
    }

    private void tryToUpdateCodeRateRange() {
        if (!this.mHasGetCodeRateConfig) {
            Audience audience = AudienceManagerInternal.getInstance().getAudience();
            String range264 = "h264: ";
            String range265 = "h265: ";
            this.mVideoDebugInfo.audienceCodeRateRange = range264 + ", " + range265;
            this.mHasGetCodeRateConfig = true;
        }
    }

    public void onVideoSizeChanged(ILivePlayer player, LiveInfo liveInfo, MediaVideoMsg.VideoSizeInfo info) {
        this.mVideoDebugInfo.decodeVideoResolution = info.width + "X" + info.height;
        this.notifyVideoDebugInfoChange();
    }

    public void onVideoCodeRateListChange(ILivePlayer player, LiveInfo liveInfo, LiveKitMsg.VideoCodeRateInfo codeRateInfo) {
        ArrayList codeRateList = codeRateInfo.codeRateList == null ? new ArrayList() : new ArrayList(codeRateInfo.codeRateList.values());
        Collections.sort(codeRateList);
        this.mVideoDebugInfo.bitRateList = "[" + TextUtils.join((CharSequence)",", codeRateList) + "]";
        this.notifyVideoDebugInfoChange();
    }

    public void onVideoSelectedCodeRateChange(ILivePlayer player, LiveInfo liveInfo, LiveKitMsg.VideoCodeRateChange codeRateInfo) {
        this.mVideoDebugInfo.selectedBitRate = codeRateInfo.quality + ":" + codeRateInfo.codeRate;
        this.notifyVideoDebugInfoChange();
    }

    private void notifyVideoDebugInfoChange() {
        if (this.shouldIgnore()) {
            return;
        }
        List<VideoDebugInfo> list = Collections.singletonList(this.mVideoDebugInfo);
        for (VideoDebugInfoListener listener : this.mListeners) {
            listener.onVideoDebugInfoUpdate(list);
        }
    }

    private void addMultiVideoInfo(LiveInfo liveInfo, StreamInfo streamInfo) {
        if (streamInfo.video == null) {
            this.mMultiVideoInfoMap.remove(liveInfo);
        } else {
            this.mMultiVideoInfoMap.put(liveInfo, new MultiVideoInfo(liveInfo, streamInfo));
        }
        this.notifyMultiVideoInfoChange(liveInfo);
    }

    private void removeMultiVideoInfo(LiveInfo liveInfo, StreamInfo streamInfo) {
        this.mMultiVideoInfoMap.remove(liveInfo);
        this.notifyMultiVideoInfoChange(liveInfo);
    }

    private void notifyMultiVideoInfoChange(LiveInfo liveInfo) {
        if (liveInfo.isMix) {
            this.mVideoDebugInfo.multiVideoInfo = "\u6df7\u753b";
        } else {
            StringBuilder value = new StringBuilder();
            for (MultiVideoInfo videoInfo : this.mMultiVideoInfoMap.values()) {
                value.append("\n").append(videoInfo.getDebugInfo());
            }
            this.mVideoDebugInfo.multiVideoInfo = value.toString();
        }
        this.notifyVideoDebugInfoChange();
    }

    private void notifyVideoPlayStatusChange(VideoPlayInfo playInfo, VideoPlayStatus playStatus) {
        this.mUidPlayStatusMap.put(playInfo.uid, playStatus);
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<Long, VideoPlayStatus> entry : this.mUidPlayStatusMap.entrySet()) {
            sb.append("\n").append("uid:").append(entry.getKey()).append(" ").append((Object)entry.getValue());
        }
        this.mVideoDebugInfo.playStatusInfo = sb.toString();
        this.notifyVideoDebugInfoChange();
    }

    private boolean shouldIgnore() {
        return FP.empty(this.mListeners);
    }

    public static VideoDebugInfoManagerImpl getInstance() {
        return Holder.INSTANCE;
    }

    private VideoDebugInfoManagerImpl() {
        VideoPlayStatusEventHandler.getInstance().addVideoPlayStatusListener(this);
    }

    public void onVideoEncodeInfoChange(ILivePlayer player, LiveInfo liveInfo, LiveKitMsg.VideoEncodeInfoChange videoEncodeInfoChange) {
        this.mVideoDebugInfo.encodeVideoResolution = videoEncodeInfoChange.width + "X" + videoEncodeInfoChange.height;
        this.notifyVideoDebugInfoChange();
    }

    @Override
    public void onPlayStatusChanged(VideoPlayInfo playInfo, VideoPlayStatus videoPlayStatus) {
        this.notifyVideoPlayStatusChange(playInfo, videoPlayStatus);
    }

    private static class Holder {
        private static final VideoDebugInfoManagerImpl INSTANCE = new VideoDebugInfoManagerImpl();

        private Holder() {
        }
    }
}

