/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.sdkwrapper.flowmanagement.internal.streamcompat;

import android.support.annotation.Nullable;
import com.yy.mobile.RxBus;
import com.yy.mobile.sdkwrapper.flowmanagement.api.audience.liveinfo.LiveInfoChangeEventHandler;
import com.yy.mobile.sdkwrapper.flowmanagement.base.audience.liveinfo.LiveInfoChangeListener;
import com.yy.mobile.sdkwrapper.flowmanagement.base.audience.streamcompat.IVideoStreamCompat;
import com.yy.mobile.sdkwrapper.flowmanagement.base.entity.VideoPlayInfo;
import com.yy.mobile.sdkwrapper.flowmanagement.event.audience.streamcompat.VideoStreamListSizeChangeEvent;
import com.yy.mobile.sdkwrapper.flowmanagement.internal.audience.liveinfo.LiveInfoListHolder;
import com.yy.mobile.sdkwrapper.flowmanagement.internal.audience.liveinfo.LiveInfoUtils;
import com.yy.mobile.util.log.MLog;
import com.yy.yylivekit.model.LiveInfo;
import com.yyproto.utils.FP;
import java.util.List;

public class VideoStreamCompatImpl
implements IVideoStreamCompat,
LiveInfoChangeListener {
    private static final String TAG = "VideoStreamCompatImpl";

    public void init() {
        LiveInfoChangeEventHandler.getInstance().addLiveInfoChangeListener(this);
    }

    @Override
    public int getVideoStreamListSize() {
        int size = LiveInfoListHolder.getInstance().getVideoStreamListSize();
        MLog.info((Object)TAG, (String)"getVideoStreamListSize: %d", (Object[])new Object[]{size});
        return size;
    }

    @Override
    public long getFirstVideoStreamUid() {
        long uid = LiveInfoListHolder.getInstance().getUidByMicNo(0);
        MLog.info((Object)TAG, (String)"getFirstVideoStreamUid: %d", (Object[])new Object[]{uid});
        return uid;
    }

    @Override
    public long getSecondVideoStreamUid() {
        long uid = LiveInfoListHolder.getInstance().getUidByMicNo(1);
        MLog.info((Object)TAG, (String)"getSecondVideoStreamUid: %d", (Object[])new Object[]{uid});
        return uid;
    }

    @Override
    public long getUidByMicPos(int micPos) {
        long uid = LiveInfoListHolder.getInstance().getUidByMicNo(micPos);
        MLog.info((Object)TAG, (String)("getUidByMicPos called with: uid: %d: micPos = [" + micPos + "]"), (Object[])new Object[]{uid});
        return uid;
    }

    @Override
    public boolean hasVideoStream(long uid) {
        List<LiveInfo> liveInfoList = LiveInfoListHolder.getInstance().getLiveInfoList();
        List<LiveInfo> resultLiveInfo = LiveInfoUtils.getLiveInfosByUid(liveInfoList, uid, true);
        boolean hasVideoStream = !FP.empty(resultLiveInfo);
        MLog.info((Object)TAG, (String)("hasVideoStream called with: uid = [" + uid + "], hasVideoStream: %b"), (Object[])new Object[]{hasVideoStream});
        return hasVideoStream;
    }

    @Override
    @Nullable
    public VideoPlayInfo getFistMicVideoPlayInfo() {
        List<LiveInfo> liveInfos = LiveInfoListHolder.getInstance().getLiveInfoList();
        List<LiveInfo> resultList = LiveInfoUtils.getLiveInfosByMicNo(liveInfos, 0, true);
        List<VideoPlayInfo> playInfos = LiveInfoUtils.getVideoPlayInfos(resultList);
        VideoPlayInfo playInfo = (VideoPlayInfo)FP.first(playInfos);
        MLog.info((Object)TAG, (String)"getFistMicVideoPlayInfo called, detail info, see source code, playInfo: %s", (Object[])new Object[]{playInfo});
        return playInfo;
    }

    @Override
    public int getVideoAppId() {
        VideoPlayInfo playInfo = (VideoPlayInfo)FP.first(LiveInfoUtils.getVideoPlayInfos(LiveInfoListHolder.getInstance().getLiveInfoList()));
        int videoAppId = playInfo == null ? -1 : playInfo.appId;
        MLog.info((Object)TAG, (String)"getVideoAppId called, appId: %d, playInfo: %s", (Object[])new Object[]{videoAppId, playInfo});
        return videoAppId;
    }

    @Override
    public void onAddLiveInfos(List<LiveInfo> liveInfos) {
        this.notifyVideoStreamListSizeChange();
    }

    @Override
    public void onRemoveLiveInfos(List<LiveInfo> liveInfos) {
        this.notifyVideoStreamListSizeChange();
    }

    @Override
    public void onUpdateLiveInfos(List<LiveInfo> fromLiveInfos, List<LiveInfo> toLiveInfos) {
        this.notifyVideoStreamListSizeChange();
    }

    private void notifyVideoStreamListSizeChange() {
        int streamSize = this.getVideoStreamListSize();
        MLog.info((Object)TAG, (String)"notifyVideoStreamListSizeChange, streamSize: %d", (Object[])new Object[]{streamSize});
        RxBus.getDefault().post((Object)new VideoStreamListSizeChangeEvent(streamSize));
    }

    public static VideoStreamCompatImpl getInstance() {
        return Holder.INSTANCE;
    }

    private VideoStreamCompatImpl() {
    }

    private static class Holder {
        private static final VideoStreamCompatImpl INSTANCE = new VideoStreamCompatImpl();

        private Holder() {
        }
    }
}

