/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.sdkwrapper.flowmanagement.internal.streamcompat;

import com.yy.mobile.sdkwrapper.flowmanagement.api.audience.liveinfo.LiveInfoChangeEventHandler;
import com.yy.mobile.sdkwrapper.flowmanagement.base.audience.liveinfo.LiveInfoChangeListener;
import com.yy.mobile.sdkwrapper.flowmanagement.base.entity.VideoPlayInfo;
import com.yy.mobile.sdkwrapper.flowmanagement.event.audience.streamcompat.VideoStreamArriveCompatEvent;
import com.yy.mobile.sdkwrapper.flowmanagement.event.audience.streamcompat.VideoStreamStopCompatEvent;
import com.yy.mobile.sdkwrapper.flowmanagement.event.rxbus.FlowRxBus;
import com.yy.mobile.sdkwrapper.flowmanagement.internal.audience.liveinfo.LiveInfoListHolder;
import com.yy.mobile.sdkwrapper.flowmanagement.internal.audience.liveinfo.LiveInfoUtils;
import com.yy.mobile.sdkwrapper.flowmanagement.internal.videolayout.videosize.AudienceVideoSizeChangeEventHandlerImpl;
import com.yy.mobile.util.diff.Differences;
import com.yy.mobile.util.diff.Triple;
import com.yy.mobile.util.log.MLog;
import com.yy.yylivekit.model.LiveInfo;
import com.yyproto.utils.FP;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class VideoStreamChangedCompatImpl
implements LiveInfoChangeListener {
    private static final String TAG = "VideoStreamChangedCompatImpl";
    private List<VideoPlayInfo> mCurrentPlayInfos = new ArrayList<VideoPlayInfo>();

    public static VideoStreamChangedCompatImpl getInstance() {
        return Holder.INSTANCE;
    }

    private VideoStreamChangedCompatImpl() {
        LiveInfoChangeEventHandler.getInstance().addLiveInfoChangeListener(this);
    }

    public void init() {
        MLog.info((Object)TAG, (String)"init called", (Object[])new Object[0]);
    }

    public void reset() {
        MLog.info((Object)TAG, (String)"clear called", (Object[])new Object[0]);
        this.mCurrentPlayInfos.clear();
    }

    @Override
    public void onAddLiveInfos(List<LiveInfo> liveInfos) {
        this.checkChange();
    }

    @Override
    public void onRemoveLiveInfos(List<LiveInfo> liveInfos) {
        this.checkChange();
    }

    @Override
    public void onUpdateLiveInfos(List<LiveInfo> fromLiveInfos, List<LiveInfo> toLiveInfos) {
        this.checkChange();
    }

    private void checkChange() {
        boolean hasRemoved;
        List<VideoPlayInfo> newPlayInfos = LiveInfoUtils.getVideoPlayInfos(LiveInfoListHolder.getInstance().getLiveInfoList());
        Triple<List<VideoPlayInfo>, List<VideoPlayInfo>, List<VideoPlayInfo>> result = Differences.eval(this.mCurrentPlayInfos, newPlayInfos);
        boolean hasAdded = !FP.empty((Collection)((Collection)result.c));
        boolean bl = hasRemoved = !FP.empty((Collection)((Collection)result.a));
        if (hasRemoved) {
            this.notifyVideoStreamStop((List)result.a);
        }
        if (hasAdded) {
            this.notifyVideoStreamArrive((List)result.c);
        }
        if (hasRemoved || hasAdded) {
            this.updateCurrentPlayInfo(newPlayInfos);
        }
    }

    private void updateCurrentPlayInfo(List<VideoPlayInfo> newPlayInfos) {
        MLog.info((Object)TAG, (String)("updateCurrentPlayInfo called with: oldPlayInfos: %s, newPlayInfos = [" + newPlayInfos + "]"), (Object[])new Object[]{this.mCurrentPlayInfos});
        this.mCurrentPlayInfos.clear();
        if (!FP.empty(newPlayInfos)) {
            this.mCurrentPlayInfos.addAll(newPlayInfos);
        }
    }

    private void notifyVideoStreamArrive(List<VideoPlayInfo> playInfos) {
        MLog.info((Object)TAG, (String)("notifyVideoStreamArrive called with: playInfos = [" + playInfos + "]"), (Object[])new Object[0]);
        for (VideoPlayInfo info : playInfos) {
            VideoStreamArriveCompatEvent event = new VideoStreamArriveCompatEvent(info.uid, info.micPos, info.width, info.height, info.codeRate, info.frameRate, info.isMixLayout);
            AudienceVideoSizeChangeEventHandlerImpl.getInstance().onVideoStreamArrive(event);
            FlowRxBus.getInstance().post((Object)event);
        }
    }

    private void notifyVideoStreamStop(List<VideoPlayInfo> playInfos) {
        MLog.info((Object)TAG, (String)("notifyVideoStreamStop called with: playInfos = [" + playInfos + "]"), (Object[])new Object[0]);
        for (VideoPlayInfo info : playInfos) {
            VideoStreamStopCompatEvent event = new VideoStreamStopCompatEvent(info.uid);
            AudienceVideoSizeChangeEventHandlerImpl.getInstance().onVideoStreamStop(event);
            FlowRxBus.getInstance().post((Object)event);
        }
    }

    private static class Holder {
        private static final VideoStreamChangedCompatImpl INSTANCE = new VideoStreamChangedCompatImpl();

        private Holder() {
        }
    }
}

