/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.sdkwrapper.flowmanagement.internal.decode;

import com.yy.mobile.sdkwrapper.flowmanagement.internal.decode.IVideoDecodeManager;
import com.yy.mobile.util.log.MLog;
import com.yy.yylivekit.audience.Audience;

public class VideoDecodeMangerImpl
implements IVideoDecodeManager {
    private static final String TAG = "VideoDecodeMangerImpl";

    @Override
    public boolean isSupportHwDecode() {
        boolean isSupportHwDecode = Audience.instance().isSupportH264HwDecode();
        MLog.info((Object)TAG, (String)"isSupportHwDecode called: %b", (Object[])new Object[]{isSupportHwDecode});
        return isSupportHwDecode;
    }

    @Override
    public void enableHwDecode(boolean hwDecode) {
        MLog.info((Object)TAG, (String)("enableHwDecode called with: hwDecode = [" + hwDecode + "]"), (Object[])new Object[0]);
        Audience.instance().enableH264HwDecode(hwDecode);
        Audience.instance().enableH265HwDecode(hwDecode);
    }

    @Override
    public boolean isHwDecodeEnabled() {
        boolean isHwDecodeEnabled = Audience.instance().isH264HwDecodeEnabled();
        MLog.info((Object)TAG, (String)"isHwDecodeEnabled called: %b", (Object[])new Object[]{isHwDecodeEnabled});
        return isHwDecodeEnabled;
    }

    @Override
    public void useHardDecode() {
        MLog.info((Object)TAG, (String)"useHardDecode called", (Object[])new Object[0]);
        this.enableHwDecode(true);
    }

    @Override
    public void useSoftDecode() {
        MLog.info((Object)TAG, (String)"useSoftDecode called", (Object[])new Object[0]);
        this.enableHwDecode(false);
    }

    @Override
    public void useDefaultDecode() {
        boolean supportH264HwDecode = Audience.instance().isSupportH264HwDecode();
        boolean supportH265HwDecode = Audience.instance().isSupportH265HwDecode();
        MLog.info((Object)TAG, (String)"useDefaultDecode called, supportH264HwDecode: %b supportH265HwDecode: %b", (Object[])new Object[]{supportH264HwDecode, supportH265HwDecode});
        Audience.instance().enableH264HwDecode(supportH264HwDecode);
        Audience.instance().enableH265HwDecode(supportH265HwDecode);
    }

    public static IVideoDecodeManager getInstance() {
        return Holder.INSTANCE;
    }

    private VideoDecodeMangerImpl() {
    }

    private static class Holder {
        private static final VideoDecodeMangerImpl INSTANCE = new VideoDecodeMangerImpl();

        private Holder() {
        }
    }
}

