/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.sdkwrapper.flowmanagement.internal.audio;

import com.medialib.video.MediaVideoMsg;
import com.yy.mobile.sdkwrapper.flowmanagement.base.audio.IAudioSpeakerManager;
import com.yy.mobile.util.log.MLog;
import com.yyproto.utils.FP;
import io.reactivex.Observable;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.Consumer;
import io.reactivex.schedulers.Schedulers;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;

public class AudioSpeakersManagerImpl
implements IAudioSpeakerManager {
    private static final String TAG = "AudioSpeakersManagerImpl";
    private Map<Long, Long> mAudioStreamSpeakers = new ConcurrentHashMap<Long, Long>();
    private Disposable mTimer;

    public void acceptSpeakerData(MediaVideoMsg.LiveAudioStreamStatusInfo info) {
        this.addNewSpeakerData(info.actualUids);
        this.filterNotifyTimeoutSpeakers();
    }

    private void addNewSpeakerData(long[] uids) {
        if (this.mAudioStreamSpeakers == null) {
            this.mAudioStreamSpeakers = new ConcurrentHashMap<Long, Long>();
        }
        this.updateSpeakersCurrentTime(this.mAudioStreamSpeakers, uids);
    }

    private void updateSpeakersCurrentTime(Map<Long, Long> targetMap, long[] uids) {
        if (targetMap != null && !FP.empty((long[])uids)) {
            long curTime = System.currentTimeMillis();
            long[] lArray = uids;
            int n = lArray.length;
            for (int i = 0; i < n; ++i) {
                Long uid = lArray[i];
                targetMap.put(uid, curTime);
            }
        }
    }

    private void filterNotifyTimeoutSpeakers() {
        if (this.mTimer == null || this.mTimer.isDisposed()) {
            this.mTimer = Observable.interval((long)10000L, (TimeUnit)TimeUnit.MILLISECONDS).observeOn(Schedulers.io()).subscribeOn(AndroidSchedulers.mainThread()).subscribe((Consumer)new Consumer<Long>(){

                public void accept(Long aLong) throws Exception {
                    if (!FP.empty((Map)AudioSpeakersManagerImpl.this.mAudioStreamSpeakers)) {
                        long curTime = System.currentTimeMillis();
                        for (Map.Entry entry : AudioSpeakersManagerImpl.this.mAudioStreamSpeakers.entrySet()) {
                            MLog.debug((Object)AudioSpeakersManagerImpl.TAG, (String)"filterNotifyTimeoutSpeakers: remove uid=%s\uff0c size=%s", (Object[])new Object[]{entry.getKey(), AudioSpeakersManagerImpl.this.mAudioStreamSpeakers.size()});
                            if (curTime - (Long)entry.getValue() <= 10000L || AudioSpeakersManagerImpl.this.mAudioStreamSpeakers.size() <= 1) continue;
                            AudioSpeakersManagerImpl.this.mAudioStreamSpeakers.remove(entry.getKey());
                        }
                    }
                }
            }, (Consumer)new Consumer<Throwable>(){

                public void accept(Throwable throwable) throws Exception {
                    MLog.error((Object)AudioSpeakersManagerImpl.TAG, (String)("filterNotifyTimeoutSpeakers: throwable=" + throwable), (Object[])new Object[0]);
                }
            });
        }
    }

    @Override
    public Long[] getSpeakers() {
        Long[] uids = new Long[]{};
        if (this.mAudioStreamSpeakers != null) {
            return this.mAudioStreamSpeakers.keySet().toArray(uids);
        }
        return uids;
    }

    public void release() {
        if (this.mAudioStreamSpeakers != null) {
            this.mAudioStreamSpeakers.clear();
        }
        if (this.mTimer != null && !this.mTimer.isDisposed()) {
            this.mTimer.dispose();
            this.mTimer = null;
        }
    }

    private AudioSpeakersManagerImpl() {
    }

    public static AudioSpeakersManagerImpl getInstance() {
        return Holder.INSTANCE;
    }

    private static class Holder {
        private static AudioSpeakersManagerImpl INSTANCE = new AudioSpeakersManagerImpl();

        private Holder() {
        }
    }
}

