/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.sdkwrapper.flowmanagement.internal.audio;

import com.yy.mobile.sdkwrapper.flowmanagement.api.audience.liveinfo.LiveInfoChangeEventHandler;
import com.yy.mobile.sdkwrapper.flowmanagement.base.audience.liveinfo.LiveInfoChangeListener;
import com.yy.mobile.sdkwrapper.flowmanagement.base.audio.IAudioManager;
import com.yy.mobile.sdkwrapper.flowmanagement.internal.audience.player.LivePlayerFactory;
import com.yy.mobile.sdkwrapper.flowmanagement.internal.audience.videoquality.AudienceVideoQualityManagerImpl;
import com.yy.mobile.util.log.MLog;
import com.yy.yylivekit.ILivePlayer;
import com.yy.yylivekit.YLKLive;
import com.yy.yylivekit.audience.Audience;
import com.yy.yylivekit.audience.LivePlayer;
import com.yy.yylivekit.model.LiveInfo;
import com.yyproto.utils.FP;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class AudioManagerImpl
implements IAudioManager,
LiveInfoChangeListener {
    private static final String TAG = "AudioManagerImpl";
    private boolean mIsAudioEnable = true;
    private boolean mNeedToSubscribeAudio = true;
    private Set<Long> mMuteAudioUids = new HashSet<Long>();

    @Override
    public void openAudio() {
        MLog.info((Object)TAG, (String)"openAudio:", (Object[])new Object[0]);
        this.enableAudio(true);
    }

    @Override
    public void closeAudio() {
        MLog.info((Object)TAG, (String)"closeAudio:", (Object[])new Object[0]);
        this.enableAudio(false);
    }

    @Override
    public void closeAudioByUid(long uid) {
        MLog.info((Object)TAG, (String)("closeAudioByUid called with: uid = [" + uid + "]"), (Object[])new Object[0]);
        this.mMuteAudioUids.add(uid);
        YLKLive.instance().forbiddenTalking(uid, true);
    }

    @Override
    public void openAudioByUid(long uid) {
        MLog.info((Object)TAG, (String)("openAudioByUid called with: uid = [" + uid + "]"), (Object[])new Object[0]);
        this.mMuteAudioUids.remove(uid);
        YLKLive.instance().forbiddenTalking(uid, false);
    }

    public void enableAudio(boolean enable) {
        if (this.mIsAudioEnable == enable) {
            MLog.info((Object)TAG, (String)"enableAudio, same enable value: %b, do nothing", (Object[])new Object[]{enable});
            return;
        }
        MLog.info((Object)TAG, (String)("enableAudio called with: enable = [" + enable + "], mIsAudioEnable: %b"), (Object[])new Object[]{this.mIsAudioEnable});
        this.innerEnableAudio(enable);
    }

    private void innerEnableAudio(boolean enable) {
        MLog.info((Object)TAG, (String)("innerEnableAudio called with: enable = [" + enable + "]"), (Object[])new Object[0]);
        YLKLive.instance().setMute(enable);
        this.mIsAudioEnable = enable;
    }

    public void onTransSdkReInstall() {
        MLog.info((Object)TAG, (String)"onTransSdkReInstall called", (Object[])new Object[0]);
        this.innerEnableAudio(this.mIsAudioEnable);
    }

    @Override
    public void onAddLiveInfos(List<LiveInfo> liveInfos) {
        MLog.info((Object)TAG, (String)"onAddLiveInfos:", (Object[])new Object[0]);
        for (LiveInfo liveinfo : liveInfos) {
            if (liveinfo.isMultiSource()) {
                this.innerPlayAudio(liveinfo, liveInfos, true);
                break;
            }
            this.innerPlayAudio(liveinfo, null, false);
        }
    }

    private void innerPlayAudio(LiveInfo liveinfo, List<LiveInfo> liveInfos, boolean isMultiSource) {
        MLog.info((Object)TAG, (String)("innerPlayAudio called with: mNeedToSubscribeAudio: %b, liveinfo = [" + liveinfo + "], liveInfos = [" + liveInfos + "], isMultiSource = [" + isMultiSource + "]"), (Object[])new Object[]{this.mNeedToSubscribeAudio});
        if (!this.mNeedToSubscribeAudio) {
            MLog.info((Object)TAG, (String)"innerPlayAudio, mNeedToSubscribeAudio false, do nothing", (Object[])new Object[0]);
            return;
        }
        LivePlayer player = LivePlayerFactory.getInstance().getOrCreateLivePlayer(liveinfo);
        if (player.isStartState()) {
            MLog.info((Object)TAG, (String)"innerPlayAudio, player has started, do nothing", (Object[])new Object[0]);
            return;
        }
        if (isMultiSource) {
            int addResult = player.addLiveInfoSet(new HashSet<LiveInfo>(liveInfos));
            MLog.info((Object)TAG, (String)"innerPlayAudio, is multi source, add to live player, addResult: %d", (Object[])new Object[]{addResult});
        }
        int videoSource = AudienceVideoQualityManagerImpl.getInstance().getVideoSourceToPlay();
        MLog.info((Object)TAG, (String)("innerPlayAudio called with: source: %d, isMultiSource: %b, liveinfo = [" + liveinfo + "], player: %s"), (Object[])new Object[]{videoSource, isMultiSource, player});
        player.setVideoSource(videoSource);
        player.startPlay(ILivePlayer.PlayOption.Audio);
    }

    @Override
    public void onRemoveLiveInfos(List<LiveInfo> liveInfos) {
    }

    @Override
    public void onUpdateLiveInfos(List<LiveInfo> fromLiveInfos, List<LiveInfo> toLiveInfos) {
    }

    @Override
    public void enableRenderVolumeDisplay(boolean enable) {
        MLog.info((Object)TAG, (String)("enableRenderVolumeDisplay:" + enable), (Object[])new Object[0]);
        Audience.instance().enableRenderVolumeDisplay(enable);
    }

    public void setNeedToSubscribeAudio(boolean needToSubscribeAudio) {
        MLog.info((Object)TAG, (String)("setNeedToSubscribeAudio called with: needToSubscribeAudio = [" + needToSubscribeAudio + "]"), (Object[])new Object[0]);
        this.mNeedToSubscribeAudio = needToSubscribeAudio;
    }

    public boolean isNeedToSubscribeAudio() {
        MLog.info((Object)TAG, (String)"isNeedToSubscribeAudio called: %b", (Object[])new Object[]{this.mNeedToSubscribeAudio});
        return this.mNeedToSubscribeAudio;
    }

    private AudioManagerImpl() {
    }

    public void init() {
        MLog.info((Object)TAG, (String)"init called", (Object[])new Object[0]);
        LiveInfoChangeEventHandler.getInstance().addLiveInfoChangeListener(this);
    }

    public void release() {
        MLog.info((Object)TAG, (String)"release called", (Object[])new Object[0]);
        LiveInfoChangeEventHandler.getInstance().removeLiveInfoChangeListener(this);
        this.restoreMuteAudioUids();
    }

    private void restoreMuteAudioUids() {
        if (FP.empty(this.mMuteAudioUids)) {
            return;
        }
        MLog.info((Object)TAG, (String)"restoreMuteAudioUids called, mMuteAudioUids: %s", (Object[])new Object[]{this.mMuteAudioUids});
        for (Long uid : this.mMuteAudioUids) {
            YLKLive.instance().forbiddenTalking(uid.longValue(), false);
        }
        this.mMuteAudioUids.clear();
    }

    public static AudioManagerImpl getInstance() {
        return Holder.INSTANCE;
    }

    private static class Holder {
        private static AudioManagerImpl INSTANCE = new AudioManagerImpl();

        private Holder() {
        }
    }
}

