/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.sdkwrapper.flowmanagement.internal.audience.videoquality;

import com.yy.mobile.sdkwrapper.flowmanagement.api.audience.AudienceVideoManager;
import com.yy.mobile.sdkwrapper.flowmanagement.internal.common.RoleManager;
import com.yy.mobile.util.FP;
import com.yy.mobile.util.log.MLog;

public class StreamLineManagerInternal {
    private static final String TAG = "StreamLineManagerInternal";
    private static final int DEFAULT_LINE = -1;
    private static final long IGNORE_UPDATE_DURATION = 2000L;
    private int mAudienceModeStreamLine = -1;
    private int mAnchorModeStreamLine = -1;
    private long mLastStopPublishMillis;

    void initDefaultStreamLine() {
        MLog.info((Object)TAG, (String)"initDefaultStreamLine called", (Object[])new Object[0]);
        this.mAudienceModeStreamLine = -1;
        this.mAnchorModeStreamLine = -1;
    }

    public int getStreamLineToPlay() {
        if (RoleManager.getInstance().isAudienceRole()) {
            MLog.info((Object)TAG, (String)"getStreamLineToPlay called: audience %d", (Object[])new Object[]{this.mAudienceModeStreamLine});
            return this.mAudienceModeStreamLine;
        }
        MLog.info((Object)TAG, (String)"getStreamLineToPlay called: anchor %d", (Object[])new Object[]{this.mAnchorModeStreamLine});
        return this.mAnchorModeStreamLine;
    }

    void updateStreamLine(int streamLine) {
        if (RoleManager.getInstance().isAudienceRole() && FP.eq((Object)AudienceVideoManager.getInstance().isVideoMixture(), (Object)true)) {
            MLog.info((Object)TAG, (String)"updateStreamLine called with: audience from %d to %d", (Object[])new Object[]{this.mAudienceModeStreamLine, streamLine});
            this.mAudienceModeStreamLine = streamLine;
        } else {
            MLog.info((Object)TAG, (String)"updateStreamLine called with: anchor from %d to %d", (Object[])new Object[]{this.mAnchorModeStreamLine, streamLine});
            this.mAnchorModeStreamLine = streamLine;
        }
    }

    boolean shouldIgnoreUpdate() {
        long updateDuration = System.currentTimeMillis() - this.mLastStopPublishMillis;
        boolean shouldIgnore = updateDuration < 2000L;
        MLog.info((Object)TAG, (String)"shouldIgnoreUpdate called: %b, duration: %d", (Object[])new Object[]{shouldIgnore, updateDuration});
        return shouldIgnore;
    }

    void resetIgnore() {
        MLog.info((Object)TAG, (String)"resetIgnore called", (Object[])new Object[0]);
        this.mLastStopPublishMillis = 0L;
    }

    public void onStopPublish() {
        MLog.info((Object)TAG, (String)"onStopPublish called", (Object[])new Object[0]);
        this.mLastStopPublishMillis = System.currentTimeMillis();
    }

    public static StreamLineManagerInternal getInstance() {
        return Holder.INSTANCE;
    }

    private StreamLineManagerInternal() {
    }

    private static class Holder {
        private static final StreamLineManagerInternal INSTANCE = new StreamLineManagerInternal();

        private Holder() {
        }
    }
}

