/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.sdkwrapper.flowmanagement.internal.audience.videoquality;

import com.yy.android.sniper.annotation.inject.BusEvent;
import com.yy.android.sniper.api.event.EventBinder;
import com.yy.android.sniper.api.event.EventCompat;
import com.yy.mobile.sdkwrapper.flowmanagement.api.audience.videoquality.AudienceVideoQualityManager;
import com.yy.mobile.sdkwrapper.flowmanagement.base.channel.FlowChannelState;
import com.yy.mobile.sdkwrapper.flowmanagement.base.channel.FlowChannelStatusObservable;
import com.yy.mobile.sdkwrapper.flowmanagement.base.entity.AudienceVideoQuality;
import com.yy.mobile.sdkwrapper.flowmanagement.base.util.Observer;
import com.yy.mobile.sdkwrapper.flowmanagement.event.audience.NoVideoStreamEvent;
import com.yy.mobile.sdkwrapper.flowmanagement.internal.audience.videoquality.CurLineBrokenDetector$$EventBinder;
import com.yy.mobile.sdkwrapper.flowmanagement.internal.common.RoleManager;
import com.yy.mobile.util.log.MLog;
import java.util.List;
import java.util.Map;

class CurLineBrokenDetector
implements Observer,
EventCompat {
    private static final String TAG = "CurLineBrokenDetector";
    private int mCurrentLine = 0;
    private Map<Integer, List<AudienceVideoQuality>> mFullLineQuality;
    private LineBrokenCallback mLineBrokenCallback;
    private int mRole = RoleManager.getInstance().isAudienceRole() ? 0 : 1;
    private EventBinder mCurLineBrokenDetectorSniperEventBinder;

    public void onEventBind() {
        if (this.mCurLineBrokenDetectorSniperEventBinder == null) {
            this.mCurLineBrokenDetectorSniperEventBinder = new CurLineBrokenDetector$$EventBinder();
        }
        this.mCurLineBrokenDetectorSniperEventBinder.bindEvent((Object)this);
    }

    public void onEventUnBind() {
        if (this.mCurLineBrokenDetectorSniperEventBinder != null) {
            this.mCurLineBrokenDetectorSniperEventBinder.unBindEvent();
        }
    }

    CurLineBrokenDetector(LineBrokenCallback lineBrokenCallback) {
        this.mLineBrokenCallback = lineBrokenCallback;
        FlowChannelStatusObservable.getInstance().subscribe(this);
        this.onEventBind();
    }

    @Override
    public void onChange(String tag) {
        FlowChannelState state = FlowChannelStatusObservable.getInstance().getState();
        MLog.info((Object)TAG, (String)("channel state change: " + tag + ", state=" + (Object)((Object)state)), (Object[])new Object[0]);
        if (state == FlowChannelState.LEAVED) {
            this.mCurrentLine = 0;
            this.mFullLineQuality = null;
        }
    }

    void updateStreamLineInfo(Map<Integer, List<AudienceVideoQuality>> lineQuality) {
        this.resetFullLineQualitiesIfRoleChange();
        MLog.info((Object)TAG, (String)("[updateStreamLineInfo] curLineQuality=" + lineQuality), (Object[])new Object[0]);
        Map<Integer, List<AudienceVideoQuality>> pre = this.mFullLineQuality;
        MLog.info((Object)TAG, (String)("[updateStreamLineInfo] preLineQuality=" + pre), (Object[])new Object[0]);
        this.mFullLineQuality = lineQuality;
        this.updateCurLine();
        MLog.info((Object)TAG, (String)("mCurrentLine=" + this.mCurrentLine), (Object[])new Object[0]);
        if (this.mCurrentLine >= 0 && pre != null && pre.containsKey(this.mCurrentLine) && lineQuality != null && lineQuality.size() > 0 && !lineQuality.containsKey(this.mCurrentLine)) {
            MLog.info((Object)TAG, (String)"notifyLineBroken, mCurrentLine=%d, preFullLine=%s", (Object[])new Object[]{this.mCurrentLine, pre});
            this.mLineBrokenCallback.onCurrentLineBroken(this.mCurrentLine);
        }
    }

    private void resetFullLineQualitiesIfRoleChange() {
        int curRole;
        int n = curRole = RoleManager.getInstance().isAudienceRole() ? 0 : 1;
        if (curRole != this.mRole) {
            MLog.info((Object)TAG, (String)"Role changed, pre=%d, cur=%d", (Object[])new Object[]{this.mRole, curRole});
            this.mFullLineQuality = null;
            this.mRole = curRole;
        }
    }

    void onUpdateCurStreamLine(Integer curLine) {
        MLog.info((Object)TAG, (String)"onUpdateCurStreamLine,curLine=%d", (Object[])new Object[]{curLine});
        this.mCurrentLine = curLine;
    }

    private void updateCurLine() {
        List<AudienceVideoQuality> qualityList = AudienceVideoQualityManager.getInstance().getAvailableVideoQualities();
        if (qualityList == null || qualityList.size() == 0) {
            return;
        }
        this.mCurrentLine = AudienceVideoQualityManager.getInstance().getCurrentVideoLine();
    }

    @BusEvent(sync=true)
    public void onNoVideoStreamEvent(NoVideoStreamEvent event) {
        MLog.info((Object)TAG, (String)("onNoVideoStreamEvent:" + event), (Object[])new Object[0]);
        this.mFullLineQuality = null;
    }

    static interface LineBrokenCallback {
        public void onCurrentLineBroken(int var1);
    }
}

