/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.sdkwrapper.flowmanagement.internal.audience.videoquality;

import com.yy.mobile.sdkwrapper.flowmanagement.api.audience.videoquality.AndienceVideoQualityEventHandler;
import com.yy.mobile.sdkwrapper.flowmanagement.api.audience.videoquality.AudienceQualityOpStateEventHandler;
import com.yy.mobile.sdkwrapper.flowmanagement.api.audience.videoquality.QualityOpState;
import com.yy.mobile.sdkwrapper.flowmanagement.base.audience.videoquality.IAudienceQualityOpStateListener;
import com.yy.mobile.sdkwrapper.flowmanagement.base.audience.videoquality.IAudienceVideoQualityChangeListener;
import com.yy.mobile.sdkwrapper.flowmanagement.base.entity.AudienceVideoQuality;
import java.util.List;
import java.util.Map;

public class AudienceVideoQualityNotifyCenter {
    private static final String TAG = "AudienceVideoQualityNotifyCenter";

    public void notifyAudienceVideoQualityChange(List<AudienceVideoQuality> videoQualities) {
        List<IAudienceVideoQualityChangeListener> mListeners = AndienceVideoQualityEventHandler.getInstance().getQualityChangeListeners();
        for (IAudienceVideoQualityChangeListener listener : mListeners) {
            listener.onUpdateAvaliableVideoQualities(videoQualities);
        }
    }

    public void notifyStreamLineInfoChange(Map<Integer, List<AudienceVideoQuality>> lineQuality) {
        List<IAudienceVideoQualityChangeListener> mListeners = AndienceVideoQualityEventHandler.getInstance().getQualityChangeListeners();
        for (IAudienceVideoQualityChangeListener listener : mListeners) {
            listener.onUpdateStreamLineInfo(lineQuality);
        }
    }

    public void notifyCurStreamLineChange(Integer curLine, AudienceVideoQuality curVideoQuality) {
        List<IAudienceVideoQualityChangeListener> mListeners = AndienceVideoQualityEventHandler.getInstance().getQualityChangeListeners();
        for (IAudienceVideoQualityChangeListener listener : mListeners) {
            listener.onUpdateCurStreamLine(curLine, curVideoQuality);
        }
    }

    public void notifyVideoQualityOpStateChange(QualityOpState preOpState, QualityOpState curOpState) {
        List<IAudienceQualityOpStateListener> opStateListeners = AudienceQualityOpStateEventHandler.getInstance().getOpStateListeners();
        for (IAudienceQualityOpStateListener opStateListener : opStateListeners) {
            opStateListener.onQualityOpStateChange(preOpState, curOpState);
        }
    }

    public static AudienceVideoQualityNotifyCenter getInstance() {
        return Holder.INSTANCE;
    }

    private AudienceVideoQualityNotifyCenter() {
    }

    private static class Holder {
        private static final AudienceVideoQualityNotifyCenter INSTANCE = new AudienceVideoQualityNotifyCenter();

        private Holder() {
        }
    }
}

