/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.sdkwrapper.flowmanagement.internal.audience.videoquality;

import android.content.Context;
import android.support.annotation.Nullable;
import android.util.Pair;
import android.util.SparseArray;
import com.yy.mobile.config.BasicConfig;
import com.yy.mobile.sdkwrapper.flowmanagement.api.audience.liveinfo.LiveInfoChangeEventHandler;
import com.yy.mobile.sdkwrapper.flowmanagement.api.audience.videoquality.AndienceVideoQualityEventHandler;
import com.yy.mobile.sdkwrapper.flowmanagement.api.audience.videoquality.AudienceQualityOpStateEventHandler;
import com.yy.mobile.sdkwrapper.flowmanagement.api.audience.videoquality.QualityOpState;
import com.yy.mobile.sdkwrapper.flowmanagement.api.line.StreamLineManager;
import com.yy.mobile.sdkwrapper.flowmanagement.base.audience.liveinfo.LiveInfoChangeListener;
import com.yy.mobile.sdkwrapper.flowmanagement.base.audience.videoquality.IAudienceQualityOpStateListener;
import com.yy.mobile.sdkwrapper.flowmanagement.base.audience.videoquality.IAudienceVideoQualityChangeListener;
import com.yy.mobile.sdkwrapper.flowmanagement.base.audience.videoquality.IAudienceVideoQualityManager;
import com.yy.mobile.sdkwrapper.flowmanagement.base.channel.FlowChannelState;
import com.yy.mobile.sdkwrapper.flowmanagement.base.channel.FlowChannelStatusObservable;
import com.yy.mobile.sdkwrapper.flowmanagement.base.entity.AudienceVideoQuality;
import com.yy.mobile.sdkwrapper.flowmanagement.base.util.CollectionUtils;
import com.yy.mobile.sdkwrapper.flowmanagement.base.util.MapKeyValueExchanger;
import com.yy.mobile.sdkwrapper.flowmanagement.base.util.Observer;
import com.yy.mobile.sdkwrapper.flowmanagement.internal.audience.liveinfo.LiveInfoListHolder;
import com.yy.mobile.sdkwrapper.flowmanagement.internal.audience.player.LivePlayerListHolder;
import com.yy.mobile.sdkwrapper.flowmanagement.internal.audience.videoquality.AudienceVideoQualityNotifyCenter;
import com.yy.mobile.sdkwrapper.flowmanagement.internal.audience.videoquality.CurLineBrokenDetector;
import com.yy.mobile.sdkwrapper.flowmanagement.internal.audience.videoquality.StreamLineManagerInternal;
import com.yy.mobile.util.FP;
import com.yy.mobile.util.NetworkUtils;
import com.yy.mobile.util.exception.ExceptionUtil;
import com.yy.mobile.util.log.MLog;
import com.yy.yylivekit.ILivePlayer;
import com.yy.yylivekit.audience.LivePlayer;
import com.yy.yylivekit.model.LiveInfo;
import com.yy.yylivekit.model.VideoGearInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class AudienceVideoQualityManagerImpl
implements IAudienceVideoQualityManager,
Observer,
CurLineBrokenDetector.LineBrokenCallback {
    private static final String TAG = "AudienceVideoQualityManagerImpl";
    @Nullable
    private AudienceVideoQuality mSelectedQuality = AudienceVideoQuality.DEFAULT_HD;
    @Nullable
    private AudienceVideoQuality mUserSelectQuality = null;
    private int mCurSource = 0;
    private List<AudienceVideoQuality> mAvaliableVideoQualities = null;
    private Map<Integer, Map<Integer, List<AudienceVideoQuality>>> mSourceLineQualities = null;
    private QualityOpState mCurQualityOpState = null;
    private SparseArray<Pair<Integer, Integer>> mGlobalLine = new SparseArray();
    private CurLineBrokenDetector mCurrentLineBrokenDetector = new CurLineBrokenDetector(this);
    private StreamLineManagerInternal mStreamLineManager = StreamLineManagerInternal.getInstance();

    private void initEnterChannelDefQuality() {
        this.updateUserSelectQuality(this.getInitDefaultVideoQuality());
        this.updateSelectedQuality(this.mUserSelectQuality);
        this.mCurSource = 0;
        this.mStreamLineManager.initDefaultStreamLine();
        MLog.info((Object)TAG, (String)"initEnterChannelDefQuality called, mSelectedQuality: %s, mUserSelectedQuality: %s", (Object[])new Object[]{this.mSelectedQuality, this.mUserSelectQuality});
    }

    @Nullable
    public AudienceVideoQuality getVideoQualityToPlay() {
        List<AudienceVideoQuality> availableResolutions = this.getAvailableVideoQualities();
        if (this.mUserSelectQuality != null && availableResolutions.contains(this.mUserSelectQuality)) {
            MLog.info((Object)TAG, (String)"getVideoQualityToPlay called, return user selected quality: %s", (Object[])new Object[]{this.mUserSelectQuality});
            this.updateSelectedQuality(this.mUserSelectQuality);
            this.updateUserSelectQuality(this.mUserSelectQuality);
            return this.mUserSelectQuality;
        }
        if (this.mSelectedQuality != null && !availableResolutions.contains(this.mSelectedQuality)) {
            MLog.info((Object)TAG, (String)"getVideoQualityToPlay called, def quality: %s is not available qualities: %s", (Object[])new Object[]{this.mSelectedQuality, availableResolutions});
            this.updateSelectedQuality(this.findAvailableResolution(this.mSelectedQuality));
        }
        if (this.mSelectedQuality == null) {
            ExceptionUtil.throwOrWriteLog(TAG, "[Bug]getVideoQualityToPlay, quality " + this.mSelectedQuality + " not found", new Object[0]);
        }
        return this.mSelectedQuality;
    }

    public int getVideoSourceToPlay() {
        MLog.info((Object)TAG, (String)"getVideoSourceToPlay called: %d", (Object[])new Object[]{this.mCurSource});
        return this.mCurSource;
    }

    public int getStreamLineToPlay() {
        return this.mStreamLineManager.getStreamLineToPlay();
    }

    @Nullable
    private AudienceVideoQuality findAvailableResolution(@Nullable AudienceVideoQuality targetResolution) {
        if (targetResolution == null) {
            MLog.error((Object)TAG, (String)"findAvailableResolution: target resolution is null, return null", (Object[])new Object[0]);
            return null;
        }
        AudienceVideoQuality playQuality = null;
        List<AudienceVideoQuality> availableResolutions = this.getAvailableVideoQualities();
        if (availableResolutions.contains(targetResolution)) {
            playQuality = targetResolution;
        } else {
            int minCodeRate = Integer.MAX_VALUE;
            for (AudienceVideoQuality vq : availableResolutions) {
                if (vq.getCodeRate() >= minCodeRate) continue;
                minCodeRate = vq.getCodeRate();
                playQuality = vq;
            }
        }
        MLog.info((Object)TAG, (String)"findAvailableResolution, target: %s, selected: %s, available: %s", (Object[])new Object[]{targetResolution, playQuality, availableResolutions});
        return playQuality;
    }

    @Override
    public void switchVideoQuality(AudienceVideoQuality quality, int globalLineNum) {
        if (FP.empty(this.mSourceLineQualities)) {
            MLog.error((Object)TAG, (String)"switchVideoLineAndQuality error, empty mSourceLineQualities:%s", (Object[])new Object[]{this.mSourceLineQualities});
            return;
        }
        Pair srcAndLocalLine = (Pair)this.mGlobalLine.get(globalLineNum);
        if (srcAndLocalLine == null || this.mSourceLineQualities.get(srcAndLocalLine.first) == null) {
            MLog.error((Object)TAG, (String)"found source and localLine failed, globalLineNum=%d, mGlobalLine=%s", (Object[])new Object[]{globalLineNum, this.mGlobalLine});
            return;
        }
        if (this.mSourceLineQualities != null && !this.mSourceLineQualities.get(srcAndLocalLine.first).get(srcAndLocalLine.second).contains(quality)) {
            MLog.error((Object)TAG, (String)"switchVideoLineAndQuality error, not found quality:%s in mSourceLineQualities:%s", (Object[])new Object[]{quality, this.mSourceLineQualities});
            return;
        }
        List<LivePlayer> players = LivePlayerListHolder.getInstance().getPlayers();
        MLog.info((Object)TAG, (String)("switchVideoQuality called with: quality = [" + quality + "], available qualities: %s, players size: %d"), (Object[])new Object[]{this.getAvailableVideoQualities(), FP.size(players)});
        AudienceVideoQualityNotifyCenter.getInstance().notifyVideoQualityOpStateChange(this.mCurQualityOpState, QualityOpState.SWITCHING);
        QualityOpState preQualityOpState = this.mCurQualityOpState;
        boolean switchFailed = false;
        for (LivePlayer player : players) {
            int result = player.switchQuality(quality.toGearInfo(), (Integer)srcAndLocalLine.second, (Integer)srcAndLocalLine.first);
            if (result == 0) continue;
            switchFailed = true;
            MLog.error((Object)TAG, (String)"switchVideoQuality failed, player: %s", (Object[])new Object[]{player});
        }
        if (!switchFailed) {
            this.updateUserSelectQuality(quality);
            this.updateSelectedQuality(quality);
            this.mStreamLineManager.resetIgnore();
            this.updateCurrentLocalLine((Integer)srcAndLocalLine.second);
            this.mCurQualityOpState = QualityOpState.SWITCH_SUCCESS;
        } else {
            this.mCurQualityOpState = QualityOpState.SWITCH_FAILED;
        }
        AudienceVideoQualityNotifyCenter.getInstance().notifyVideoQualityOpStateChange(preQualityOpState, this.mCurQualityOpState);
    }

    @Override
    @Deprecated
    public void switchVideoQuality(AudienceVideoQuality quality) {
        ExceptionUtil.throwOrWriteLog(TAG, "deprecated switchVideoQuality", new Object[0]);
        List<AudienceVideoQuality> availableVideoQualities = this.getAvailableVideoQualities();
        if (!availableVideoQualities.contains(quality)) {
            MLog.error((Object)TAG, (String)"switchVideoQuality, quality not found, available qualities: %s, selected quality: %s", (Object[])new Object[]{availableVideoQualities, quality});
            return;
        }
        List<LivePlayer> players = LivePlayerListHolder.getInstance().getPlayers();
        MLog.info((Object)TAG, (String)("switchVideoQuality called with: quality = [" + quality + "], available qualities: %s, players size: %d"), (Object[])new Object[]{availableVideoQualities, FP.size(players)});
        AudienceVideoQualityNotifyCenter.getInstance().notifyVideoQualityOpStateChange(this.mCurQualityOpState, QualityOpState.SWITCHING);
        QualityOpState preQualityOpState = this.mCurQualityOpState;
        boolean switchFailed = false;
        int streamLine = this.getStreamLineToPlay();
        for (LivePlayer player : players) {
            int result = player.switchQuality(quality.toGearInfo(), Integer.valueOf(streamLine), Integer.valueOf(this.mCurSource));
            if (result == 0) continue;
            switchFailed = true;
            MLog.error((Object)TAG, (String)"switchVideoQuality failed, player: %s", (Object[])new Object[]{player});
        }
        if (!switchFailed) {
            this.updateSelectedQuality(quality);
            this.mCurQualityOpState = QualityOpState.SWITCH_SUCCESS;
        } else {
            this.mCurQualityOpState = QualityOpState.SWITCH_FAILED;
        }
        AudienceVideoQualityNotifyCenter.getInstance().notifyVideoQualityOpStateChange(preQualityOpState, this.mCurQualityOpState);
    }

    @Override
    @Nullable
    public AudienceVideoQuality getSelectedVideoQuality() {
        MLog.info((Object)TAG, (String)"getSelectedVideoQuality called, selected quality: %s", (Object[])new Object[]{this.mSelectedQuality});
        return this.mSelectedQuality;
    }

    @Override
    public List<AudienceVideoQuality> getAvailableVideoQualities() {
        List<LiveInfo> liveInfos = LiveInfoListHolder.getInstance().getLiveInfoList();
        HashSet<AudienceVideoQuality> availableSet = new HashSet<AudienceVideoQuality>();
        for (LiveInfo liveInfo : liveInfos) {
            if (!liveInfo.hasVideo()) continue;
            List<AudienceVideoQuality> li = AudienceVideoQuality.fromList(liveInfo.getVideoQuality());
            if (FP.empty(li)) {
                ExceptionUtil.throwOrWriteLog(TAG, "[Bug]getAvailableVideoQualities, live info has empty video quality", new Object[0]);
                continue;
            }
            availableSet.addAll(li);
        }
        ArrayList<AudienceVideoQuality> availableList = new ArrayList<AudienceVideoQuality>(availableSet);
        if (availableList.size() == 0) {
            MLog.error((Object)TAG, (String)"getAvailableVideoQualities empty, liveInfos: %s", (Object[])new Object[]{liveInfos});
        }
        MLog.info((Object)TAG, (String)"getAvailableVideoQualities: %s", (Object[])new Object[]{availableList});
        return availableList;
    }

    private AudienceVideoQuality getInitDefaultVideoQuality() {
        int phoneType = BasicConfig.getInstance().phoneType;
        if (phoneType != 2) {
            MLog.info((Object)TAG, (String)"getInitDefaultVideoQuality: device is low phone type, use standard", (Object[])new Object[0]);
            return AudienceVideoQuality.DEFAULT_STANDARD;
        }
        AudienceVideoQuality initQuality = AudienceVideoQuality.DEFAULT_HD;
        boolean isWifi = NetworkUtils.isWifiActive((Context)BasicConfig.getInstance().getAppContext());
        MLog.info((Object)TAG, (String)"getInitDefaultVideoQuality called, initQuality: %s, phoneType: %d, isWifi: %b", (Object[])new Object[]{initQuality, phoneType, isWifi});
        return initQuality;
    }

    private void syncVideoQualitiesData() {
        List<AudienceVideoQuality> newVideoQualities = this.getAvailableVideoQualities();
        boolean areAllItemsTheSame = CollectionUtils.areAllItemsTheSame(newVideoQualities, this.mAvaliableVideoQualities);
        MLog.info((Object)TAG, (String)"syncVideoQualitiesData: old: %s, new: %s, areAllItemsTheSame: %b", (Object[])new Object[]{this.mAvaliableVideoQualities, newVideoQualities, areAllItemsTheSame});
        if (!areAllItemsTheSame) {
            this.mAvaliableVideoQualities = newVideoQualities;
            this.syncGlobalLine();
            this.notifyVideoQualitiesChange();
        }
    }

    private void notifyVideoQualitiesChange() {
        MLog.info((Object)TAG, (String)"notifyVideoQualitiesChange: %s", (Object[])new Object[]{this.mAvaliableVideoQualities});
        AudienceVideoQualityNotifyCenter.getInstance().notifyAudienceVideoQualityChange(this.mAvaliableVideoQualities);
    }

    private void syncLiveStreamLineInfo(Map<Integer, Map<Integer, List<AudienceVideoQuality>>> sourceLineQuality) {
        this.mSourceLineQualities = sourceLineQuality;
        MLog.info((Object)TAG, (String)("syncLiveStreamLineInfo: mSourceLineQualities=" + this.mSourceLineQualities), (Object[])new Object[0]);
        this.syncGlobalLine();
        Map<Integer, List<AudienceVideoQuality>> globalLineQualitiesMap = this.genGlobalLineQualitiesMap(this.mSourceLineQualities);
        this.mCurrentLineBrokenDetector.updateStreamLineInfo(globalLineQualitiesMap);
        AudienceVideoQualityNotifyCenter.getInstance().notifyStreamLineInfoChange(globalLineQualitiesMap);
        for (LivePlayer player : LivePlayerListHolder.getInstance().getPlayers()) {
            LiveInfo curLiveInfo = player.getCurLiveInfo();
            if ((!curLiveInfo.isMix || curLiveInfo.micNo != -1) && (curLiveInfo.isMix || curLiveInfo.micNo != 0)) continue;
            this.mCurSource = player.getCurLiveInfo().source;
            int line = player.getCurLineNum();
            this.updateSelectedQuality(AudienceVideoQuality.from(player.getCurVideoQuality()));
            MLog.info((Object)TAG, (String)"syncLiveStreamLineInfo, mCurSource=%d, mCurrentLocalLine=%d, mSelectedQuality=%s", (Object[])new Object[]{this.mCurSource, line, this.mSelectedQuality});
            this.syncCurStreamLine(this.mCurSource, line, this.mSelectedQuality);
            break;
        }
    }

    private int toGlobalLine(int sourceNum, int localLine) {
        if (sourceNum == 0) {
            return localLine;
        }
        return (sourceNum - 1) * 8 + localLine;
    }

    private Map<Integer, List<AudienceVideoQuality>> genGlobalLineQualitiesMap(Map<Integer, Map<Integer, List<AudienceVideoQuality>>> sourceLinesQualities) {
        MLog.info((Object)TAG, (String)("[genGlobalLineQualitiesMap] sourceLinesQualities: " + sourceLinesQualities), (Object[])new Object[0]);
        if (FP.empty(sourceLinesQualities)) {
            return Collections.emptyMap();
        }
        HashMap<Integer, List<AudienceVideoQuality>> target = new HashMap<Integer, List<AudienceVideoQuality>>();
        Object[] videoSourceArray = sourceLinesQualities.keySet().toArray(new Integer[0]);
        if (videoSourceArray.length == 1) {
            this.copyToTarget(sourceLinesQualities, (Integer)videoSourceArray[0], 4, target);
        } else {
            Arrays.sort(videoSourceArray);
            for (Object videoSource : videoSourceArray) {
                this.copyToTarget(sourceLinesQualities, (Integer)videoSource, 3, target);
            }
        }
        MLog.info((Object)TAG, (String)"[genGlobalLineQualitiesMap] biz lineQualities: %s", (Object[])new Object[]{target});
        return target;
    }

    private void copyToTarget(Map<Integer, Map<Integer, List<AudienceVideoQuality>>> sourceLinesQualities, Integer videoSource, int most, Map<Integer, List<AudienceVideoQuality>> target) {
        Map<Integer, List<AudienceVideoQuality>> lineQuality = sourceLinesQualities.get(videoSource);
        Object[] lines = lineQuality.keySet().toArray(new Integer[0]);
        Arrays.sort(lines);
        for (int i = 0; i < lines.length && i < most; ++i) {
            List<AudienceVideoQuality> qualities = lineQuality.get(lines[i]);
            target.put(this.toGlobalLine(videoSource, (Integer)lines[i]), qualities);
        }
    }

    private void syncCurStreamLine(int curSource, Integer curLine, @Nullable AudienceVideoQuality videoQuality) {
        if (this.mStreamLineManager.shouldIgnoreUpdate()) {
            MLog.error((Object)TAG, (String)"ignore sync stream line", (Object[])new Object[0]);
            return;
        }
        MLog.info((Object)TAG, (String)"syncCurStreamLine: curSource=%d, curLine=%d, videoQuality=%s", (Object[])new Object[]{curSource, curLine, videoQuality});
        this.mCurSource = curSource;
        this.updateCurrentLocalLine(curLine);
        this.updateSelectedQuality(videoQuality);
        this.syncGlobalLine();
        if (videoQuality != null) {
            AudienceVideoQualityNotifyCenter.getInstance().notifyCurStreamLineChange(this.toGlobalLine(this.mCurSource, curLine), videoQuality);
            this.mCurrentLineBrokenDetector.onUpdateCurStreamLine(curLine);
        }
    }

    private void syncGlobalLine() {
        SparseArray ret = new SparseArray();
        for (LivePlayer player : LivePlayerListHolder.getInstance().getPlayers()) {
            LiveInfo curLiveInfo = player.getCurLiveInfo();
            if ((!curLiveInfo.isMix || curLiveInfo.micNo != -1) && (curLiveInfo.isMix || curLiveInfo.micNo != 0)) continue;
            Map allLines = player.getAllLines();
            for (Map.Entry entry : allLines.entrySet()) {
                Integer src = (Integer)entry.getKey();
                Set localLines = ((Map)entry.getValue()).keySet();
                for (Integer local : localLines) {
                    int globalLine = this.toGlobalLine(src, local);
                    ret.put(globalLine, (Object)new Pair((Object)src, (Object)local));
                }
            }
        }
        MLog.info((Object)TAG, (String)"syncGlobalLine, mGlobalLine=%s", (Object[])new Object[]{ret});
        this.mGlobalLine = ret;
    }

    public void onVideoCodeRateChangeNotify(long uid, int codeRate, AudienceVideoQuality videoQuality) {
        MLog.info((Object)TAG, (String)"onVideoCodeRateChangeNotify: videoQuality=%s", (Object[])new Object[]{videoQuality});
        this.updateSelectedQuality(videoQuality);
        this.notifyVideoQualitiesChange();
    }

    @Override
    public void switchVideoQualityLine(int globalLineNum) {
        MLog.info((Object)TAG, (String)"switchVideoQualityLine called with: mSelectedQuality: %s, globalLineNum: %s", (Object[])new Object[]{this.mSelectedQuality, globalLineNum});
        this.switchVideoQuality(this.mSelectedQuality, globalLineNum);
    }

    @Override
    public void switchVideoQuality(@Nullable AudienceVideoQuality quality, Integer localLineNum, Integer videoSource) {
        if (this.mSelectedQuality == null) {
            ExceptionUtil.throwOrWriteLog(TAG, "switchVideoQuality failed with null mSelectedQuality", new Object[0]);
            return;
        }
        MLog.info((Object)TAG, (String)("switchVideoQuality called with: quality = [" + quality + "], localLineNum = [" + localLineNum + "], videoSource = [" + videoSource + "]"), (Object[])new Object[0]);
        List<LivePlayer> players = LivePlayerListHolder.getInstance().getPlayers();
        boolean switchFailed = false;
        for (LivePlayer player : players) {
            int result = player.switchQuality(this.mSelectedQuality.toGearInfo(), localLineNum, Integer.valueOf(this.mCurSource));
            if (result == 0) continue;
            switchFailed = true;
            MLog.error((Object)TAG, (String)"switchVideoQualityLine failed", (Object[])new Object[0]);
        }
        if (!switchFailed) {
            this.mStreamLineManager.resetIgnore();
            this.updateCurrentLocalLine(localLineNum);
            this.mCurSource = videoSource;
        }
    }

    @Override
    public int getCurrentVideoLine() {
        int line = this.getStreamLineToPlay();
        int r = this.toGlobalLine(this.mCurSource, line);
        MLog.info((Object)TAG, (String)"getCurrentVideoLine:%d, mCurSource=%d, line=%d", (Object[])new Object[]{r, this.mCurSource, line});
        return r;
    }

    @Override
    public List<Integer> getCurrentQualityVideoLines() {
        if (this.mSelectedQuality == null || FP.empty(this.mSourceLineQualities)) {
            MLog.info((Object)TAG, (String)"getCurrentQualityVideoLines: data invalid, return empty list, mSelectedQuality:%s", (Object[])new Object[]{this.mSelectedQuality});
            return new ArrayList<Integer>();
        }
        MapKeyValueExchanger<Integer, AudienceVideoQuality> mapKeyValueExchanger = new MapKeyValueExchanger<Integer, AudienceVideoQuality>();
        Map<AudienceVideoQuality, List<Integer>> lines = mapKeyValueExchanger.exchangeKeyValue(this.genGlobalLineQualitiesMap(this.mSourceLineQualities));
        MLog.debug((Object)TAG, (String)("getCurrentQualityVideoLines: mSelectedQuality=" + this.mSelectedQuality + ", lines=" + lines), (Object[])new Object[0]);
        List<Integer> ret = lines.get(this.mSelectedQuality);
        if (ret != null) {
            Collections.sort(ret);
        } else {
            ret = Collections.emptyList();
        }
        return ret;
    }

    @Override
    public Map<Integer, List<AudienceVideoQuality>> getFullQualityVideoLines() {
        MLog.debug((Object)TAG, (String)"getFullQualityVideoLines:%s ", (Object[])new Object[]{this.mSourceLineQualities});
        if (!FP.empty(this.mSourceLineQualities)) {
            return this.genGlobalLineQualitiesMap(this.mSourceLineQualities);
        }
        return Collections.emptyMap();
    }

    public void release() {
        if (this.mSourceLineQualities != null) {
            this.mSourceLineQualities.clear();
            this.mSourceLineQualities = null;
        }
    }

    @Override
    public void onChange(String tag) {
        FlowChannelState state = FlowChannelStatusObservable.getInstance().getState();
        MLog.info((Object)TAG, (String)("channel state change: " + tag + ", state=" + (Object)((Object)state)), (Object[])new Object[0]);
        if (state == FlowChannelState.JOINING) {
            this.initEnterChannelDefQuality();
        } else if (state == FlowChannelState.LEAVED) {
            // empty if block
        }
    }

    public void onLiveStreamLineInfo(ILivePlayer player, LiveInfo liveInfo, int videoSource, int curLine, Map<Integer, Map<Integer, List<VideoGearInfo>>> sourceLineQualities) {
        MLog.info((Object)TAG, (String)("onLiveStreamLineInfo called with: player = [" + player + "], liveInfo = [" + liveInfo + "], videoSource = [" + videoSource + "], curLine = [" + curLine + "], sourceLineQualitys = [" + sourceLineQualities + "]"), (Object[])new Object[0]);
        if (liveInfo != null && (liveInfo.micNo == 0 || liveInfo.isMix)) {
            HashMap<Integer, Map<Integer, List<AudienceVideoQuality>>> sourceLineQualityMap = new HashMap<Integer, Map<Integer, List<AudienceVideoQuality>>>();
            for (Integer source : sourceLineQualities.keySet()) {
                sourceLineQualityMap.put(source, this.convertLineQualityMap(sourceLineQualities.get(source)));
            }
            this.syncLiveStreamLineInfo(sourceLineQualityMap);
            this.syncCurStreamLine(liveInfo.source, curLine, this.mSelectedQuality);
        }
    }

    private Map<Integer, List<AudienceVideoQuality>> convertLineQualityMap(Map<Integer, List<VideoGearInfo>> orgLineQualityMap) {
        HashMap<Integer, List<AudienceVideoQuality>> map = new HashMap<Integer, List<AudienceVideoQuality>>();
        if (orgLineQualityMap == null) {
            return map;
        }
        for (Map.Entry<Integer, List<VideoGearInfo>> entry : orgLineQualityMap.entrySet()) {
            map.put(entry.getKey(), new ArrayList());
            List<VideoGearInfo> qualityList = entry.getValue();
            if (FP.empty(qualityList)) continue;
            for (VideoGearInfo quality : qualityList) {
                ((List)map.get(entry.getKey())).add(AudienceVideoQuality.from(quality));
            }
        }
        return map;
    }

    @Override
    public void addVideoQualityChangeListener(IAudienceVideoQualityChangeListener videoQualityChangeListener) {
        AndienceVideoQualityEventHandler.getInstance().addVideoQualityChangeListener(videoQualityChangeListener);
    }

    @Override
    public void removeVideoQualityChangeListener(IAudienceVideoQualityChangeListener videoQualityChangeListener) {
        AndienceVideoQualityEventHandler.getInstance().removeVideoQualityChangeListener(videoQualityChangeListener);
    }

    @Override
    public void addVideoQualityOpStateListener(IAudienceQualityOpStateListener qualityOpStateListener) {
        AudienceQualityOpStateEventHandler.getInstance().addVideoQualityOpStateListener(qualityOpStateListener);
    }

    @Override
    public void removeVideoQualityOpStateListener(IAudienceQualityOpStateListener qualityOpStateListener) {
        AudienceQualityOpStateEventHandler.getInstance().removeVideoQualityOpStateListener(qualityOpStateListener);
    }

    private void updateCurrentLocalLine(Integer localLineNum) {
        this.mStreamLineManager.updateStreamLine(localLineNum);
    }

    private void updateUserSelectQuality(@Nullable AudienceVideoQuality quality) {
        int index;
        if (quality == null) {
            ExceptionUtil.throwOrWriteLog(TAG, "updateUserSelectQuality failed with null quality", new Object[0]);
            return;
        }
        MLog.info((Object)TAG, (String)("updateUserSelectQuality called with: quality = [" + quality + "]"), (Object[])new Object[0]);
        this.mUserSelectQuality = quality;
        if (this.mUserSelectQuality.isMock() && (index = this.getAvailableVideoQualities().indexOf(this.mUserSelectQuality)) >= 0) {
            this.mUserSelectQuality = this.getAvailableVideoQualities().get(index);
        }
    }

    private void updateSelectedQuality(@Nullable AudienceVideoQuality quality) {
        int index;
        if (quality == null) {
            ExceptionUtil.throwOrWriteLog(TAG, "updateSelectedQuality with null quality", new Object[0]);
            return;
        }
        MLog.info((Object)TAG, (String)("updateSelectedQuality called with: quality = [" + quality + "]"), (Object[])new Object[0]);
        this.mSelectedQuality = quality;
        if (this.mSelectedQuality.isMock() && (index = this.getAvailableVideoQualities().indexOf(this.mSelectedQuality)) >= 0) {
            this.mSelectedQuality = this.getAvailableVideoQualities().get(index);
        }
    }

    public static AudienceVideoQualityManagerImpl getInstance() {
        return Holder.INSTANCE;
    }

    private AudienceVideoQualityManagerImpl() {
        FlowChannelStatusObservable.getInstance().subscribe(this);
        LiveInfoChangeEventHandler.getInstance().addLiveInfoChangeListener(new LiveInfoChangeListener(){

            @Override
            public void onAddLiveInfos(List<LiveInfo> liveInfos) {
                AudienceVideoQualityManagerImpl.this.syncVideoQualitiesData();
            }

            @Override
            public void onRemoveLiveInfos(List<LiveInfo> liveInfos) {
                AudienceVideoQualityManagerImpl.this.syncVideoQualitiesData();
            }

            @Override
            public void onUpdateLiveInfos(List<LiveInfo> fromLiveInfos, List<LiveInfo> toLiveInfos) {
                AudienceVideoQualityManagerImpl.this.syncVideoQualitiesData();
            }
        }, true);
        this.mCurQualityOpState = QualityOpState.INIT;
    }

    @Override
    public void onCurrentLineBroken(int brokenLine) {
        StreamLineManager.getInstance().notifyStreamLineBroken(brokenLine);
    }

    private static class Holder {
        private static final AudienceVideoQualityManagerImpl INSTANCE = new AudienceVideoQualityManagerImpl();

        private Holder() {
        }
    }
}

