/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.sdkwrapper.flowmanagement.internal.audience.videoid;

import android.support.annotation.NonNull;
import com.yy.mobile.sdkwrapper.flowmanagement.internal.audience.liveinfo.LiveInfoUtils;
import com.yy.mobile.sdkwrapper.flowmanagement.internal.audience.videoid.AbsVideoId;
import com.yy.mobile.util.log.MLog;
import com.yy.yylivekit.model.LiveInfo;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class UidVideoId
extends AbsVideoId {
    private static final String TAG = "UidVideoId";
    private long mUid;

    public UidVideoId(long uid) {
        MLog.info((Object)TAG, (String)("UidVideoId called with: uid = [" + uid + "]"), (Object[])new Object[0]);
        this.mUid = uid;
    }

    @Override
    @NonNull
    protected String getLogTag() {
        return TAG;
    }

    @Override
    @NonNull
    public Set<LiveInfo> getLiveInfosToAdd(List<LiveInfo> liveInfoList) {
        List<LiveInfo> resultList = LiveInfoUtils.getLiveInfosByUid(liveInfoList, this.mUid, true);
        MLog.info((Object)TAG, (String)("getLiveInfosToAdd called with: liveInfoList = [" + liveInfoList + "], resultList:%s"), (Object[])new Object[]{resultList});
        return super.getLiveInfosToAdd(resultList);
    }

    @Override
    @NonNull
    public Set<LiveInfo> removeLiveInfoIfNeeded(List<LiveInfo> removeLiveInfos) {
        LinkedHashSet<LiveInfo> localRemovedList = new LinkedHashSet<LiveInfo>();
        for (LiveInfo liveInfo : removeLiveInfos) {
            if (!LiveInfoUtils.containsUid(liveInfo, this.mUid)) continue;
            this.mLiveInfos.remove(liveInfo);
            localRemovedList.add(liveInfo);
        }
        MLog.info((Object)TAG, (String)("removeLiveInfoIfNeeded called with: removeLiveInfos = [" + removeLiveInfos + "], localRemoveList: %s"), (Object[])new Object[]{localRemovedList});
        return localRemovedList;
    }

    public String toString() {
        return "UidVideoId{mUid=" + this.mUid + ", mLiveInfos=" + this.mLiveInfos + '}';
    }
}

