/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.sdkwrapper.flowmanagement.internal.audience.videoid;

import android.support.annotation.NonNull;
import com.yy.mobile.sdkwrapper.flowmanagement.base.entity.VideoPlayInfo;
import com.yy.mobile.sdkwrapper.flowmanagement.internal.audience.liveinfo.LiveInfoUtils;
import com.yy.mobile.sdkwrapper.flowmanagement.internal.audience.videoid.AbsVideoId;
import com.yy.mobile.util.log.MLog;
import com.yy.yylivekit.model.LiveInfo;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class MicNoVideoId
extends AbsVideoId {
    private static final String TAG = "MicNoVideoId";
    private int mMicNo;
    private Set<Long> mUidSet = new LinkedHashSet<Long>();

    public MicNoVideoId(int micNo) {
        MLog.info((Object)TAG, (String)("MicNoVideoId called with: micNo = [" + micNo + "]"), (Object[])new Object[0]);
        this.mMicNo = micNo;
    }

    @Override
    @NonNull
    protected String getLogTag() {
        return TAG;
    }

    @Override
    @NonNull
    public Set<LiveInfo> getLiveInfosToAdd(List<LiveInfo> liveInfoList) {
        List<LiveInfo> resultList = LiveInfoUtils.getLiveInfosByMicNo(liveInfoList, this.mMicNo, true);
        return super.getLiveInfosToAdd(resultList);
    }

    @Override
    @NonNull
    public Set<LiveInfo> removeLiveInfoIfNeeded(List<LiveInfo> fullRemovedLiveInfos) {
        MLog.info((Object)TAG, (String)("before removeLiveInfoIfNeeded called with: fullRemovedLiveInfos = [" + fullRemovedLiveInfos + "], local live infos: %s"), (Object[])new Object[]{this.mLiveInfos});
        LinkedHashSet<LiveInfo> localRemovedLiveInfos = new LinkedHashSet<LiveInfo>();
        block0: for (LiveInfo liveInfo : fullRemovedLiveInfos) {
            if (LiveInfoUtils.containsMicNo(liveInfo, this.mMicNo)) {
                this.mLiveInfos.remove(liveInfo);
                localRemovedLiveInfos.add(liveInfo);
                continue;
            }
            for (Long uid : this.mUidSet) {
                if (!LiveInfoUtils.containsUid(liveInfo, uid)) continue;
                this.mLiveInfos.remove(liveInfo);
                localRemovedLiveInfos.add(liveInfo);
                continue block0;
            }
        }
        MLog.info((Object)TAG, (String)("after removeLiveInfoIfNeeded called with: fullRemovedLiveInfos = [" + fullRemovedLiveInfos + "], local live infos: %s, localRemovedLiveInfos: %s"), (Object[])new Object[]{this.mLiveInfos, localRemovedLiveInfos});
        return localRemovedLiveInfos;
    }

    @Override
    public void addLiveInfos(Set<LiveInfo> liveInfos) {
        super.addLiveInfos(liveInfos);
        this.addUidSet(liveInfos);
    }

    @Override
    public void clearLiveInfos() {
        super.clearLiveInfos();
        this.mUidSet.clear();
    }

    private void addUidSet(Set<LiveInfo> liveInfos) {
        MLog.info((Object)TAG, (String)("before addUidSet called with: current uid set: %s, liveInfos = [" + liveInfos + "]"), (Object[])new Object[]{this.mUidSet});
        List<VideoPlayInfo> playInfos = LiveInfoUtils.getVideoPlayInfos(liveInfos);
        for (VideoPlayInfo playInfo : playInfos) {
            this.mUidSet.add(playInfo.uid);
        }
        MLog.info((Object)TAG, (String)("after addUidSet called with: current uid set: %s, liveInfos = [" + liveInfos + "]"), (Object[])new Object[]{this.mUidSet});
    }

    public String toString() {
        return "MicNoVideoId{mMicNo=" + this.mMicNo + ", mUids=" + this.mUidSet + ", mLiveInfos=" + this.mLiveInfos + '}';
    }
}

