/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.sdkwrapper.flowmanagement.internal.audience.videoid;

import android.support.annotation.NonNull;
import com.yy.mobile.sdkwrapper.flowmanagement.internal.audience.liveinfo.LiveInfoUtils;
import com.yy.mobile.util.exception.ExceptionUtil;
import com.yy.mobile.util.log.MLog;
import com.yy.yylivekit.model.LiveInfo;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public abstract class AbsVideoId {
    protected Set<LiveInfo> mLiveInfos = new HashSet<LiveInfo>();

    @NonNull
    protected abstract String getLogTag();

    @NonNull
    public Set<LiveInfo> getLiveInfosToAdd(List<LiveInfo> liveInfoList) {
        LinkedHashSet<LiveInfo> liveInfoSet = new LinkedHashSet<LiveInfo>();
        for (LiveInfo liveInfo : liveInfoList) {
            if (this.mLiveInfos.contains(liveInfo)) continue;
            liveInfoSet.add(liveInfo);
        }
        return liveInfoSet;
    }

    @NonNull
    public Set<LiveInfo> getLiveInfosToUpdate(List<LiveInfo> liveInfoList) {
        HashSet<LiveInfo> liveInfoSet = new HashSet<LiveInfo>();
        for (LiveInfo liveInfo : liveInfoList) {
            if (!this.mLiveInfos.contains(liveInfo)) continue;
            liveInfoSet.add(liveInfo);
        }
        MLog.info((Object)this.getLogTag(), (String)("getLiveInfosToUpdate called with: liveInfoList = [" + liveInfoList + "], resultList: %s"), (Object[])new Object[]{liveInfoSet});
        return liveInfoSet;
    }

    @NonNull
    public abstract Set<LiveInfo> removeLiveInfoIfNeeded(List<LiveInfo> var1);

    public void addLiveInfos(Set<LiveInfo> liveInfos) {
        MLog.info((Object)this.getLogTag(), (String)("addLiveInfos called with: liveInfos = [" + liveInfos + "]"), (Object[])new Object[0]);
        this.mLiveInfos.addAll(liveInfos);
    }

    public void updateLiveInfos(Set<LiveInfo> liveInfos) {
        MLog.info((Object)this.getLogTag(), (String)("before updateLiveInfos called with: liveInfos = [" + liveInfos + "], localLiveInfos: %s"), (Object[])new Object[]{this.mLiveInfos});
        for (LiveInfo liveInfo : liveInfos) {
            if (!this.mLiveInfos.contains(liveInfo)) {
                ExceptionUtil.throwOrWriteLog(this.getLogTag(), "updateLiveInfos: live info not found: %s, localLiveInfos: %s, externalLiveInfos: %s", liveInfo, this.mLiveInfos, liveInfos);
                continue;
            }
            this.mLiveInfos.remove(liveInfo);
            this.mLiveInfos.add(liveInfo);
        }
        MLog.info((Object)this.getLogTag(), (String)("after updateLiveInfos called with: liveInfos = [" + liveInfos + "], localLiveInfos: %s"), (Object[])new Object[]{this.mLiveInfos});
    }

    public boolean hasVideo() {
        boolean hasVideo = LiveInfoUtils.hasVideo(this.mLiveInfos);
        MLog.info((Object)this.getLogTag(), (String)"hasVideo called: %b, liveInfos: %s", (Object[])new Object[]{hasVideo, this.mLiveInfos});
        return hasVideo;
    }

    public void clearLiveInfos() {
        MLog.info((Object)this.getLogTag(), (String)"clearLiveInfos called: %s", (Object[])new Object[]{this.mLiveInfos});
        this.mLiveInfos.clear();
    }
}

