/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.sdkwrapper.flowmanagement.internal.audience.screenshot;

import android.graphics.Bitmap;
import com.yy.mobile.sdkwrapper.flowmanagement.api.audience.AudienceVideoManager;
import com.yy.mobile.sdkwrapper.flowmanagement.base.audience.screenshot.IAudienceScreenshotManager;
import com.yy.mobile.sdkwrapper.flowmanagement.internal.audience.player.LivePlayerListHolder;
import com.yy.mobile.util.exception.ExceptionUtil;
import com.yy.mobile.util.log.MLog;
import com.yy.yylivekit.audience.LivePlayer;
import com.yy.yylivekit.model.LiveInfo;
import java.util.List;
import java.util.Set;

public class AudienceScreenshotManagerImpl
implements IAudienceScreenshotManager {
    private static final String TAG = "AudienceScreenshotManagerImpl";

    @Override
    public Bitmap getVideoScreenshot(int videoIndex) {
        Bitmap bitmap = null;
        Boolean isNeedMixture = AudienceVideoManager.getInstance().isVideoMixture();
        if (isNeedMixture == null) {
            ExceptionUtil.throwOrWriteLog(TAG, "isNeedMixture is null, unable to get bitmap", new Object[0]);
        } else {
            bitmap = isNeedMixture != false ? this.getMixVideoScreenshot(videoIndex) : this.getOriginalVideoScreenshot(videoIndex);
        }
        return bitmap;
    }

    private Bitmap getOriginalVideoScreenshot(int videoIndex) {
        Bitmap bitmap = this.getOriginalLivePlayerScreenshot(videoIndex);
        MLog.info((Object)TAG, (String)("getOriginalVideoScreenshot called with: videoIndex = [" + videoIndex + "], bitmap: %s"), (Object[])new Object[]{bitmap});
        return bitmap;
    }

    private Bitmap getOriginalLivePlayerScreenshot(int videoIndex) {
        Bitmap bitmap = null;
        List<LivePlayer> players = LivePlayerListHolder.getInstance().getPlayers();
        block0: for (LivePlayer player : players) {
            Set liveInfoSet = player.getAllLiveInfo();
            for (LiveInfo liveInfo : liveInfoSet) {
                if (liveInfo.micNo != videoIndex) continue;
                bitmap = player.getVideoScreenShot();
                continue block0;
            }
        }
        MLog.info((Object)TAG, (String)("getOriginalLivePlayerScreenshot called with: videoIndex = [" + videoIndex + "]"), (Object[])new Object[0]);
        return bitmap;
    }

    private Bitmap getMixVideoScreenshot(int videoIndex) {
        List<LivePlayer> players = LivePlayerListHolder.getInstance().getPlayers();
        Bitmap bitmap = null;
        for (LivePlayer player : players) {
            if (player.getVideoScreenShot() == null) continue;
            bitmap = player.getVideoScreenShot();
            break;
        }
        MLog.info((Object)TAG, (String)("getMixVideoScreenshot called with: videoIndex = [" + videoIndex + "], players: %s, bitmap: %s"), (Object[])new Object[]{players, bitmap});
        return bitmap;
    }

    public static AudienceScreenshotManagerImpl getInstance() {
        return Holder.INSTANCE;
    }

    private AudienceScreenshotManagerImpl() {
    }

    private static class Holder {
        private static final AudienceScreenshotManagerImpl INSTANCE = new AudienceScreenshotManagerImpl();

        private Holder() {
        }
    }
}

