/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.sdkwrapper.flowmanagement.internal.audience.sampling;

import com.yy.mobile.sdkwrapper.flowmanagement.api.audience.liveinfo.LiveInfoChangeEventHandler;
import com.yy.mobile.sdkwrapper.flowmanagement.base.audience.liveinfo.LiveInfoChangeListener;
import com.yy.mobile.sdkwrapper.flowmanagement.base.entity.FlowChannelInfo;
import com.yy.mobile.util.log.MLog;
import com.yy.yylivekit.model.LiveInfo;
import java.util.List;

public class ChannelLiveInfoStatisticsManager
implements LiveInfoChangeListener {
    private static final String TAG = "ChannelLiveInfoStatisticsManager";
    private FlowChannelInfo mChannelInfo;
    private long mJoinChannelStartMillis;
    private long mFirstLiveInfoCostTime;

    public void onJoinChannel(FlowChannelInfo channelInfo) {
        MLog.info((Object)TAG, (String)("onJoinChannel called with: channelInfo = [" + channelInfo + "]"), (Object[])new Object[0]);
        this.mChannelInfo = channelInfo;
        this.mJoinChannelStartMillis = System.currentTimeMillis();
    }

    private void onAddLiveInfo(List<LiveInfo> liveInfoList) {
        if (this.mFirstLiveInfoCostTime > 0L) {
            return;
        }
        this.mFirstLiveInfoCostTime = System.currentTimeMillis() - this.mJoinChannelStartMillis;
        MLog.info((Object)TAG, (String)"first live info cost time: %d, channel info: %s", (Object[])new Object[]{this.mFirstLiveInfoCostTime, this.mChannelInfo});
    }

    public void onLeaveChannel() {
        MLog.info((Object)TAG, (String)"onLeaveChannel called", (Object[])new Object[0]);
        this.mChannelInfo = null;
        this.mFirstLiveInfoCostTime = 0L;
        this.mJoinChannelStartMillis = 0L;
    }

    public static ChannelLiveInfoStatisticsManager getInstance() {
        return Holder.INSTANCE;
    }

    private ChannelLiveInfoStatisticsManager() {
        LiveInfoChangeEventHandler.getInstance().addLiveInfoChangeListener(this);
    }

    @Override
    public void onAddLiveInfos(List<LiveInfo> liveInfos) {
        this.onAddLiveInfo(liveInfos);
    }

    @Override
    public void onRemoveLiveInfos(List<LiveInfo> liveInfos) {
    }

    @Override
    public void onUpdateLiveInfos(List<LiveInfo> fromLiveInfos, List<LiveInfo> toLiveInfos) {
    }

    private static class Holder {
        private static final ChannelLiveInfoStatisticsManager INSTANCE = new ChannelLiveInfoStatisticsManager();

        private Holder() {
        }
    }
}

