/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.sdkwrapper.flowmanagement.internal.audience.sampling;

import com.yy.mobile.sdkwrapper.flowmanagement.base.audience.playstatus.VideoPlayStatus;
import com.yy.mobile.sdkwrapper.flowmanagement.base.entity.VideoPlayInfo;
import com.yy.mobile.util.log.MLog;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AudienceVideoStatisticsManager {
    private static final String TAG = "AudienceVideoStatisticsManager";
    private Map<Long, VideoPlayInfo> mPlayInfoMap = new HashMap<Long, VideoPlayInfo>();

    public void reset() {
        MLog.info((Object)TAG, (String)"reset called", (Object[])new Object[0]);
        this.mPlayInfoMap.clear();
    }

    public void updatePlayStatistics(List<VideoPlayInfo> playInfos, VideoPlayStatus playStatus) {
        MLog.debug((Object)TAG, (String)("updatePlayStatistics called with: playInfos = [" + playInfos + "], playStatus = [" + (Object)((Object)playStatus) + "]"), (Object[])new Object[0]);
        switch (playStatus) {
            case LOADING: {
                this.onLoading(playInfos);
                break;
            }
            case PLAYING: {
                this.onPlaying(playInfos);
                break;
            }
            case STOP: {
                this.onStop(playInfos);
                break;
            }
        }
    }

    private void onLoading(List<VideoPlayInfo> playInfos) {
        for (VideoPlayInfo playInfo : playInfos) {
            long uid = playInfo.uid;
            playInfo.playStartMillis = System.currentTimeMillis();
            playInfo.playDuration = 0L;
            playInfo.loadDuration = 0L;
            this.mPlayInfoMap.put(uid, playInfo);
            MLog.debug((Object)TAG, (String)"onLoading: %s", (Object[])new Object[]{playInfo});
        }
    }

    private void onPlaying(List<VideoPlayInfo> playInfos) {
        for (VideoPlayInfo playInfo : playInfos) {
            long uid = playInfo.uid;
            VideoPlayInfo prePlayInfo = this.mPlayInfoMap.get(uid);
            if (prePlayInfo == null || prePlayInfo.playStartMillis == 0L) {
                MLog.error((Object)TAG, (String)"[Bug]onPlaying called, invalid pre play info not, uid: %d, prePlayInfo: %s", (Object[])new Object[]{uid, prePlayInfo});
                continue;
            }
            playInfo.playStartMillis = prePlayInfo.playStartMillis;
            playInfo.loadDuration = System.currentTimeMillis() - prePlayInfo.playStartMillis;
            MLog.debug((Object)TAG, (String)"onPlaying: %s", (Object[])new Object[]{playInfo});
        }
    }

    private void onStop(List<VideoPlayInfo> playInfos) {
        for (VideoPlayInfo playInfo : playInfos) {
            long uid = playInfo.uid;
            VideoPlayInfo prePlayInfo = this.mPlayInfoMap.get(uid);
            if (prePlayInfo == null || prePlayInfo.playStartMillis == 0L) {
                MLog.error((Object)TAG, (String)"[Bug]onStop called, invalid pre play info not, uid: %d, prePlayInfo: %s", (Object[])new Object[]{uid, prePlayInfo});
                continue;
            }
            playInfo.playStartMillis = prePlayInfo.playStartMillis;
            playInfo.loadDuration = prePlayInfo.loadDuration;
            playInfo.playDuration = System.currentTimeMillis() - prePlayInfo.playStartMillis;
            MLog.debug((Object)TAG, (String)"onStop: %s", (Object[])new Object[]{playInfo});
            this.mPlayInfoMap.remove(uid);
        }
    }

    public static AudienceVideoStatisticsManager getInstance() {
        return Holder.INSTANCE;
    }

    private AudienceVideoStatisticsManager() {
    }

    private static class Holder {
        private static final AudienceVideoStatisticsManager INSTANCE = new AudienceVideoStatisticsManager();

        private Holder() {
        }
    }
}

