/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.sdkwrapper.flowmanagement.internal.audience.radioplayer;

import com.yy.mobile.sdkwrapper.flowmanagement.base.audience.groupinfo.GroupInfoChangeEventHandler;
import com.yy.mobile.sdkwrapper.flowmanagement.base.audience.groupinfo.IGroupInfoChangeListener;
import com.yy.mobile.sdkwrapper.flowmanagement.internal.audience.groupinfo.GroupInfoListHolder;
import com.yy.mobile.sdkwrapper.flowmanagement.internal.audience.radioplayer.IRadioPlayerManager;
import com.yy.mobile.sdkwrapper.flowmanagement.internal.audience.radioplayer.RadioPlayerHolder;
import com.yy.mobile.sdkwrapper.flowmanagement.internal.audio.AudioManagerImpl;
import com.yy.mobile.util.log.MLog;
import com.yy.yylivekit.audience.RadioPlayer;
import com.yy.yylivekit.model.GroupInfo;
import java.util.HashSet;
import java.util.List;

public class RadioPlayerManagerImpl
implements IRadioPlayerManager,
IGroupInfoChangeListener {
    private static final String TAG = "RadioPlayerManagerImpl";
    private RadioPlayerHolder mRadioPlayerHolder = RadioPlayerHolder.getInstance();
    private boolean mIsStartPlay;

    public RadioPlayer getOrCreateRadioPlayer() {
        MLog.info((Object)TAG, (String)"getOrCreateRadioPlayer:", (Object[])new Object[0]);
        RadioPlayer radioPlayer = this.mRadioPlayerHolder.getOrCreateRadioPlayer();
        radioPlayer.addGroupInfo(new HashSet<GroupInfo>(GroupInfoListHolder.getInstance().getGroupInfoList()));
        return radioPlayer;
    }

    @Override
    public void play() {
        if (!AudioManagerImpl.getInstance().isNeedToSubscribeAudio()) {
            MLog.info((Object)TAG, (String)"no need to subscribe audio, ignore play radio", (Object[])new Object[0]);
            return;
        }
        MLog.info((Object)TAG, (String)"play radio", (Object[])new Object[0]);
        this.mRadioPlayerHolder.play();
        this.mIsStartPlay = true;
    }

    @Override
    public void stopPlay() {
        this.mRadioPlayerHolder.stop();
        this.mIsStartPlay = false;
    }

    @Override
    public void releaseRadioPlayer() {
        this.mIsStartPlay = false;
        this.mRadioPlayerHolder.releaseRadioPlayer();
    }

    @Override
    public void onAddGroupInfoList(List<GroupInfo> listToAdd, List<GroupInfo> finalGroupInfos) {
        MLog.info((Object)TAG, (String)"onAddGroupInfoList: ", (Object[])new Object[0]);
        this.getOrCreateRadioPlayer();
        if (this.mIsStartPlay) {
            MLog.info((Object)TAG, (String)"onAddGroupInfoList: mIsStartPlay = true", (Object[])new Object[0]);
            this.play();
        }
    }

    @Override
    public void onRemoveGroupInfoList(List<GroupInfo> listToRemove, List<GroupInfo> finalGroupInfos) {
        MLog.info((Object)TAG, (String)"onRemoveGroupInfoList:", (Object[])new Object[0]);
        RadioPlayer radioPlayer = this.mRadioPlayerHolder.getOrCreateRadioPlayer();
        radioPlayer.removeGroupInfo(new HashSet<GroupInfo>(listToRemove));
    }

    public void init() {
        GroupInfoChangeEventHandler.getInstance().addGroupInfoChangeListener(this);
    }

    private RadioPlayerManagerImpl() {
    }

    public static RadioPlayerManagerImpl getInstance() {
        return Holder.INSTANCE;
    }

    private static class Holder {
        private static RadioPlayerManagerImpl INSTANCE = new RadioPlayerManagerImpl();

        private Holder() {
        }
    }
}

