/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.sdkwrapper.flowmanagement.internal.audience.playstatus;

import com.yy.mobile.sdkwrapper.flowmanagement.base.audience.playstatus.VideoPlayStatus;
import com.yy.mobile.sdkwrapper.flowmanagement.base.entity.VideoPlayInfo;
import com.yy.mobile.util.log.MLog;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class VideoPlayInfoListHolder {
    private static final String TAG = "VideoPlayInfoListHolder";
    private Set<VideoPlayInfo> mVideoPlayInfoSet = new LinkedHashSet<VideoPlayInfo>();

    public void updatePlayInfo(VideoPlayStatus playStatus, List<VideoPlayInfo> playInfos) {
        MLog.info((Object)TAG, (String)("updatePlayInfo called with: playStatus = [" + (Object)((Object)playStatus) + "], playInfo = [" + playInfos + "]"), (Object[])new Object[0]);
        switch (playStatus) {
            case LOADING: {
                this.onVideoLoading(playInfos);
                break;
            }
            case PLAYING: {
                this.onVideoPlaying(playInfos);
                break;
            }
            case STOP: {
                this.onVideoStop(playInfos);
                break;
            }
        }
    }

    public List<VideoPlayInfo> getVideoPlayInfos() {
        return new ArrayList<VideoPlayInfo>(this.mVideoPlayInfoSet);
    }

    private void onVideoStop(List<VideoPlayInfo> playInfos) {
        String oldSetStr = this.mVideoPlayInfoSet.toString();
        MLog.info((Object)TAG, (String)("onVideoStop called with: playInfo = [" + playInfos + "], before set: %s"), (Object[])new Object[]{oldSetStr});
        this.mVideoPlayInfoSet.removeAll(playInfos);
        MLog.info((Object)TAG, (String)("onVideoStop called with: playInfo = [" + playInfos + "], after set: %s"), (Object[])new Object[]{this.mVideoPlayInfoSet});
    }

    private void onVideoPlaying(List<VideoPlayInfo> playInfos) {
        String oldSetStr = this.mVideoPlayInfoSet.toString();
        MLog.info((Object)TAG, (String)("onVideoPlaying called with: playInfo = [" + playInfos + "], before set: %s"), (Object[])new Object[]{oldSetStr});
        this.mVideoPlayInfoSet.addAll(playInfos);
        MLog.info((Object)TAG, (String)("onVideoPlaying called with: playInfo = [" + playInfos + "], after set: %s"), (Object[])new Object[]{this.mVideoPlayInfoSet});
    }

    private void onVideoLoading(List<VideoPlayInfo> playInfos) {
        String oldSetStr = this.mVideoPlayInfoSet.toString();
        MLog.info((Object)TAG, (String)("onVideoLoading called with: playInfo = [" + playInfos + "], before set: %s"), (Object[])new Object[]{oldSetStr});
        this.mVideoPlayInfoSet.addAll(playInfos);
        MLog.info((Object)TAG, (String)("onVideoLoading called with: playInfo = [" + playInfos + "], after set: %s"), (Object[])new Object[]{this.mVideoPlayInfoSet});
    }

    public void reset() {
        MLog.info((Object)TAG, (String)"reset called, playInfos: %s", (Object[])new Object[]{this.mVideoPlayInfoSet});
        this.mVideoPlayInfoSet.clear();
    }

    public static VideoPlayInfoListHolder getInstance() {
        return Holder.INSTANCE;
    }

    private VideoPlayInfoListHolder() {
    }

    private static class Holder {
        private static final VideoPlayInfoListHolder INSTANCE = new VideoPlayInfoListHolder();

        private Holder() {
        }
    }
}

