/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.sdkwrapper.flowmanagement.internal.audience.player.eventhandler;

import com.medialib.video.MediaVideoMsg;
import com.yy.mobile.RxBus;
import com.yy.mobile.sdkwrapper.flowmanagement.internal.videoinfo.VideoDebugInfoManagerImpl;
import com.yy.mobile.sdkwrapper.yylive.media.event.VideoViewerStatInfoEventArgs;
import com.yy.mobile.util.log.MLog;
import com.yy.yylivekit.ILivePlayer;
import java.util.HashMap;
import java.util.Map;

public class ViewerEventHandler
implements ILivePlayer.ViewerEventHandler {
    private static final String TAG = "ViewerEventHandler";

    public void onVideoViewerStatNotify(ILivePlayer player, MediaVideoMsg.VideoViewerStatInfo statInfo) {
        MLog.info((Object)TAG, (String)("onVideoViewerStatNotify called with: player = [" + player + "], statInfo = [" + statInfo + "]"), (Object[])new Object[0]);
        VideoDebugInfoManagerImpl.getInstance().onVideoViewerStatNotify(player, statInfo);
        this.notifyViewerStat(statInfo);
    }

    private void notifyViewerStat(MediaVideoMsg.VideoViewerStatInfo info) {
        if (info != null) {
            HashMap<Long, Map<Integer, Integer>> streamMap = new HashMap<Long, Map<Integer, Integer>>();
            for (Map.Entry entry : info.streamMap.entrySet()) {
                streamMap.put((Long)entry.getKey(), ((MediaVideoMsg.StreamStatInfo)entry.getValue()).dataMap);
            }
            RxBus.getDefault().post((Object)new VideoViewerStatInfoEventArgs(info.uid, info.statMap, streamMap));
        }
    }

    public static ViewerEventHandler getInstance() {
        return Holder.INSTANCE;
    }

    private ViewerEventHandler() {
    }

    private static class Holder {
        private static final ViewerEventHandler INSTANCE = new ViewerEventHandler();

        private Holder() {
        }
    }
}

