/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.sdkwrapper.flowmanagement.internal.audience.player.eventhandler;

import com.medialib.video.MediaVideoMsg;
import com.yy.mobile.RxBus;
import com.yy.mobile.sdkwrapper.flowmanagement.base.audience.videostatus.VideoStatusEventHandlerImpl;
import com.yy.mobile.sdkwrapper.flowmanagement.base.entity.AudienceVideoQuality;
import com.yy.mobile.sdkwrapper.flowmanagement.event.audience.FirstFrameRenderNotifyEvent;
import com.yy.mobile.sdkwrapper.flowmanagement.event.rxbus.FlowRxBus;
import com.yy.mobile.sdkwrapper.flowmanagement.internal.audience.videoquality.AudienceVideoQualityManagerImpl;
import com.yy.mobile.sdkwrapper.flowmanagement.internal.videoinfo.VideoDebugInfoManagerImpl;
import com.yy.mobile.sdkwrapper.flowmanagement.internal.videolayout.videosize.AudienceVideoSizeChangeEventHandlerImpl;
import com.yy.mobile.sdkwrapper.yylive.media.event.VideoPlayDelayInfoEventArgs;
import com.yy.mobile.util.log.MLog;
import com.yy.yylivekit.ILivePlayer;
import com.yy.yylivekit.model.LiveInfo;
import com.yy.yylivekit.model.LiveKitMsg;

public class QosEventHandler
implements ILivePlayer.QosEventHandler {
    private static final String TAG = "QosEventHandler";
    private static int seq = 0;

    public void onUpdateVideoFps(ILivePlayer player, LiveInfo liveInfo, MediaVideoMsg.FpsInfo fps) {
        MLog.info((Object)TAG, (String)("onUpdateVideoFps called with: liveInfo = [" + liveInfo + "], fps = [" + fps + "]"), (Object[])new Object[0]);
    }

    public void onLossVideoFrame(ILivePlayer player, LiveInfo liveInfo, MediaVideoMsg.VideoFrameLossInfo frameLoss) {
    }

    public void onFirstFrameNotify(ILivePlayer player, LiveInfo liveInfo, MediaVideoMsg.FirstFrameRenderNotify firstFrame) {
        MLog.info((Object)TAG, (String)("onFirstFrameNotify called with: liveInfo = [" + liveInfo + "], firstFrame = [" + firstFrame + "]"), (Object[])new Object[0]);
        FlowRxBus.getInstance().post((Object)new FirstFrameRenderNotifyEvent());
    }

    public void onVideoLostNotify(ILivePlayer player, LiveInfo liveInfo, MediaVideoMsg.NoVideoInfo info) {
        MLog.info((Object)TAG, (String)("onVideoLostNotify called with: liveInfo = [" + liveInfo + "], info = [" + info + "]"), (Object[])new Object[0]);
    }

    public void onVideoDecoderNotify(ILivePlayer player, LiveInfo liveInfo, MediaVideoMsg.VideoDecoderInfo decoderInfo) {
        MLog.info((Object)TAG, (String)"onVideoDecoderNotify, type: %d, codecId: %d", (Object[])new Object[]{decoderInfo.type, decoderInfo.codecId});
        VideoDebugInfoManagerImpl.getInstance().onVideoDecoderNotify(player, liveInfo, decoderInfo);
    }

    public void onVideoCodeRateChange(ILivePlayer player, LiveInfo liveInfo, LiveKitMsg.VideoCodeRateChange codeRateInfo) {
        MLog.info((Object)TAG, (String)("onVideoCodeRateChangeNotify called with: codeRateInfo = [" + codeRateInfo + "], liveInfo = [" + liveInfo + "]"), (Object[])new Object[0]);
        VideoDebugInfoManagerImpl.getInstance().onVideoSelectedCodeRateChange(player, liveInfo, codeRateInfo);
        if (codeRateInfo != null && (liveInfo.micNo == 0 || liveInfo.isMix)) {
            AudienceVideoQualityManagerImpl.getInstance().onVideoCodeRateChangeNotify(codeRateInfo.uid, codeRateInfo.codeRate, AudienceVideoQuality.from(codeRateInfo.quality));
        }
    }

    public void onVideoCodeRateList(ILivePlayer player, LiveInfo liveInfo, LiveKitMsg.VideoCodeRateInfo codeRateInfo) {
        MLog.info((Object)TAG, (String)("onVideoCodeRateNotify called with: , codeRateInfo = [" + codeRateInfo + "], player = [" + player + "], liveInfo = [" + liveInfo + "]"), (Object[])new Object[0]);
        VideoDebugInfoManagerImpl.getInstance().onVideoCodeRateListChange(player, liveInfo, codeRateInfo);
    }

    public void onVideoSizeChanged(ILivePlayer player, LiveInfo liveInfo, MediaVideoMsg.VideoSizeInfo info) {
        MLog.info((Object)TAG, (String)("onVideoSizeChanged called with: , sizeInfo = [" + info + "], player = [" + player + "], liveInfo = [" + liveInfo + "]"), (Object[])new Object[0]);
        VideoDebugInfoManagerImpl.getInstance().onVideoSizeChanged(player, liveInfo, info);
        AudienceVideoSizeChangeEventHandlerImpl.getInstance().onVideoDecodeSizeChanged(player, liveInfo, info);
    }

    public void onVideoEncodeInfoChange(ILivePlayer player, LiveInfo liveInfo, LiveKitMsg.VideoEncodeInfoChange videoEncodeInfoChange) {
        MLog.info((Object)TAG, (String)("onVideoEncodeInfoChange called with: player = [" + player + "], liveInfo = [" + liveInfo + "], videoEncodeInfoChange = [" + videoEncodeInfoChange + "]"), (Object[])new Object[0]);
        VideoDebugInfoManagerImpl.getInstance().onVideoEncodeInfoChange(player, liveInfo, videoEncodeInfoChange);
    }

    public void onVideoStatusChange(ILivePlayer player, LiveInfo liveInfo, boolean hasVideo) {
        MLog.info((Object)TAG, (String)("onVideoStatusChange called with: player = [" + player + "], liveInfo = [" + liveInfo + "], hasVideo = [" + hasVideo + "]"), (Object[])new Object[0]);
        VideoStatusEventHandlerImpl.getInstance().notifyVideoStatusChange(hasVideo);
    }

    public void onFirstFrameRenderNotify(ILivePlayer player, LiveInfo liveInfo, MediaVideoMsg.FirstFrameSeeInfo firstFrame) {
        MLog.info((Object)TAG, (String)("onFirstFrameRenderNotify() called with: player = [" + player + "], liveInfo = [" + liveInfo + "], firstFrame = [" + firstFrame + "]"), (Object[])new Object[0]);
    }

    public void onVideoPlayDelayInfoEvent(long uid, int playDelay) {
        if (seq++ % 20 == 0) {
            MLog.info((Object)TAG, (String)("onVideoPlayDelayInfoEvent() called with: uid = [" + uid + "], playDelay = [" + playDelay + "], seq:" + seq), (Object[])new Object[0]);
        }
        RxBus.getDefault().post((Object)new VideoPlayDelayInfoEventArgs(uid, playDelay));
    }

    public static ILivePlayer.QosEventHandler getInstance() {
        return Holder.INSTANCE;
    }

    private QosEventHandler() {
    }

    private static class Holder {
        private static final QosEventHandler INSTANCE = new QosEventHandler();

        private Holder() {
        }
    }
}

