/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.sdkwrapper.flowmanagement.internal.audience.player.eventhandler;

import com.yy.mobile.sdkwrapper.flowmanagement.base.audience.playstatus.VideoPlayStatus;
import com.yy.mobile.sdkwrapper.flowmanagement.base.audience.playstatus.VideoPlayStatusEventHandlerImpl;
import com.yy.mobile.sdkwrapper.flowmanagement.internal.videoinfo.VideoDebugInfoManagerImpl;
import com.yy.mobile.util.log.MLog;
import com.yy.yylivekit.ILivePlayer;
import com.yy.yylivekit.model.LiveInfo;
import com.yy.yylivekit.model.StreamInfo;

public class PlayerEventHandler
implements ILivePlayer.PlayerEventHandler {
    private static final String TAG = "PlayerEventHandler_peh";

    public void onStart(ILivePlayer player, LiveInfo liveInfo, StreamInfo streamInfo) {
        MLog.info((Object)TAG, (String)("====onStart called with: liveInfo = [" + liveInfo + "]"), (Object[])new Object[0]);
        VideoPlayStatusEventHandlerImpl.getInstance().notifyPlayStatusChanged(player, liveInfo, streamInfo, VideoPlayStatus.LOADING);
    }

    public void onPlaying(ILivePlayer player, LiveInfo liveInfo, StreamInfo streamInfo) {
        MLog.info((Object)TAG, (String)("====onPlaying called with: liveInfo = [" + liveInfo + "], streamInfo = [" + streamInfo + "]"), (Object[])new Object[0]);
        if (streamInfo == null) {
            MLog.error((Object)TAG, (String)"[Bug]onPlaying, streamInfo is null, player: %s, liveInfo: %s", (Object[])new Object[]{player, liveInfo});
            return;
        }
        VideoDebugInfoManagerImpl.getInstance().onVideoPlaying(player, liveInfo, streamInfo);
        VideoPlayStatusEventHandlerImpl.getInstance().notifyPlayStatusChanged(player, liveInfo, streamInfo, VideoPlayStatus.PLAYING);
    }

    public void onStop(ILivePlayer player, LiveInfo liveInfo, StreamInfo streamInfo) {
        MLog.info((Object)TAG, (String)("====onStop called with: liveInfo = [" + liveInfo + "], streamInfo = [" + streamInfo + "]"), (Object[])new Object[0]);
        VideoDebugInfoManagerImpl.getInstance().onVideoStop(player, liveInfo, streamInfo);
        VideoPlayStatusEventHandlerImpl.getInstance().notifyPlayStatusChanged(player, liveInfo, streamInfo, VideoPlayStatus.STOP);
    }

    public static ILivePlayer.PlayerEventHandler getInstance() {
        return Holder.INSTANCE;
    }

    private PlayerEventHandler() {
    }

    private static class Holder {
        private static final PlayerEventHandler INSTANCE = new PlayerEventHandler();

        private Holder() {
        }
    }
}

